/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.osgi.runtime.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.project.IProjectBuilder;
import org.springframework.ide.eclipse.osgi.runtime.builder.OsgiUpdateJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiBundleUpdateBuilder
implements IProjectBuilder {
    public void build(Set<IResource> affectedResources, int kind, IProgressMonitor monitor) throws CoreException {
        Map<IProject, Set<IResource>> projects = this.groupResourcesByProject(affectedResources);
        for (Map.Entry<IProject, Set<IResource>> project : projects.entrySet()) {
            IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(project.getKey());
            BundleDescription description = model.getBundleDescription();
            String symbolicName = description.getSymbolicName();
            OsgiUpdateJob.schedule(symbolicName, Command.REFRESH);
        }
    }

    public void cleanup(IResource resource, IProgressMonitor monitor) throws CoreException {
    }

    public Set<IResource> getAffectedResources(IResource resource, int kind, int deltaKind) throws CoreException {
        if (resource instanceof IFile && SpringCoreUtils.hasNature((IResource)resource, (String)"org.eclipse.pde.PluginNature") && JdtUtils.isJavaProject((IResource)resource)) {
            IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(resource.getProject());
            HashSet<IResource> resources = new HashSet<IResource>();
            if (model != null) {
                resources.add(resource);
            }
            return resources;
        }
        return Collections.emptySet();
    }

    private Map<IProject, Set<IResource>> groupResourcesByProject(Set<IResource> affectedResources) {
        HashMap<IProject, Set<IResource>> projects = new HashMap<IProject, Set<IResource>>();
        for (IResource resource : affectedResources) {
            if (projects.containsKey(resource.getProject())) {
                ((Set)projects.get(resource.getProject())).add(resource);
                continue;
            }
            HashSet<IResource> resources = new HashSet<IResource>();
            resources.add(resource);
            projects.put(resource.getProject(), resources);
        }
        return projects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        REFRESH;

    }
}

