/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core.issue;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.LabelService;
import org.eclipse.egit.github.core.service.MilestoneService;
import org.eclipse.egit.github.core.util.LabelComparator;
import org.eclipse.egit.github.core.util.MilestoneComparator;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.QueryUtils;
import org.eclipse.mylyn.internal.github.core.RepositoryConnector;
import org.eclipse.mylyn.internal.github.core.issue.IssueTaskDataHandler;
import org.eclipse.mylyn.internal.github.core.issue.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueConnector
extends RepositoryConnector {
    public static final String KIND = "github";
    private final IssueTaskDataHandler taskDataHandler;
    private final Map<TaskRepository, List<Label>> repositoryLabels = Collections.synchronizedMap(new HashMap());
    private final Map<TaskRepository, List<Milestone>> repositoryMilestones = Collections.synchronizedMap(new HashMap());

    public static String getRepositoryLabel(IRepositoryIdProvider repo) {
        return String.valueOf(repo.generateId()) + Messages.IssueConnector_LabelIssues;
    }

    public static TaskRepository createTaskRepository(Repository repo, String username, String password) {
        String url = GitHub.createGitHubUrl(repo.getOwner().getLogin(), repo.getName());
        TaskRepository repository = new TaskRepository(KIND, url);
        repository.setProperty("label", IssueConnector.getRepositoryLabel((IRepositoryIdProvider)repo));
        if (username != null && password != null) {
            repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(username, password), true);
        }
        repository.setProperty("category", "org.eclipse.mylyn.category.bugs");
        return repository;
    }

    public static GitHubClient createClient(TaskRepository repository) {
        GitHubClient client = GitHubClient.createClient((String)repository.getRepositoryUrl());
        GitHub.addCredentials(client, repository);
        return GitHub.configureClient(client);
    }

    public IssueConnector() {
        this.taskDataHandler = new IssueTaskDataHandler(this);
    }

    public List<Label> refreshLabels(TaskRepository repository) throws CoreException {
        Assert.isNotNull((Object)repository, (String)"Repository cannot be null");
        RepositoryId repo = GitHub.getRepository(repository.getRepositoryUrl());
        GitHubClient client = IssueConnector.createClient(repository);
        LabelService service = new LabelService(client);
        try {
            List labels = service.getLabels(repo.getOwner(), repo.getName());
            Collections.sort(labels, new LabelComparator());
            this.repositoryLabels.put(repository, labels);
            return labels;
        }
        catch (IOException e) {
            throw new CoreException(GitHub.createWrappedStatus(e));
        }
    }

    public List<Label> getLabels(TaskRepository repository) {
        Assert.isNotNull((Object)repository, (String)"Repository cannot be null");
        LinkedList<Label> labels = new LinkedList<Label>();
        List<Label> cached = this.repositoryLabels.get(repository);
        if (cached != null) {
            labels.addAll(cached);
        }
        return labels;
    }

    public boolean hasCachedLabels(TaskRepository repository) {
        return this.repositoryLabels.containsKey(repository);
    }

    public List<Milestone> refreshMilestones(TaskRepository repository) throws CoreException {
        Assert.isNotNull((Object)repository, (String)"Repository cannot be null");
        RepositoryId repo = GitHub.getRepository(repository.getRepositoryUrl());
        GitHubClient client = IssueConnector.createClient(repository);
        MilestoneService service = new MilestoneService(client);
        try {
            LinkedList<Milestone> milestones = new LinkedList<Milestone>();
            milestones.addAll(service.getMilestones(repo.getOwner(), repo.getName(), "open"));
            milestones.addAll(service.getMilestones(repo.getOwner(), repo.getName(), "closed"));
            Collections.sort(milestones, new MilestoneComparator());
            this.repositoryMilestones.put(repository, milestones);
            return milestones;
        }
        catch (IOException e) {
            throw new CoreException(GitHub.createWrappedStatus(e));
        }
    }

    public List<Milestone> getMilestones(TaskRepository repository) {
        Assert.isNotNull((Object)repository, (String)"Repository cannot be null");
        LinkedList<Milestone> milestones = new LinkedList<Milestone>();
        List<Milestone> cached = this.repositoryMilestones.get(repository);
        if (cached != null) {
            milestones.addAll(cached);
        }
        return milestones;
    }

    public boolean hasCachedMilestones(TaskRepository repository) {
        return this.repositoryMilestones.containsKey(repository);
    }

    @Override
    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    @Override
    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public String getConnectorKind() {
        return KIND;
    }

    public String getLabel() {
        return Messages.IssueConnector_LabelConnector;
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector collector, ISynchronizationSession session, IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        List<String> statuses = QueryUtils.getAttributes("state", query);
        monitor.beginTask(Messages.IssueConector_TaskQuerying, statuses.size());
        try {
            List<String> labels;
            String milestone;
            String assignee;
            RepositoryId repo = GitHub.getRepository(repository.getRepositoryUrl());
            GitHubClient client = IssueConnector.createClient(repository);
            IssueService service = new IssueService(client);
            HashMap<String, String> filterData = new HashMap<String, String>();
            String mentions = query.getAttribute("mentioned");
            if (mentions != null) {
                filterData.put("mentioned", mentions);
            }
            if ((assignee = query.getAttribute("assignee")) != null) {
                filterData.put("assignee", assignee);
            }
            if ((milestone = query.getAttribute("milestone")) != null) {
                filterData.put("milestone", milestone);
            }
            if (!(labels = QueryUtils.getAttributes("labels", query)).isEmpty()) {
                StringBuilder labelsQuery = new StringBuilder();
                for (String label : labels) {
                    labelsQuery.append(label).append(',');
                }
                filterData.put("labels", labelsQuery.toString());
            }
            String owner = repo.getOwner();
            String name = repo.getName();
            for (String status : statuses) {
                filterData.put("state", status);
                List issues = service.getIssues(repo.getOwner(), repo.getName(), filterData);
                for (Issue issue : issues) {
                    if (this.isPullRequest(issue)) continue;
                    List comments = null;
                    if (issue.getComments() > 0) {
                        comments = service.getComments(owner, name, Integer.toString(issue.getNumber()));
                    }
                    TaskData taskData = this.taskDataHandler.createTaskData(repository, monitor, owner, name, issue, comments);
                    collector.accept(taskData);
                }
                monitor.worked(1);
            }
        }
        catch (IOException e) {
            result = GitHub.createWrappedStatus(e);
        }
        monitor.done();
        return result;
    }

    private boolean isPullRequest(Issue issue) {
        PullRequest request = issue.getPullRequest();
        return request != null && request.getDiffUrl() != null;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        Issue issue;
        IssueService service;
        RepositoryId repo;
        block4: {
            repo = GitHub.getRepository(repository.getRepositoryUrl());
            try {
                GitHubClient client = IssueConnector.createClient(repository);
                service = new IssueService(client);
                issue = service.getIssue(repo.getOwner(), repo.getName(), taskId);
                if (!this.isPullRequest(issue)) break block4;
                return null;
            }
            catch (IOException e) {
                throw new CoreException(GitHub.createWrappedStatus(e));
            }
        }
        List comments = null;
        if (issue.getComments() > 0) {
            comments = service.getComments(repo.getOwner(), repo.getName(), taskId);
        }
        return this.taskDataHandler.createTaskData(repository, monitor, repo.getOwner(), repo.getName(), issue, comments);
    }

    public String getRepositoryUrlFromTaskUrl(String taskFullUrl) {
        Matcher matcher;
        if (taskFullUrl != null && (matcher = Pattern.compile("(http://.+?)/issues/issue/([^/]+)").matcher(taskFullUrl)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public String getTaskIdFromTaskUrl(String taskFullUrl) {
        Matcher matcher;
        if (taskFullUrl != null && (matcher = Pattern.compile(".+?/issues/issue/([^/]+)").matcher(taskFullUrl)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public String getTaskUrl(String repositoryUrl, String taskId) {
        return String.valueOf(repositoryUrl) + "/issues/issue/" + taskId;
    }

    @Override
    public void updateRepositoryConfiguration(TaskRepository taskRepository, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        monitor.beginTask("", 2);
        monitor.setTaskName(Messages.IssueConnector_TaskUpdatingLabels);
        this.refreshLabels(taskRepository);
        monitor.worked(1);
        monitor.setTaskName(Messages.IssueConnector_TaskUpdatingMilestones);
        this.refreshMilestones(taskRepository);
        monitor.done();
    }
}

