/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.dashboard.ui.AbstractDashboardPart;
import org.springsource.ide.eclipse.dashboard.ui.IEnabledDashboardPart;

public abstract class AbstractDashboardPage
extends FormPage {
    private static final String EXTENSION_ID_DASHBOARD = "com.springsource.sts.ide.ui.dashboard";
    private static final String ELEMENT_PART = "part";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_PAGE = "page";
    private static final String ATTRIBUTE_CLASS = "class";
    private List<PartDescriptor> partDescriptors;

    public AbstractDashboardPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public AbstractDashboardPage(String id, String title) {
        super(id, title);
    }

    protected List<AbstractDashboardPart> contributeParts(Composite parent, String path) {
        if (this.partDescriptors == null) {
            this.readExtensions();
        }
        return this.createParts(parent, path, this.partDescriptors);
    }

    private List<AbstractDashboardPart> createParts(final Composite parent, String path, Collection<PartDescriptor> descriptors) {
        final List<AbstractDashboardPart> parts = Collections.synchronizedList(new ArrayList());
        Iterator<PartDescriptor> it = descriptors.iterator();
        while (it.hasNext()) {
            final PartDescriptor descriptor = it.next();
            if (path != null && !path.equals(descriptor.getPath())) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Error creating dashboard part: \"" + descriptor.getId() + "\"", e));
                }

                public void run() throws Exception {
                    AbstractDashboardPart part = descriptor.createPart();
                    if (part != null) {
                        if (part instanceof IEnabledDashboardPart && !((IEnabledDashboardPart)((Object)part)).shouldAdd()) {
                            return;
                        }
                        part.setId(descriptor.getId());
                        parts.add(part);
                        AbstractDashboardPage.this.initializePart(parent, part);
                    }
                }
            });
            it.remove();
        }
        return parts;
    }

    private void initializePart(Composite parent, AbstractDashboardPart part) {
        this.getManagedForm().addPart((IFormPart)part);
        part.initialize(this.getManagedForm());
        part.createControl(parent);
        if (part.getControl() != null) {
            if (parent.getLayout() instanceof GridLayout) {
                GridDataFactory.fillDefaults().align(4, 4).grab(false, true).applyTo(part.getControl());
            } else if (parent.getLayout() instanceof TableWrapLayout) {
                part.getControl().setLayoutData((Object)new TableWrapData(256));
            }
        }
    }

    private void readExtensions() {
        IExtension[] extensions;
        this.partDescriptors = new ArrayList<PartDescriptor>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_DASHBOARD);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(ELEMENT_PART)) {
                    this.readPartExtension(element);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void readPartExtension(IConfigurationElement element) {
        String page = element.getAttribute(ATTRIBUTE_PAGE);
        if (this.getId().equals(page)) {
            this.partDescriptors.add(new ExtensionPartDescriptor(element));
        }
    }

    private static class ExtensionPartDescriptor
    extends PartDescriptor {
        private final IConfigurationElement element;

        public ExtensionPartDescriptor(IConfigurationElement element) {
            super(element.getAttribute(AbstractDashboardPage.ATTRIBUTE_ID));
            this.element = element;
            this.setPath(element.getAttribute(AbstractDashboardPage.ATTRIBUTE_PATH));
        }

        @Override
        public AbstractDashboardPart createPart() {
            Object object;
            block3: {
                try {
                    object = WorkbenchPlugin.createExtension((IConfigurationElement)this.element, (String)AbstractDashboardPage.ATTRIBUTE_CLASS);
                    if (object instanceof AbstractDashboardPart) break block3;
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not load " + object.getClass().getCanonicalName() + " must implement " + AbstractDashboardPart.class.getCanonicalName()));
                    return null;
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not read dashboard extension", (Throwable)e));
                    return null;
                }
            }
            return (AbstractDashboardPart)((Object)object);
        }
    }

    private static abstract class PartDescriptor {
        private final String id;
        private String path;

        public PartDescriptor(String id) {
            Assert.isNotNull((Object)id);
            this.id = id;
        }

        public abstract AbstractDashboardPart createPart();

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            PartDescriptor other = (PartDescriptor)obj;
            return this.id.equals(other.id);
        }

        public final String getId() {
            return this.id;
        }

        public final String getPath() {
            return this.path;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.id.hashCode();
            return result;
        }

        public final PartDescriptor setPath(String path) {
            this.path = path;
            return this;
        }
    }
}

