/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.EditPropertiesAction;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.EditPropertiesCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;

public class StateIdSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private Text labelText;
    private IState state;
    private IState oldState;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ActionRegistry actionRegistry = (ActionRegistry)editor.getAdapter(ActionRegistry.class);
            EditPropertiesAction action = (EditPropertiesAction)actionRegistry.getAction((Object)"Edit_propeties");
            action.setOpenDialog(false);
            EditPropertiesCommand command = new EditPropertiesCommand();
            IState clone = null;
            if (StateIdSection.this.state instanceof ICloneableModelElement) {
                clone = (IState)((ICloneableModelElement)StateIdSection.this.state).cloneModelElement();
            }
            clone.setId(StateIdSection.this.labelText.getText());
            command.setChild((ICloneableModelElement<IWebflowModelElement>)((ICloneableModelElement)StateIdSection.this.state), (IWebflowModelElement)clone);
            if (action != null) {
                StateIdSection.this.state.removePropertyChangeListener((PropertyChangeListener)StateIdSection.this);
                action.runWithCommand(command);
                StateIdSection.this.state.addPropertyChangeListener((PropertyChangeListener)StateIdSection.this);
            }
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.labelText = this.getWidgetFactory().createText(composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.labelText.setLayoutData((Object)data);
        this.labelText.addModifyListener(this.listener);
        CLabel labelLabel = this.getWidgetFactory().createCLabel(composite, "State id:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.labelText, -5);
        data.top = new FormAttachment((Control)this.labelText, 0, 0x1000000);
        labelLabel.setLayoutData((Object)data);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (this.oldState != null) {
            this.oldState.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (input instanceof AbstractStatePart && ((AbstractStatePart)input).getModel() instanceof IState) {
            this.state = (IState)((AbstractStatePart)input).getModel();
            this.state.addPropertyChangeListener((PropertyChangeListener)this);
            this.oldState = this.state;
        }
    }

    public void refresh() {
        this.labelText.removeModifyListener(this.listener);
        if (this.state.getId() != null) {
            this.labelText.setText(this.state.getId());
        }
        this.labelText.addModifyListener(this.listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    public void dispose() {
        if (this.state != null) {
            this.state.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.dispose();
    }
}

