/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.parts;

import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.IEndState;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.ui.graph.figures.StateLabel;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelDecorator;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.ChildrenStatePart;

public class StatePart
extends AbstractStatePart {
    public static final Color COLOR = new Color(null, 255, 255, 206);
    protected static ILabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WebflowModelLabelProvider(), (ILabelDecorator)new WebflowModelLabelDecorator());
    protected WebflowModelLabelProvider eLabelProvider = new WebflowModelLabelProvider();

    public void contributeNodesToGraph(CompoundDirectedGraph graph, Subgraph s, Map map) {
        Node n = new Node((Object)this, s);
        n.outgoingOffset = 9;
        n.incomingOffset = 9;
        n.width = this.getFigure().getPreferredSize().width + 5;
        n.height = this.getFigure().getPreferredSize().height;
        if (this.getModel() instanceof IEndState) {
            n.setPadding(new Insets(0, 40, 10, 40));
        } else if (this.getModel() instanceof IActionElement || this.getModel() instanceof IAttributeMapper || this.getModel() instanceof IIf || this.getModel() instanceof IExceptionHandler) {
            n.setPadding(new Insets(0, 5, 5, 0));
        } else {
            n.setPadding(new Insets(0, 50, 50, 50));
        }
        map.put(this, n);
        graph.nodes.add((Object)n);
    }

    protected IFigure createFigure() {
        StateLabel l = new StateLabel();
        l.setBackgroundColor(COLOR);
        l.setLabelAlignment(1);
        l.setIcon(labelProvider.getImage(this.getModel()));
        l.setIconTextGap(5);
        l.setIconAlignment(8);
        l.setBorder((Border)new LineBorder());
        return l;
    }

    protected void refreshVisuals() {
        ((Label)this.getFigure()).setText(String.valueOf(labelProvider.getText(this.getModel())) + " ");
        ((Label)this.getFigure()).setIcon(labelProvider.getImage(this.getModel()));
        ((Label)this.getFigure()).setToolTip((IFigure)new Label(this.eLabelProvider.getText(this.getModel(), true, true, true)));
        if (this.getParent() instanceof ChildrenStatePart) {
            ((ChildrenStatePart)this.getParent()).refreshVisuals();
        }
    }
}

