/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.swt.graphics.Color;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IIfTransition;
import org.springframework.ide.eclipse.webflow.ui.graph.figures.StateLabel;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.IfTransitionPart;

public class IfPart
extends AbstractStatePart {
    public static final Color COLOR = new Color(null, 255, 255, 206);
    private static WebflowModelLabelProvider labelProvider = new WebflowModelLabelProvider();

    public void contributeEdgesToGraph(CompoundDirectedGraph graph, Map map) {
        List outgoing = this.getSourceConnections();
        int i = 0;
        while (i < outgoing.size()) {
            IfTransitionPart part = (IfTransitionPart)this.getSourceConnections().get(i);
            part.contributeToGraph(graph, map);
            ++i;
        }
    }

    public void contributeNodesToGraph(CompoundDirectedGraph graph, Subgraph s, Map map) {
        Node n = new Node((Object)this, s);
        n.outgoingOffset = 9;
        n.incomingOffset = 9;
        n.width = this.getFigure().getPreferredSize().width + 5;
        n.height = this.getFigure().getPreferredSize().height;
        n.setPadding(new Insets(0, 5, 5, 9));
        map.put(this, n);
        graph.nodes.add((Object)n);
    }

    protected IFigure createFigure() {
        StateLabel l = new StateLabel();
        l.setBackgroundColor(COLOR);
        l.setLabelAlignment(1);
        l.setIcon(labelProvider.getImage(this.getModel()));
        l.setBorder((Border)new LineBorder());
        return l;
    }

    protected List getModelSourceConnections() {
        if (this.getModel() instanceof IIf) {
            ArrayList<IIfTransition> sourceConnections = new ArrayList<IIfTransition>();
            IIf theIf = (IIf)this.getModel();
            if (theIf.getThenTransition() != null && theIf.getThenTransition().getToState() != null) {
                sourceConnections.add(theIf.getThenTransition());
            }
            if (theIf.getElseTransition() != null && theIf.getElseTransition().getToState() != null) {
                sourceConnections.add(theIf.getElseTransition());
            }
            return sourceConnections;
        }
        return Collections.EMPTY_LIST;
    }

    protected void performDirectEdit() {
    }

    protected void refreshVisuals() {
        ((Label)this.getFigure()).setText(labelProvider.getText(this.getModel()));
        ((Label)this.getFigure()).setToolTip((IFigure)new Label(labelProvider.getLongText(this.getModel())));
    }
}

