/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.model;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelProvider;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAction;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.IBeanAction;
import org.springframework.ide.eclipse.webflow.core.model.IBeanReference;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IEndState;
import org.springframework.ide.eclipse.webflow.core.model.IEvaluateAction;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IInputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IOutputMapper;
import org.springframework.ide.eclipse.webflow.core.model.ISet;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowUtils;

public class WebflowModelLabelProvider
extends LabelProvider {
    private final BeansModelLabelProvider BEANS_LABEL_PROVIDER = new BeansModelLabelProvider(true);

    public Image getImage(Object obj) {
        if (obj instanceof IActionState) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_state_obj.gif");
        }
        if (obj instanceof IViewState) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.view_state_obj.gif");
        }
        if (obj instanceof IEndState) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.end_state_obj.gif");
        }
        if (obj instanceof ISubflowState) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.subflow_state_obj.gif");
        }
        if (obj instanceof IBeanAction) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.bean_action_obj.gif");
        }
        if (obj instanceof ISet) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.set_action_obj.gif");
        }
        if (obj instanceof IEvaluateAction) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.evaluation_action_obj.gif");
        }
        if (obj instanceof IAction) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif");
        }
        if (obj instanceof IAttributeMapper) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.attribute_mapper_obj.gif");
        }
        if (obj instanceof IDecisionState) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.decision_state_obj.gif");
        }
        if (obj instanceof IIf) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.if_obj.gif");
        }
        if (obj instanceof IAttribute) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.properties_obj.gif");
        }
        if (obj instanceof IBean) {
            return this.BEANS_LABEL_PROVIDER.getImage(obj);
        }
        if (obj instanceof IInputMapper) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.input_obj.gif");
        }
        if (obj instanceof IOutputMapper) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.output_obj.gif");
        }
        if (obj instanceof IInlineFlowState) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.spring_webflow_obj.gif");
        }
        if (obj instanceof IExceptionHandler) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.exception_handler_obj.gif");
        }
        if (obj instanceof IWebflowState) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.spring_webflow_obj.gif");
        }
        if (obj instanceof IStateTransition) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.transition_obj.gif");
        }
        return null;
    }

    public String getText(Object element) {
        return this.getText(element, false, true, false);
    }

    public String getText(Object element, boolean showElementType, boolean showAdditionalInfo, boolean showError) {
        IViewState state;
        Action action;
        StringBuffer buf = new StringBuffer();
        if (element instanceof IState) {
            buf.append(((IState)element).getId());
        } else if (element instanceof Action) {
            action = (Action)element;
            if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)action)) {
                if (action.getName() != null) {
                    buf.append(action.getName());
                    buf.append(": ");
                }
                if (action.getBean() != null) {
                    buf.append(action.getBean());
                }
                if (action.getMethod() != null) {
                    buf.append(".");
                    buf.append(action.getMethod());
                    if (action.getMethod().lastIndexOf("(") == -1) {
                        buf.append("()");
                    }
                }
            } else {
                buf.append("fragments: ").append(action.getName());
            }
        } else if (element instanceof BeanAction) {
            action = (BeanAction)element;
            if (action.getName() != null) {
                buf.append(action.getName());
                buf.append(": ");
            }
            if (action.getBean() != null) {
                buf.append(action.getBean());
            }
            if (action.getMethod() != null) {
                buf.append(".");
                buf.append(action.getMethod());
                if (action.getMethod().lastIndexOf("(") == -1) {
                    buf.append("()");
                }
            }
        } else if (element instanceof IEvaluateAction) {
            action = (IEvaluateAction)element;
            if (action.getName() != null) {
                buf.append(action.getName());
                buf.append(": ");
            }
            if (action.getExpression() != null) {
                buf.append(action.getExpression());
            }
        } else if (element instanceof ISet) {
            action = (ISet)element;
            if (action.getAttribute() != null) {
                buf.append(action.getAttribute());
                buf.append(" = ");
            }
            if (action.getValue() != null) {
                buf.append(action.getValue());
            }
        } else if (element instanceof IExceptionHandler) {
            action = (IExceptionHandler)element;
            if (action.getBean() != null) {
                buf.append(action.getBean());
            }
        } else if (element instanceof IAttributeMapper) {
            IAttributeMapper attributeMapper = (IAttributeMapper)element;
            if (attributeMapper.getBean() != null) {
                buf.append(attributeMapper.getBean());
            } else {
                buf.append("attribute-mapper");
            }
        } else if (element instanceof IAttribute) {
            IAttribute property = (IAttribute)element;
            buf.append(property.getName());
            buf.append("=");
            buf.append(property.getValue());
        } else if (element instanceof IIf) {
            IIf theIf = (IIf)element;
            buf.append(theIf.getTest());
        } else if (element instanceof IBean) {
            IBean bean = (IBean)element;
            buf.append(bean.getElementName());
            if (bean.getClassName() != null) {
                buf.append(" [");
                buf.append(bean.getClassName());
                buf.append(']');
            }
        } else if (element instanceof IStateTransition) {
            state = (IStateTransition)element;
            if (state.getToStateId() != null) {
                buf.append("To: " + state.getToStateId());
            }
            if (state.getToStateId() != null) {
                buf.append("\nOn: " + state.getOn());
            }
        } else {
            buf.append(super.getText(element));
        }
        if (showAdditionalInfo) {
            if (element instanceof IViewState && (state = (IViewState)element).getView() != null) {
                buf.append("\nView: " + state.getView());
            }
            if (element instanceof ISubflowState) {
                state = (ISubflowState)element;
                if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)state)) {
                    if (state.getFlow() != null) {
                        buf.append("\nFlow: " + state.getFlow());
                    }
                } else if (state.getFlow() != null) {
                    buf.append("\nSubflow: " + state.getFlow());
                }
            }
            if (element instanceof IEndState && (state = (IEndState)element).getView() != null) {
                buf.append("\nView: " + state.getView());
            }
            if (element instanceof IStateTransition && (state = (IStateTransition)element).getOnException() != null) {
                buf.append("\nOn-exception: " + state.getOnException());
            }
        }
        if (showElementType) {
            buf.append(" [");
            if (element instanceof IEndState) {
                buf.append("End State");
            } else if (element instanceof IViewState) {
                buf.append("View State");
            } else if (element instanceof ISubflowState) {
                buf.append("Subflow State");
            } else if (element instanceof IActionState) {
                buf.append("Action State");
            } else if (element instanceof Action) {
                buf.append("Action");
            } else if (element instanceof IBeanAction) {
                buf.append("Bean Action");
            } else if (element instanceof IEvaluateAction) {
                buf.append("Evaluation Action");
            } else if (element instanceof ISet) {
                buf.append("Set");
            } else if (element instanceof IAttributeMapper) {
                buf.append("Attribute Mapper");
            } else if (element instanceof IAttribute) {
                buf.append("Property");
            } else if (element instanceof IIf) {
                buf.append("If");
            } else if (element instanceof IDecisionState) {
                buf.append("Decision State");
            } else if (element instanceof IInputMapper) {
                buf.append("Input");
            } else if (element instanceof IOutputMapper) {
                buf.append("Output");
            } else if (element instanceof IInlineFlowState) {
                buf.append("Inline Flow");
            } else if (element instanceof IExceptionHandler) {
                buf.append("Exception Handler");
            } else if (element instanceof IStateTransition) {
                buf.append("Transition");
            }
            buf.append("]");
        }
        if (showError) {
            buf.append(WebflowUtils.getErrorTooltip((IWebflowModelElement)element));
        }
        return buf.toString();
    }

    public String getLongText(Object element) {
        StringBuffer buf = new StringBuffer();
        if (element instanceof IState) {
            buf.append(((IState)element).getId());
        } else if (element instanceof IBeanReference) {
            IBeanReference action = (IBeanReference)element;
            if (action.getBean() != null) {
                buf.append(action.getBean());
            }
        } else if (element instanceof IAttributeMapper) {
            IAttributeMapper attributeMapper = (IAttributeMapper)element;
            if (attributeMapper.getBean() != null) {
                buf.append(attributeMapper.getBean());
            }
        } else {
            buf.append(super.getText(element));
        }
        return buf.toString();
    }
}

