/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.springframework.ide.eclipse.webflow.core.internal.model.StateTransition;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ModelTableLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.StateTransitionPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.TableCellModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalTransitionsComposite {
    private List<IStateTransition> transitions;
    private IWebflowModelElement parentElement;
    private Button removeButton;
    private Button addButton;
    private Button editButton;
    private TableViewer configsViewer;
    private IDialogValidator validator;
    private Shell parentShell;
    private IWebflowState webflowState;

    public GlobalTransitionsComposite(IDialogValidator validator, TabItem item, Shell parentShell, List<IStateTransition> transitions, IWebflowModelElement parentElement, IWebflowState webflowState) {
        this.transitions = transitions;
        this.parentElement = parentElement;
        this.webflowState = webflowState;
        item.setText("Global Transitions");
        item.setToolTipText("Define global Transitions");
        item.setImage(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.transition_obj.gif"));
        this.parentShell = parentShell;
    }

    protected Control createDialogArea(Composite parent) {
        Group groupPropertyType = new Group(parent, 0);
        GridLayout layoutPropMap = new GridLayout();
        layoutPropMap.marginWidth = 3;
        layoutPropMap.marginHeight = 3;
        groupPropertyType.setLayout((Layout)layoutPropMap);
        groupPropertyType.setText(" Global Transitions ");
        groupPropertyType.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite((Composite)groupPropertyType, 0);
        tableAndButtons.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout2);
        Table configsTable = new Table(tableAndButtons, 68354);
        GridData data = new GridData(1808);
        data.widthHint = 250;
        data.heightHint = 150;
        configsTable.setLayoutData((Object)data);
        TableColumn columnOn = new TableColumn(configsTable, 0);
        columnOn.setText("On");
        columnOn.setWidth(150);
        TableColumn columnTo = new TableColumn(configsTable, 0);
        columnTo.setText("To");
        columnTo.setWidth(150);
        TableColumn columnOnException = new TableColumn(configsTable, 0);
        columnOnException.setText("On-Exception");
        columnOnException.setWidth(150);
        configsTable.setHeaderVisible(true);
        this.configsViewer = new TableViewer(configsTable);
        String[] columnNames = new String[]{"On", "To", "On-Exception"};
        this.configsViewer.setColumnProperties(columnNames);
        this.configsViewer.setContentProvider((IContentProvider)new GlobalTransitionsContentProvider(this.transitions));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new ModelTableLabelProvider());
        this.configsViewer.setCellModifier((ICellModifier)new TableCellModifier());
        this.configsViewer.setInput(this.transitions);
        configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalTransitionsComposite.this.handleTableSelectionChanged();
            }
        });
        Composite buttonArea = new Composite(tableAndButtons, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setText("Add");
        GridData data1 = new GridData(256);
        data1.widthHint = 40;
        this.addButton.setLayoutData((Object)data1);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StateTransition trans = new StateTransition();
                trans.createNew(GlobalTransitionsComposite.this.parentElement, GlobalTransitionsComposite.this.webflowState);
                StateTransitionPropertiesDialog dialog = new StateTransitionPropertiesDialog(GlobalTransitionsComposite.this.parentShell, GlobalTransitionsComposite.this.parentElement, (IStateTransition)trans, true);
                if (dialog.open() == 0) {
                    GlobalTransitionsComposite.this.transitions.add(trans);
                    GlobalTransitionsComposite.this.configsViewer.refresh(true);
                }
            }
        });
        this.editButton = new Button(buttonArea, 8);
        this.editButton.setText("Edit");
        data1 = new GridData(256);
        data1.widthHint = 40;
        this.editButton.setLayoutData((Object)data1);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)GlobalTransitionsComposite.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IStateTransition) {
                    StateTransitionPropertiesDialog dialog = new StateTransitionPropertiesDialog(GlobalTransitionsComposite.this.parentShell, GlobalTransitionsComposite.this.parentElement, (IStateTransition)selection.getFirstElement(), true);
                    dialog.open();
                    GlobalTransitionsComposite.this.configsViewer.refresh();
                }
            }
        });
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setText("Delete");
        GridData data2 = new GridData(256);
        data1.widthHint = 40;
        this.removeButton.setLayoutData((Object)data2);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)GlobalTransitionsComposite.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IStateTransition) {
                    GlobalTransitionsComposite.this.transitions.remove(selection.getFirstElement());
                    GlobalTransitionsComposite.this.configsViewer.refresh();
                }
            }
        });
        this.removeButton.setEnabled(false);
        this.editButton.setEnabled(false);
        return groupPropertyType;
    }

    private void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (selection.isEmpty()) {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GlobalTransitionsContentProvider
    implements IStructuredContentProvider {
        private List<IStateTransition> actions;

        public GlobalTransitionsContentProvider(List<IStateTransition> actions) {
            this.actions = actions;
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return this.actions.toArray();
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }
}

