/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluateAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.RenderActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IRenderActions;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;

public class CreateActionCommand
extends Command {
    private IActionElement child;
    private int index = -1;
    private boolean isMove = false;
    private boolean createNew = true;
    private IState parent;

    public void execute() {
        if (this.createNew) {
            if (this.child instanceof Action) {
                ((Action)this.child).createNew((IWebflowModelElement)this.parent);
            } else if (this.child instanceof BeanAction) {
                ((BeanAction)this.child).createNew((IWebflowModelElement)this.parent);
            } else if (this.child instanceof EvaluateAction) {
                ((EvaluateAction)this.child).createNew((IWebflowModelElement)this.parent);
            } else if (this.child instanceof Set) {
                ((Set)this.child).createNew((IWebflowModelElement)this.parent);
            }
        }
        if (!this.isMove && DialogUtils.openPropertiesDialog(null, (IWebflowModelElement)this.child, true) != 0) {
            return;
        }
        if (this.child.getType() == IActionElement.ACTION_TYPE.ACTION) {
            if (this.index > 0) {
                ((IActionState)this.parent).addAction(this.child, this.index);
            } else {
                ((IActionState)this.parent).addAction(this.child);
            }
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.RENDER_ACTION) {
            IViewState viewState = (IViewState)this.parent;
            if (viewState.getRenderActions() == null) {
                RenderActions exit = new RenderActions();
                exit.createNew((IWebflowModelElement)viewState);
                viewState.setRenderActions((IRenderActions)exit);
            }
            this.child.setElementParent((IWebflowModelElement)viewState.getRenderActions());
            if (this.index > 0) {
                viewState.getRenderActions().addRenderAction(this.child, this.index);
            } else {
                viewState.getRenderActions().addRenderAction(this.child);
            }
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.ENTRY_ACTION) {
            if (this.parent.getEntryActions() == null) {
                EntryActions entry = new EntryActions();
                entry.createNew((IWebflowModelElement)this.parent);
                this.parent.setEntryActions((IEntryActions)entry);
            }
            this.child.setElementParent((IWebflowModelElement)this.parent.getEntryActions());
            if (this.index > 0) {
                this.parent.getEntryActions().addEntryAction(this.child, this.index);
            } else {
                this.parent.getEntryActions().addEntryAction(this.child);
            }
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.EXIT_ACTION) {
            if (this.parent.getExitActions() == null) {
                ExitActions entry = new ExitActions();
                entry.createNew((IWebflowModelElement)this.parent);
                this.parent.setExitActions((IExitActions)entry);
            }
            this.child.setElementParent((IWebflowModelElement)this.parent.getExitActions());
            if (this.index > 0) {
                this.parent.getExitActions().addExitAction(this.child, this.index);
            } else {
                this.parent.getExitActions().addExitAction(this.child);
            }
        }
    }

    public void setChild(IActionElement action) {
        this.child = action;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public void setMove(boolean isMove) {
        this.isMove = isMove;
    }

    public void setParent(IState sa) {
        this.parent = sa;
    }

    public void undo() {
        if (this.child.getType() == IActionElement.ACTION_TYPE.ACTION) {
            ((IActionState)this.parent).removeAction(this.child);
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.RENDER_ACTION) {
            IViewState viewState = (IViewState)this.child;
            viewState.getRenderActions().removeRenderAction(this.child);
            if (viewState.getRenderActions().getRenderActions().size() == 0) {
                viewState.setRenderActions(null);
            }
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.ENTRY_ACTION) {
            this.parent.getEntryActions().removeEntryAction(this.child);
            if (this.parent.getEntryActions().getEntryActions().size() == 0) {
                this.parent.setEntryActions(null);
            }
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.EXIT_ACTION) {
            this.parent.getExitActions().removeExitAction(this.child);
            if (this.parent.getExitActions().getExitActions().size() == 0) {
                this.parent.setExitActions(null);
            }
        }
    }

    public void redo() {
        boolean tempMove = this.isMove;
        boolean tempCreateNew = this.createNew;
        this.isMove = true;
        this.createNew = false;
        this.execute();
        this.isMove = tempMove;
        this.createNew = tempCreateNew;
    }
}

