/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluateAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.RenderActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IRenderActions;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;

public class ActionCloneCommand
extends Command {
    private IActionElement oldChild;
    private IActionElement child;
    private IWebflowModelElement newState;

    public void execute() {
        if (this.oldChild instanceof Action) {
            this.child = ((Action)this.oldChild).cloneModelElement();
        } else if (this.oldChild instanceof BeanAction) {
            this.child = ((BeanAction)this.oldChild).cloneModelElement();
        } else if (this.oldChild instanceof EvaluateAction) {
            this.child = ((EvaluateAction)this.oldChild).cloneModelElement();
        } else if (this.oldChild instanceof Set) {
            this.child = ((Set)this.oldChild).cloneModelElement();
        }
        if (this.child.getType() == IActionElement.ACTION_TYPE.ACTION && this.newState instanceof IActionState) {
            this.child.setElementParent(this.newState);
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.RENDER_ACTION && this.newState instanceof IViewState) {
            IViewState state = (IViewState)this.newState;
            if (state.getRenderActions() == null) {
                RenderActions entry = new RenderActions();
                entry.createNew((IWebflowModelElement)state);
                state.setRenderActions((IRenderActions)entry);
            }
            this.child.setElementParent((IWebflowModelElement)state.getRenderActions());
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.ENTRY_ACTION && this.newState instanceof IState) {
            IState state = (IState)this.newState;
            if (state.getEntryActions() == null) {
                EntryActions entry = new EntryActions();
                entry.createNew((IWebflowModelElement)state);
                state.setEntryActions((IEntryActions)entry);
            }
            this.child.setElementParent((IWebflowModelElement)state.getEntryActions());
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.EXIT_ACTION && this.newState instanceof IState) {
            IState state = (IState)this.newState;
            if (state.getExitActions() == null) {
                ExitActions entry = new ExitActions();
                entry.createNew((IWebflowModelElement)state);
                state.setExitActions((IExitActions)entry);
            }
            this.child.setElementParent((IWebflowModelElement)state.getExitActions());
        }
        if (this.child.getElementParent() instanceof IEntryActions) {
            ((IEntryActions)this.child.getElementParent()).addEntryAction(this.child);
        } else if (this.child.getElementParent() instanceof IExitActions) {
            ((IExitActions)this.child.getElementParent()).addExitAction(this.child);
        } else if (this.child.getElementParent() instanceof IRenderActions) {
            ((IRenderActions)this.child.getElementParent()).addRenderAction(this.child);
        } else if (this.child.getElementParent() instanceof IActionState) {
            ((IActionState)this.child.getElementParent()).addAction(this.child);
        }
    }

    public void setChild(IActionElement child) {
        this.oldChild = child;
    }

    public void undo() {
        IExitActions state;
        IWebflowModelElement parent = (IWebflowModelElement)this.child.getElementParent();
        if (parent instanceof IEntryActions) {
            ((IEntryActions)parent).removeEntryAction(this.child);
        } else if (parent instanceof IExitActions) {
            ((IExitActions)parent).removeExitAction(this.child);
        } else if (parent instanceof IRenderActions) {
            ((IRenderActions)parent).removeRenderAction(this.child);
        } else if (parent instanceof IActionState) {
            ((IActionState)parent).removeAction(this.child);
        }
        if (this.child.getType() == IActionElement.ACTION_TYPE.RENDER_ACTION && parent instanceof IRenderActions) {
            IRenderActions state2 = (IRenderActions)parent;
            if (state2 != null && state2.getRenderActions().size() == 0) {
                ((IViewState)state2.getElementParent()).setRenderActions(null);
            }
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.ENTRY_ACTION && parent instanceof IEntryActions) {
            IEntryActions state3 = (IEntryActions)parent;
            if (state3 != null && state3.getEntryActions().size() == 0) {
                ((IState)state3.getElementParent()).setEntryActions(null);
            }
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.EXIT_ACTION && parent instanceof IExitActions && (state = (IExitActions)parent) != null && state.getExitActions().size() == 0) {
            ((IState)state.getElementParent()).setExitActions(null);
        }
    }

    public void setNewState(IWebflowModelElement newState) {
        this.newState = newState;
    }
}

