/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.actions;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.EditPropertiesCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;

public class EditPropertiesAction
extends SelectionAction {
    public static final String EDITPROPERTIES_REQUEST = "Edit_propeties";
    public static final String EDITPROPERTIES = "Edit_propeties";
    private Request request = new Request((Object)"Edit_propeties");
    boolean openDialog = true;

    public void setOpenDialog(boolean openDialog) {
        this.openDialog = openDialog;
    }

    public EditPropertiesAction(IWorkbenchPart part) {
        super(part);
        this.setText("Properties");
        this.setId("Edit_propeties");
        this.setToolTipText("Edit properties of selected state");
        this.setImageDescriptor(WebflowUIImages.DESC_OBJS_PROPERTIES);
        this.setHoverImageDescriptor(this.getImageDescriptor());
    }

    protected boolean calculateEnabled() {
        return this.canPerformAction();
    }

    private boolean canPerformAction() {
        if (this.getSelectedObjects().isEmpty()) {
            return false;
        }
        int i = 0;
        List parts = this.getSelectedObjects();
        if (i < parts.size()) {
            Object o = parts.get(i);
            if (!(o instanceof EditPart)) {
                return false;
            }
            EditPart part = (EditPart)o;
            return part.getModel() instanceof IWebflowModelElement;
        }
        return true;
    }

    private CompoundCommand getCommand() {
        List editparts = this.getSelectedObjects();
        CompoundCommand cc = new CompoundCommand();
        int i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            cc.add(part.getCommand(this.request));
            ++i;
        }
        return cc;
    }

    public void run() {
        CompoundCommand cc = this.getCommand();
        int i = 0;
        while (i < cc.getCommands().size()) {
            if (cc.getCommands().get(i) instanceof EditPropertiesCommand) {
                EditPropertiesCommand command = (EditPropertiesCommand)((Object)cc.getCommands().get(i));
                this.openDialog = true;
                this.runWithCommand(command);
            }
            ++i;
        }
    }

    public void runWithCommand(Command cc) {
        int result = -1;
        EditPropertiesCommand command = (EditPropertiesCommand)cc;
        IWebflowModelElement child = command.getChild();
        IWebflowModelElement newChild = command.getChildClone();
        if (this.openDialog) {
            result = child.getElementParent() instanceof IWebflowModelElement ? DialogUtils.openPropertiesDialog((IWebflowModelElement)child.getElementParent(), newChild, false) : DialogUtils.openPropertiesDialog(null, newChild, false);
            if (result == 0) {
                this.execute(command);
            }
        } else {
            this.execute(command);
        }
    }
}

