/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.IMethodFilter;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidator;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowEditor;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowEditorInput;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebflowUtils {
    private static final Set<IMethod> NO_METHOD_MATCHES = new HashSet<IMethod>();

    public static WebflowEditor getActiveFlowEditor() {
        IEditorPart editorPart = org.springframework.ide.eclipse.webflow.ui.editor.Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof WebflowEditor) {
            return (WebflowEditor)editorPart;
        }
        return null;
    }

    public static WebflowEditorInput getActiveFlowEditorInput() {
        WebflowEditor editor = WebflowUtils.getActiveFlowEditor();
        if (editor != null) {
            return (WebflowEditorInput)editor.getEditorInput();
        }
        return null;
    }

    public static IWebflowConfig getActiveWebflowConfig() {
        IWebflowProject project;
        WebflowEditorInput editorInput = WebflowUtils.getActiveFlowEditorInput();
        if (editorInput != null && editorInput.getFile() != null && (project = Activator.getModel().getProject(editorInput.getFile().getProject())) != null) {
            return project.getConfig(editorInput.getFile());
        }
        return null;
    }

    public static Set<IBean> getBeansFromEditorInput() {
        return WebflowModelUtils.getBeans((IWebflowConfig)WebflowUtils.getActiveWebflowConfig());
    }

    public static Set<IMethod> getActionMethods(IDOMNode node) {
        Set<IBean> beans = WebflowUtils.getBeansFromEditorInput();
        String className = null;
        for (IBean bean : beans) {
            if (!bean.getElementName().equals(BeansEditorUtils.getAttribute((Node)node, (String)"bean"))) continue;
            className = BeansModelUtils.getBeanClass((IBean)bean, null);
        }
        IType type = JdtUtils.getJavaType((IProject)WebflowUtils.getActiveFlowEditorInput().getFile().getProject(), className);
        if (type != null) {
            if ("bean-action".equals(node.getLocalName())) {
                return Introspector.findAllMethods((IType)type, (IMethodFilter)WebflowModelUtils.getBeanMethodFilter());
            }
            return Introspector.findAllMethods((IType)type, (IMethodFilter)WebflowModelUtils.getBeanActionMethodFilter());
        }
        return NO_METHOD_MATCHES;
    }

    public static String[] getWebflowConfigNames() {
        IWebflowProject project = WebflowUtils.getActiveWebflowConfig().getProject();
        return WebflowModelUtils.getWebflowConfigNames((IWebflowProject)project).toArray(new String[0]);
    }

    public static boolean isValid(IWebflowModelElement element) {
        Set<ValidationProblem> validationProblems = WebflowUtils.validate(element);
        return validationProblems == null || validationProblems.size() == 0;
    }

    public static Set<ValidationProblem> validate(IWebflowModelElement element) {
        IWebflowState webflowState = WebflowModelUtils.getWebflowState((IWebflowModelElement)element, (boolean)true);
        if (webflowState != null) {
            IWebflowConfig config = (IWebflowConfig)webflowState.getElementParent();
            NoMarkerCreatingWebflowValidator validator = new NoMarkerCreatingWebflowValidator();
            HashSet<IResource> affectedResources = new HashSet<IResource>();
            affectedResources.add(config.getElementResource());
            try {
                validator.validate(affectedResources, 10, (IProgressMonitor)new NullProgressMonitor());
                return validator.getValidationProblems();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static String getErrorTooltip(IWebflowModelElement element) {
        StringBuffer buf = new StringBuffer();
        Set<ValidationProblem> validationProblems = WebflowUtils.validate(element);
        if (validationProblems != null && validationProblems.size() > 0) {
            buf.append("\n\nProblems:");
            for (ValidationProblem problem : validationProblems) {
                buf.append("\n");
                buf.append(problem.getMessage());
            }
        }
        return buf.toString();
    }

    public static String[] getStateId(IWebflowModelElement parent) {
        IWebflowState webflowState = WebflowModelUtils.getWebflowState((IWebflowModelElement)parent, (boolean)false);
        ArrayList<String> stateIds = new ArrayList<String>();
        if (webflowState != null) {
            for (IState state : webflowState.getStates()) {
                stateIds.add(state.getId());
            }
        }
        return stateIds.toArray(new String[stateIds.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoMarkerCreatingWebflowValidator
    extends WebflowValidator {
        private Set<ValidationProblem> validationProblems = new HashSet<ValidationProblem>();

        public NoMarkerCreatingWebflowValidator() {
            this.setMarkerId("org.springframework.ide.eclipse.webflow.core.validator");
        }

        protected void createProblemMarker(IResource resource, ValidationProblem problem) {
            if (problem.getSeverity() == 2) {
                this.validationProblems.add(problem);
            }
        }

        public void cleanup(IResource resource, IProgressMonitor monitor) {
        }

        public Set<ValidationProblem> getValidationProblems() {
            return this.validationProblems;
        }

        public boolean hasErrors() {
            return this.validationProblems.size() > 0;
        }

        protected String getValidatorId() {
            return "org.springframework.ide.eclipse.webflow.core.validator";
        }
    }
}

