/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.monitor.core.operations;

import com.atlassian.connector.eclipse.internal.monitor.core.Messages;
import com.atlassian.connector.eclipse.monitor.core.InteractionEvent;
import com.atlassian.connector.eclipse.monitor.core.InteractionEventLogger;
import com.atlassian.connector.eclipse.monitor.core.MonitorCorePlugin;
import java.io.File;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.core.ZipFileUtil;
import org.eclipse.osgi.util.NLS;

public final class UsageDataUploadJob
extends Job {
    private final boolean ifTimeElapsed;
    private static int processedFileCount = 1;

    public UsageDataUploadJob(boolean ignoreLastTransmit) {
        super(Messages.UsageDataUploadJob_uploading_usage_stats);
        this.ifTimeElapsed = ignoreLastTransmit;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.ifTimeElapsed) {
                this.performUpload(monitor);
            } else {
                this.checkLastTransmitTimeAndRun(monitor);
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.atlassian.connector.eclipse.monitor.core", 4, Messages.UsageDataUploadJob_error_uploading, (Throwable)e);
            StatusHandler.log((IStatus)status);
            return status;
        }
    }

    private void checkLastTransmitTimeAndRun(IProgressMonitor monitor) {
        MonitorCorePlugin plugin = MonitorCorePlugin.getDefault();
        Date lastTransmit = plugin.getPreviousTransmitDate();
        Date currentTime = new Date();
        if (lastTransmit == null || currentTime.getTime() > lastTransmit.getTime() + 86400000L) {
            plugin.setPreviousTransmitDate(currentTime);
            this.performUpload(monitor);
        }
    }

    private void performUpload(IProgressMonitor monitor) {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UsageDataUploadJob_uploading_usage_stats, (int)3);
        MonitorCorePlugin.getDefault().getInteractionLogger().stopMonitoring();
        try {
            File zipFile = this.zipFilesForUpload((IProgressMonitor)submonitor.newChild(1));
            if (zipFile == null) {
                return;
            }
            try {
                this.upload("https://update.atlassian.com/atlassian-eclipse-plugin/usage-collector/upload-2", zipFile, (IProgressMonitor)submonitor.newChild(1));
            }
            finally {
                if (zipFile.exists()) {
                    zipFile.delete();
                }
            }
        }
        finally {
            try {
                MonitorCorePlugin.getDefault().getInteractionLogger().clearInteractionHistory();
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", "Failed to clear the Usage Data log", (Throwable)e));
            }
            MonitorCorePlugin.getDefault().getInteractionLogger().startMonitoring();
        }
    }

    private File zipFilesForUpload(IProgressMonitor monitor) {
        File fileToUpload;
        ArrayList<File> files = new ArrayList<File>();
        File monitorFile = MonitorCorePlugin.getDefault().getMonitorLogFile();
        try {
            fileToUpload = this.processMonitorFile(monitorFile);
        }
        catch (IOException e1) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", Messages.UsageDataUploadJob_error_uploading, (Throwable)e1));
            return null;
        }
        files.add(fileToUpload);
        try {
            File zipFile = File.createTempFile(String.valueOf(MonitorCorePlugin.getDefault().getUserId()) + ".", ".zip");
            ZipFileUtil.createZipFile((File)zipFile, files, (IProgressMonitor)monitor);
            return zipFile;
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", Messages.UsageDataUploadJob_error_uploading, (Throwable)e));
            return null;
        }
    }

    private File processMonitorFile(File monitorFile) throws IOException {
        File processedFile = File.createTempFile(String.format("processed-%s%d.", "usage-data.xml", processedFileCount++), ".xml");
        InteractionEventLogger logger = new InteractionEventLogger(processedFile);
        logger.startMonitoring();
        List<InteractionEvent> eventList = logger.getHistoryFromFile(monitorFile);
        if (eventList.size() > 0) {
            for (InteractionEvent event : eventList) {
                logger.interactionObserved(event);
            }
        }
        return processedFile;
    }

    private boolean upload(String uploadUrl, File f, IProgressMonitor monitor) {
        int status = 0;
        try {
            PostMethod filePost = new PostMethod(uploadUrl);
            try {
                Part[] parts = new Part[]{new FilePart("temp.txt", f, "application/zip", "ISO-8859-1")};
                filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
                HttpClient client = new HttpClient();
                status = client.executeMethod((HttpMethod)filePost);
            }
            finally {
                filePost.releaseConnection();
            }
        }
        catch (Exception e) {
            if (e instanceof NoRouteToHostException || e instanceof UnknownHostException) {
                StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", Messages.UsageDataUploadJob_no_network, (Throwable)e));
            } else {
                StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", Messages.UsageDataUploadJob_unknown_exception, (Throwable)e));
            }
            return false;
        }
        monitor.worked(1);
        if (status == 401) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", NLS.bind((String)Messages.UsageDataUploadJob_invalid_uid, (Object)f.getName(), (Object)"")));
        } else if (status == 407) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", Messages.UsageDataUploadJob_proxy_authentication));
        } else if (status != 200) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", NLS.bind((String)Messages.UsageDataUploadJob_30, (Object)f.getName(), (Object)status)));
        } else {
            return true;
        }
        return false;
    }
}

