/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.matcher.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkingSet;
import org.springframework.ide.eclipse.aop.ui.matcher.internal.PointcutMatcherMessages;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointcutMatcherScope {
    private String description;
    private final IModelElement[] modelElements;

    private static void addToList(IAdaptable adaptable, List<IModelElement> elements, boolean isProjectsList) {
        IModelElement element = (IModelElement)adaptable.getAdapter(IModelElement.class);
        if (element == null) {
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource instanceof IProject) {
                if (SpringCoreUtils.isSpringProject((IResource)resource)) {
                    IBeansModel model = BeansCorePlugin.getModel();
                    element = model.getProject((IProject)resource);
                }
            } else if (resource instanceof IFile) {
                IBeansModel model = BeansCorePlugin.getModel();
                element = model.getConfig((IFile)resource);
            } else if (adaptable instanceof IBeansConfigSet) {
                for (IBeansConfig config : ((IBeansConfigSet)adaptable).getConfigs()) {
                    elements.add((IModelElement)config);
                }
            }
        }
        if (!(element == null || elements.contains(element) || isProjectsList && !(element instanceof IBeansProject))) {
            elements.add(element);
        }
    }

    private static IModelElement[] convertToElements(ISelection selection, boolean isProjectsSelection) {
        ArrayList<IModelElement> elements = new ArrayList<IModelElement>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof IAdaptable)) continue;
                PointcutMatcherScope.addToList((IAdaptable)selectedElement, elements, isProjectsSelection);
            }
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }

    private static IModelElement[] convertToElements(IWorkingSet[] workingSets) {
        ArrayList<IModelElement> elements = new ArrayList<IModelElement>();
        IWorkingSet[] iWorkingSetArray = workingSets;
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable[] wsElements;
            IWorkingSet element = iWorkingSetArray[n2];
            IAdaptable[] iAdaptableArray = wsElements = element.getElements();
            int n3 = wsElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IAdaptable element0 = iAdaptableArray[n4];
                PointcutMatcherScope.addToList(element0, elements, false);
                ++n4;
            }
            ++n2;
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }

    public static PointcutMatcherScope newSearchScope() {
        return new PointcutMatcherScope(PointcutMatcherMessages.MatcherScope_workspace, new IModelElement[]{BeansCorePlugin.getModel()});
    }

    public static PointcutMatcherScope newSearchScope(ISelection selection, boolean isProjectsSelection) {
        String description;
        IModelElement[] elements = PointcutMatcherScope.convertToElements(selection, isProjectsSelection);
        if (isProjectsSelection) {
            StringBuffer text = new StringBuffer();
            int i = 0;
            while (i < elements.length) {
                IModelElement element = elements[i];
                text.append("'");
                text.append(element.getElementName());
                text.append("'");
                if (i < elements.length - 1) {
                    text.append(", ");
                }
                ++i;
            }
            Object[] args = new Object[]{text.toString()};
            description = MessageUtils.format((String)PointcutMatcherMessages.MatcherScope_selectedProjects, (Object[])args);
        } else {
            description = PointcutMatcherMessages.MatcherScope_selection;
        }
        return new PointcutMatcherScope(description, elements);
    }

    public static PointcutMatcherScope newSearchScope(IWorkingSet[] workingSets) {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet ws = workingSets[i];
            text.append("'");
            text.append(ws.getName());
            text.append("'");
            if (i < workingSets.length - 1) {
                text.append(", ");
            }
            ++i;
        }
        Object[] args = new Object[]{text.toString()};
        return new PointcutMatcherScope(MessageUtils.format((String)PointcutMatcherMessages.MatcherScope_workingSets, (Object[])args), PointcutMatcherScope.convertToElements(workingSets));
    }

    private PointcutMatcherScope(String description, IModelElement[] elements) {
        Assert.notNull((Object)description);
        this.description = description;
        this.modelElements = elements;
    }

    public String getDescription() {
        return this.description;
    }

    public IModelElement[] getModelElements() {
        return this.modelElements;
    }

    public String toString() {
        StringBuffer text = new StringBuffer(this.description);
        text.append(" [");
        int i = 0;
        while (i < this.modelElements.length) {
            IModelElement element = this.modelElements[i];
            text.append(element);
            if (i < this.modelElements.length - 1) {
                text.append(", ");
            }
            ++i;
        }
        text.append(']');
        return text.toString();
    }
}

