/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.actions;

import com.atlassian.connector.eclipse.internal.bamboo.ui.EclipseBambooBuild;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenRepositoryConfigurationAction
extends BaseSelectionListenerAction {
    public OpenRepositoryConfigurationAction() {
        super(null);
        this.initialize();
    }

    private void initialize() {
        this.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.setText("Properties...");
        this.setToolTipText("Open the repository configuration");
    }

    public void run() {
        IStructuredSelection s = super.getStructuredSelection();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection selection = s;
            Object selected = selection.iterator().next();
            if (selected instanceof EclipseBambooBuild) {
                EclipseBambooBuild eclipseBambooBuild = (EclipseBambooBuild)selected;
                this.openConfiguration(eclipseBambooBuild.getTaskRepository());
            } else if (selected instanceof TaskRepository) {
                TaskRepository repository = (TaskRepository)selected;
                this.openConfiguration(repository);
            }
        }
    }

    private void openConfiguration(final TaskRepository repository) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                TasksUiUtil.openEditRepositoryWizard((TaskRepository)repository);
            }
        });
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return selection.size() == 1;
    }
}

