/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui;

import com.atlassian.connector.eclipse.internal.bamboo.core.BambooConstants;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooCorePlugin;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooUtil;
import com.atlassian.connector.eclipse.internal.bamboo.core.BuildPlanManager;
import com.atlassian.connector.eclipse.internal.bamboo.core.BuildsChangedEvent;
import com.atlassian.connector.eclipse.internal.bamboo.core.BuildsChangedListener;
import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooBuildViewerComparator;
import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooImages;
import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooUiUtil;
import com.atlassian.connector.eclipse.internal.bamboo.ui.BuildLabelProvider;
import com.atlassian.connector.eclipse.internal.bamboo.ui.BuildTreeViewer;
import com.atlassian.connector.eclipse.internal.bamboo.ui.EclipseBambooBuild;
import com.atlassian.connector.eclipse.internal.bamboo.ui.actions.NewTaskFromFailedBuildAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.actions.OpenRepositoryConfigurationAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.actions.RepositoryConfigurationAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.actions.RunBuildAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.actions.ShowTestResultsAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.actions.ToggleAutoRefreshAction;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.PlanState;
import com.atlassian.theplugin.commons.util.DateUtil;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooView
extends ViewPart {
    private static final String CREATE_A_NEW_REPOSITORY_LINK = "create a new repository";
    private static final String OPEN_REPOSITORY_VIEW_LINK = "Open the Task Repositories view";
    private static final String REFRESH_BAMBOO_VIEW_LINK = "Refresh Bamboo View manually";
    private static final String ENABLE_AUTOMATIC_REFRESH = "Enable";
    private static final String CODE_HAS_CHANGED = "Code has changed";
    public static final String ID = "com.atlassian.connector.eclipse.bamboo.ui.plans";
    private BuildTreeViewer buildViewer;
    private Collection<EclipseBambooBuild> builds;
    final Image buildFailedImage = CommonImages.getImage((ImageDescriptor)BambooImages.VIEW_STATUS_FAILED);
    final Image buildPassedImage = CommonImages.getImage((ImageDescriptor)BambooImages.VIEW_STATUS_PASSED);
    final Image buildErrorImage = CommonImages.getImage((ImageDescriptor)BambooImages.VIEW_STATUS_WARNING);
    private final Image bambooImage;
    private Image currentTitleImage = this.bambooImage = CommonImages.getImage((ImageDescriptor)BambooImages.BAMBOO);
    private Link link;
    private StackLayout stackLayout;
    private Composite treeComp;
    private Composite linkComp;
    private HashMap<String, TaskRepository> linkedRepositories;
    private BaseSelectionListenerAction openInBrowserAction;
    private Action refreshAction;
    private BaseSelectionListenerAction showTestResultsAction;
    private BaseSelectionListenerAction runBuildAction;
    private BaseSelectionListenerAction newTaskFromFailedBuildAction;
    private Action repoConfigAction;
    private BaseSelectionListenerAction openRepoConfigAction;
    private BuildsChangedListener buildsChangedListener;
    private IStatusLineManager statusLineManager;
    private ToggleAutoRefreshAction toggleAutoRefreshAction;

    public BambooView() {
        this.builds = MiscUtil.buildArrayList();
    }

    public void createPartControl(Composite parent) {
        Composite stackComp = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        stackComp.setLayout((Layout)this.stackLayout);
        this.treeComp = new Composite(stackComp, 0);
        this.treeComp.setLayout((Layout)new FillLayout());
        this.linkComp = new Composite(stackComp, 0);
        this.linkComp.setLayout((Layout)new GridLayout());
        this.createLink(this.linkComp);
        this.createTreeViewer(this.treeComp);
        this.stackLayout.topControl = this.linkComp;
        stackComp.layout();
        this.createActions();
        this.fillTreeContextMenu();
        this.contributeToActionBars();
        IWorkbenchSiteProgressService progress = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progress != null) {
            progress.showBusyForFamily(BambooConstants.FAMILY_REFRESH_OPERATION);
        }
        this.buildsChangedListener = new BuildsChangedListener(){

            public void buildsUpdated(final BuildsChangedEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        BambooView.this.builds = BambooView.this.toEclipseBambooBuildCollection(event.getAllBuilds());
                        BambooView.this.refresh(event.isForcedRefresh(), event.isFailed());
                    }
                });
            }
        };
        BuildPlanManager buildPlanManager = BambooCorePlugin.getBuildPlanManager();
        buildPlanManager.addBuildsChangedListener(this.buildsChangedListener);
        if (buildPlanManager.isFirstScheduledSynchronizationDone()) {
            this.builds = this.toEclipseBambooBuildCollection(buildPlanManager.getSubscribedBuilds());
            this.refresh(false, false);
        }
    }

    private Collection<EclipseBambooBuild> toEclipseBambooBuildCollection(Map<TaskRepository, Collection<BambooBuild>> buildsPerTaskRepo) {
        ArrayList res = MiscUtil.buildArrayList();
        for (TaskRepository taskRepository : buildsPerTaskRepo.keySet()) {
            if (taskRepository.isOffline()) continue;
            Collection<BambooBuild> bambooBuilds = buildsPerTaskRepo.get(taskRepository);
            for (BambooBuild bambooBuild : bambooBuilds) {
                res.add(new EclipseBambooBuild(bambooBuild, taskRepository));
            }
        }
        return res;
    }

    public void dispose() {
        if (this.buildsChangedListener != null) {
            BambooCorePlugin.getBuildPlanManager().removeBuildsChangedListener(this.buildsChangedListener);
            this.buildsChangedListener = null;
        }
        this.buildViewer.dispose();
    }

    private void createTreeViewer(Composite parent) {
        this.buildViewer = new BuildTreeViewer(parent, 66306);
        this.buildViewer.setContentProvider((IContentProvider)new BuildContentProvider());
        this.buildViewer.setUseHashlookup(true);
        TreeViewerColumn columnName = new TreeViewerColumn((TreeViewer)this.buildViewer, 0);
        columnName.getColumn().setText("Build");
        columnName.getColumn().setWidth(300);
        columnName.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new BuildLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator())));
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this.buildViewer, 0);
        column.getColumn().setText("Status");
        column.getColumn().setWidth(350);
        column.setLabelProvider((CellLabelProvider)new BambooColumnProvider(){

            public String getText(Object element) {
                if (element instanceof EclipseBambooBuild) {
                    BambooBuild build = ((EclipseBambooBuild)element).getBuild();
                    StringBuilder builder = new StringBuilder();
                    int totalTests = build.getTestsFailed() + build.getTestsPassed();
                    try {
                        build.getNumber();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        return "N/A";
                    }
                    if (totalTests == 0) {
                        builder.append("Tests: Testless build");
                    } else if (build.getTestsFailed() > 0) {
                        builder.append(NLS.bind((String)"Tests: {0} out of {1} failed", (Object[])new Object[]{build.getTestsFailed(), totalTests}));
                    } else {
                        builder.append(NLS.bind((String)"Tests: All {0} tests passed", (Object[])new Object[]{totalTests}));
                    }
                    if (build.getReason() != null) {
                        builder.append("  [");
                        builder.append(build.getReason());
                        if (build.getReason().equals(BambooView.CODE_HAS_CHANGED) && build.getCommiters() != null) {
                            builder.append(" by ");
                            builder.append(StringUtils.join((Collection)build.getCommiters(), (String)", "));
                        }
                        builder.append("]");
                    }
                    return builder.toString();
                }
                return super.getText(element);
            }
        });
        column = new TreeViewerColumn((TreeViewer)this.buildViewer, 0);
        column.getColumn().setText("Last Built");
        column.getColumn().setWidth(200);
        column.setLabelProvider((CellLabelProvider)new BambooColumnProvider(){

            public String getText(Object element) {
                if (element instanceof EclipseBambooBuild) {
                    BambooBuild build = ((EclipseBambooBuild)element).getBuild();
                    try {
                        build.getNumber();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        return "N/A";
                    }
                    return DateUtil.getRelativePastDate((Date)build.getCompletionDate());
                }
                return super.getText(element);
            }
        });
        column = new TreeViewerColumn((TreeViewer)this.buildViewer, 0);
        column.getColumn().setText("State");
        column.getColumn().setWidth(60);
        column.setLabelProvider((CellLabelProvider)new BambooColumnProvider(){

            public String getText(Object element) {
                BambooBuild build;
                PlanState planState;
                if (element instanceof EclipseBambooBuild && (planState = (build = ((EclipseBambooBuild)element).getBuild()).getPlanState()) != null) {
                    switch (planState) {
                        case BUILDING: {
                            return "Building";
                        }
                        case IN_QUEUE: {
                            return "In queue";
                        }
                    }
                }
                return null;
            }
        });
        final BambooBuildViewerComparator comparator = new BambooBuildViewerComparator();
        final Tree tree = this.buildViewer.getTree();
        tree.getColumns()[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BambooBuildViewerComparator.SortOrder sortOrder = comparator.toggleSortOrder();
                BambooView.this.buildViewer.setComparator(null);
                BambooView.this.buildViewer.setComparator(comparator);
                tree.setSortDirection(sortOrder.getDirection());
            }
        });
        tree.setSortColumn(tree.getColumns()[0]);
        this.buildViewer.setComparator(comparator);
        this.buildViewer.setInput(this.builds);
        tree.setHeaderVisible(true);
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (BambooView.this.openInBrowserAction.isEnabled()) {
                    BambooView.this.openInBrowserAction.run();
                }
            }
        });
    }

    private void createLink(Composite parent) {
        parent.setBackground(parent.getDisplay().getSystemColor(25));
        this.link = new Link(parent, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = 5;
        gridData.verticalIndent = 5;
        this.link.setBackground(parent.getDisplay().getSystemColor(25));
        this.link.setLayoutData((Object)gridData);
        if (BambooCorePlugin.isAutoRefresh()) {
            this.link.setText("Initializing view...");
        } else {
            this.link.setText(NLS.bind((String)"Automatic refresh is disabled. <a>{0}</a> it or <a>{1}</a>.", (Object)ENABLE_AUTOMATIC_REFRESH, (Object)REFRESH_BAMBOO_VIEW_LINK));
        }
        this.link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String link = event.text;
                if (link.equals(BambooView.REFRESH_BAMBOO_VIEW_LINK)) {
                    BambooView.this.refreshBuilds();
                } else if (link.equals(BambooView.ENABLE_AUTOMATIC_REFRESH)) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)BambooView.this.getSite().getShell(), (String)"com.atlassian.connector.eclipse.bamboo.ui.preferences.BambooPreferencePage", null, null).open();
                } else if (link.equals(BambooView.CREATE_A_NEW_REPOSITORY_LINK)) {
                    new RepositoryConfigurationAction().run();
                } else if (BambooView.this.linkedRepositories != null) {
                    TaskRepository repository = (TaskRepository)BambooView.this.linkedRepositories.get(link);
                    if (repository != null) {
                        OpenRepositoryConfigurationAction openRepAction = new OpenRepositoryConfigurationAction();
                        openRepAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)repository));
                        openRepAction.run();
                    }
                } else if (link.equals(BambooView.OPEN_REPOSITORY_VIEW_LINK)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                BambooView.this.getSite().getPage().showView("org.eclipse.mylyn.tasks.ui.views.repositories");
                            }
                            catch (PartInitException partInitException) {
                                StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.bamboo.ui", "Failed to show Task Repositories View"));
                            }
                        }
                    });
                }
            }
        });
    }

    private void fillLink(Set<TaskRepository> repositories) {
        if (this.link.isDisposed()) {
            return;
        }
        if (repositories == null || repositories.isEmpty()) {
            this.link.setText(NLS.bind((String)"No Bamboo repositories defined, <a>{0}</a>...", (Object)CREATE_A_NEW_REPOSITORY_LINK));
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("No subscriptions to Bamboo build plans. ");
            builder.append("<a>");
            builder.append(OPEN_REPOSITORY_VIEW_LINK);
            builder.append("</a> to configure subscriptions or <a>");
            builder.append(CREATE_A_NEW_REPOSITORY_LINK);
            builder.append("</a>...");
            this.link.setText(builder.toString());
        }
        this.link.getParent().layout();
    }

    private void fillTreeContextMenu() {
        MenuManager contextMenuManager = new MenuManager("BAMBOO");
        contextMenuManager.add((IAction)this.openInBrowserAction);
        contextMenuManager.add((IContributionItem)new Separator());
        contextMenuManager.add((IAction)this.showTestResultsAction);
        contextMenuManager.add((IContributionItem)new Separator());
        contextMenuManager.add((IAction)this.runBuildAction);
        contextMenuManager.add((IAction)this.newTaskFromFailedBuildAction);
        contextMenuManager.add((IContributionItem)new Separator());
        contextMenuManager.add((IAction)this.refreshAction);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        contextMenuManager.add((IContributionItem)new Separator());
        contextMenuManager.add((IAction)this.openRepoConfigAction);
        Menu contextMenu = contextMenuManager.createContextMenu(this.buildViewer.getControl());
        this.buildViewer.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(contextMenuManager, (ISelectionProvider)this.buildViewer);
    }

    public void setFocus() {
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillPopupMenu(bars.getMenuManager());
        this.fillToolBar(bars.getToolBarManager());
        bars.getMenuManager().add((IAction)this.toggleAutoRefreshAction);
    }

    private void fillToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.repoConfigAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.openInBrowserAction);
        toolBarManager.add((IAction)this.showTestResultsAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.runBuildAction);
        toolBarManager.add((IContributionItem)new Separator("additions"));
    }

    private void createActions() {
        this.refreshAction = new Action(){

            public void run() {
                BambooView.this.refreshBuilds();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh all builds");
        this.refreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.refreshAction.setImageDescriptor(CommonImages.REFRESH);
        this.openInBrowserAction = new OpenInBrowserAction();
        this.openInBrowserAction.setEnabled(false);
        this.openInBrowserAction.setText("Open with Browser");
        this.openInBrowserAction.setImageDescriptor(CommonImages.BROWSER_SMALL);
        this.buildViewer.addSelectionChangedListener((ISelectionChangedListener)this.openInBrowserAction);
        this.showTestResultsAction = new ShowTestResultsAction();
        this.showTestResultsAction.setEnabled(false);
        this.buildViewer.addSelectionChangedListener((ISelectionChangedListener)this.showTestResultsAction);
        this.newTaskFromFailedBuildAction = new NewTaskFromFailedBuildAction();
        this.newTaskFromFailedBuildAction.setEnabled(false);
        this.buildViewer.addSelectionChangedListener((ISelectionChangedListener)this.newTaskFromFailedBuildAction);
        this.runBuildAction = new RunBuildAction(this.refreshAction);
        this.runBuildAction.setEnabled(false);
        this.buildViewer.addSelectionChangedListener((ISelectionChangedListener)this.runBuildAction);
        this.repoConfigAction = new RepositoryConfigurationAction();
        this.repoConfigAction.setMenuCreator((IMenuCreator)this.repoConfigAction);
        this.toggleAutoRefreshAction = new ToggleAutoRefreshAction();
        this.openRepoConfigAction = new OpenRepositoryConfigurationAction();
        this.openRepoConfigAction.setEnabled(false);
        this.buildViewer.addSelectionChangedListener((ISelectionChangedListener)this.openRepoConfigAction);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.openRepoConfigAction);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
    }

    private void refresh(boolean forcedRefresh, boolean failed) {
        boolean isTreeShown;
        boolean hasSubscriptions = !this.builds.isEmpty();
        ViewStatus status = this.getMostSevereStatus(this.builds);
        boolean bl = isTreeShown = this.stackLayout.topControl == this.treeComp;
        if (hasSubscriptions && !isTreeShown) {
            this.stackLayout.topControl = this.treeComp;
            this.treeComp.getParent().layout();
        } else if (!hasSubscriptions) {
            this.fillLink(TasksUi.getRepositoryManager().getRepositories("bamboo"));
            this.stackLayout.topControl = this.linkComp;
            this.linkComp.getParent().layout();
        }
        this.statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        if (failed) {
            if (forcedRefresh) {
                this.statusLineManager.setErrorMessage(CommonImages.getImage((ImageDescriptor)CommonImages.WARNING), "Error while refreshing build plans. See Error Log for details.");
            } else {
                this.statusLineManager.setErrorMessage(CommonImages.getImage((ImageDescriptor)CommonImages.WARNING), "Error while refreshing build plans. Retry by manually invoking a refresh in the view's toolbar.");
            }
        } else {
            this.statusLineManager.setErrorMessage(null);
            this.statusLineManager.setMessage("Last Refresh: " + new SimpleDateFormat("MMM d, H:mm:ss").format(new Date()));
        }
        this.updateViewIcon(status);
        this.buildViewer.setBuilds(this.builds);
        this.buildViewer.refresh(true);
    }

    private ViewStatus getViewStatus(BambooBuild build) {
        switch (build.getStatus()) {
            case FAILURE: {
                return ViewStatus.FAILED;
            }
            case SUCCESS: {
                return ViewStatus.PASSED;
            }
        }
        return ViewStatus.NONE;
    }

    private ViewStatus getMostSevereStatus(Collection<EclipseBambooBuild> repoBuilds) {
        ViewStatus status = ViewStatus.NONE;
        for (EclipseBambooBuild buildAdapter : repoBuilds) {
            ViewStatus buildStatus;
            BambooBuild build = buildAdapter.getBuild();
            if (!build.getEnabled() || (buildStatus = this.getViewStatus(build)).ordinal() <= status.ordinal()) continue;
            status = buildStatus;
        }
        return status;
    }

    private void updateViewIcon(ViewStatus status) {
        switch (status) {
            case PASSED: {
                this.currentTitleImage = this.buildPassedImage;
                break;
            }
            case FAILED: {
                this.currentTitleImage = this.buildFailedImage;
                break;
            }
            case ERROR: {
                this.currentTitleImage = this.buildErrorImage;
                break;
            }
            default: {
                this.currentTitleImage = this.bambooImage;
            }
        }
        this.firePropertyChange(1);
    }

    private void fillPopupMenu(IMenuManager menuManager) {
    }

    public Image getTitleImage() {
        if (this.currentTitleImage == null) {
            return super.getTitleImage();
        }
        return this.currentTitleImage;
    }

    private void refreshBuilds() {
        BambooCorePlugin.getBuildPlanManager().refreshAllBuilds();
    }

    private static class BambooColumnProvider
    extends ColumnLabelProvider {
        private BambooColumnProvider() {
        }

        public Font getFont(Object element) {
            return BambooUiUtil.getFontForBuildStatus(element);
        }
    }

    private class BuildContentProvider
    implements ITreeContentProvider {
        private BuildContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<EclipseBambooBuild> children = new ArrayList<EclipseBambooBuild>(BambooView.this.builds.size());
            if (parentElement instanceof EclipseBambooBuild) {
                EclipseBambooBuild build = (EclipseBambooBuild)parentElement;
                for (EclipseBambooBuild b : BambooView.this.builds) {
                    if (!build.getBuild().getPlanKey().equals(b.getBuild().getMasterPlanKey())) continue;
                    children.add(b);
                }
            }
            return children.toArray();
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<EclipseBambooBuild> ret = new ArrayList<EclipseBambooBuild>(BambooView.this.builds.size());
            for (EclipseBambooBuild build : BambooView.this.builds) {
                if (build.getBuild().getMasterPlanKey() != null && build.getBuild().getMasterPlanKey().length() != 0) continue;
                ret.add(build);
            }
            return ret.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof EclipseBambooBuild) {
                EclipseBambooBuild build = (EclipseBambooBuild)element;
                for (EclipseBambooBuild b : BambooView.this.builds) {
                    if (!build.getBuild().getPlanKey().equals(b.getBuild().getMasterPlanKey())) continue;
                    return true;
                }
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class OpenInBrowserAction
    extends BaseSelectionListenerAction {
        public OpenInBrowserAction() {
            super(null);
        }

        public void run() {
            ISelection s = BambooView.this.buildViewer.getSelection();
            if (s instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)s;
                for (Object selected : selection) {
                    if (!(selected instanceof EclipseBambooBuild)) continue;
                    String url = BambooUtil.getUrlFromBuild((BambooBuild)((EclipseBambooBuild)selected).getBuild());
                    TasksUiUtil.openUrl((String)url);
                }
            }
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            if (selection.size() >= 1) {
                try {
                    Iterator it = selection.iterator();
                    while (it.hasNext()) {
                        ((EclipseBambooBuild)it.next()).getBuild().getNumber();
                    }
                    return true;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ViewStatus {
        NONE,
        PASSED,
        FAILED,
        ERROR;

    }
}

