/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.tracing;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.ViewPart;
import org.springframework.ide.eclipse.aop.ui.Activator;
import org.springframework.ide.eclipse.aop.ui.tracing.ClearEventTraceAction;
import org.springframework.ide.eclipse.aop.ui.tracing.DebugTracing;
import org.springframework.ide.eclipse.aop.ui.tracing.EventTrace;

public class EventTraceView
extends ViewPart
implements EventTrace.EventListener {
    StyledText text;
    private ClearEventTraceAction clearEventTraceAction;
    private Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");

    public void dispose() {
        EventTrace.removeListener(this);
        DebugTracing.DEBUG = false;
    }

    public void createPartControl(Composite parent) {
        this.text = new StyledText(parent, 778);
        this.startup();
        EventTrace.addListener(this);
        this.makeActions();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider(new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return null;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        });
    }

    private void startup() {
        DebugTracing.DEBUG = true;
        this.aopEvent(DebugTracing.startupInfo(), 0, new Date());
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public void aopEvent(String msg, final int category, Date time) {
        final String txt = String.valueOf(DateFormat.getTimeInstance().format(time)) + " " + msg + "\n";
        Activator.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                EventTraceView.this.appendEventText(txt, category);
            }
        });
    }

    private void appendEventText(String msg, int category) {
        if (this.text.isDisposed()) {
            return;
        }
        IViewSite site = this.getViewSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null) {
            return;
        }
        StyleRange styleRange = new StyleRange();
        styleRange.font = this.font;
        styleRange.start = this.text.getText().length();
        styleRange.length = msg.length();
        styleRange.foreground = category == 1 ? display.getSystemColor(10) : (category == 2 ? display.getSystemColor(4) : (category == 1 || category == 3 || category == 4 ? display.getSystemColor(6) : display.getSystemColor(2)));
        this.text.append(msg);
        this.text.setStyleRange(styleRange);
        this.text.setTopIndex(this.text.getLineCount() - 1);
    }

    private void makeActions() {
        this.clearEventTraceAction = new ClearEventTraceAction(this.text);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.clearEventTraceAction);
    }
}

