/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceAopReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.ModelUtils;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdviceAopTargetNode
implements IReferenceNode,
IRevealableReferenceNode {
    private List<IAopReference> references;

    public AdviceAopTargetNode(List<IAopReference> reference) {
        this.references = reference;
    }

    @Override
    public IReferenceNode[] getChildren() {
        ArrayList<AdviceAopReferenceNode> nodes = new ArrayList<AdviceAopReferenceNode>();
        HashMap refs = new HashMap();
        for (IAopReference iAopReference : this.references) {
            if (refs.containsKey(iAopReference.getDefinition())) {
                ((List)refs.get(iAopReference.getDefinition())).add(iAopReference);
                continue;
            }
            ArrayList<IAopReference> ref = new ArrayList<IAopReference>();
            ref.add(iAopReference);
            refs.put(iAopReference.getDefinition(), ref);
        }
        for (Map.Entry entry : refs.entrySet()) {
            nodes.add(new AdviceAopReferenceNode((List)entry.getValue()));
        }
        return nodes.toArray(new IReferenceNode[nodes.size()]);
    }

    @Override
    public Image getImage() {
        IAopReference.ADVICE_TYPE type = this.references.get(0).getAdviceType();
        if (type == IAopReference.ADVICE_TYPE.AFTER || type == IAopReference.ADVICE_TYPE.AFTER_RETURNING || type == IAopReference.ADVICE_TYPE.AFTER_THROWING) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.after_advice_obj.gif");
        }
        if (type == IAopReference.ADVICE_TYPE.BEFORE) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.before_advice_obj.gif");
        }
        if (type == IAopReference.ADVICE_TYPE.AROUND) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.around_advice_obj.gif");
        }
        if (type == IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.introduction_obj.gif");
        }
        return null;
    }

    @Override
    public String getText() {
        IAopReference.ADVICE_TYPE type = this.references.get(0).getAdviceType();
        String text = "";
        if (type == IAopReference.ADVICE_TYPE.AFTER) {
            text = String.valueOf(text) + "after()";
        } else if (type == IAopReference.ADVICE_TYPE.AFTER_RETURNING) {
            text = String.valueOf(text) + "after-returning()";
        } else if (type == IAopReference.ADVICE_TYPE.AFTER_THROWING) {
            text = String.valueOf(text) + "after-throwing()";
        } else if (type == IAopReference.ADVICE_TYPE.BEFORE) {
            text = String.valueOf(text) + "before()";
        } else if (type == IAopReference.ADVICE_TYPE.AROUND) {
            text = String.valueOf(text) + "around()";
        }
        text = String.valueOf(text) + " <";
        text = String.valueOf(text) + this.references.get(0).getDefinition().getAspectName();
        text = String.valueOf(text) + "> - ";
        text = String.valueOf(text) + ModelUtils.getFilePath(this.getResource());
        return text;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void openAndReveal() {
        IResource resource = this.references.get(0).getDefinition().getResource();
        SpringUIUtils.openInEditor((IFile)((IFile)resource), (int)this.references.get(0).getDefinition().getAspectStartLineNumber());
    }

    public IAopReference getReference() {
        return this.references.get(0);
    }

    @Override
    public int getLineNumber() {
        return this.references.get(0).getDefinition().getAspectStartLineNumber();
    }

    @Override
    public IResource getResource() {
        return this.references.get(0).getResource();
    }

    @Override
    public Object getReferenceParticipant() {
        return this.references.get(0).getDefinition();
    }
}

