/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.springframework.ide.eclipse.aop.ui.Activator;
import org.springframework.ide.eclipse.aop.ui.navigator.action.ToggleShowBeanRefsForFileAction;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AbstractJavaElementReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceAopReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceDeclareParentAopReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdvisedAopReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdvisedDeclareParentAopReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.util.AopReferenceModelNavigatorUtils;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.core.model.IModelChangeListener;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springframework.ide.eclipse.ui.dialogs.WrappingStructuredSelection;
import org.w3c.dom.Element;

public class AopReferenceModelNavigator
extends CommonNavigator
implements ISelectionListener,
IModelChangeListener {
    public static final String ID = "org.springframework.ide.eclipse.aop.ui.navigator.aopReferenceModelNavigator";
    public static final String BEAN_REFS_FOR_FILE_ID = "org.springframework.ide.eclipse.aop.ui.navigator.aopReferenceModelNavigator.beanRefsForFile";
    private static boolean showBeansRefsForFileEnabled;
    private Object lastElement;
    private ISelection lastSelection;
    private IWorkbenchPart lastWorkbenchPart;
    private ToggleShowBeanRefsForFileAction toggleShowBeanRefsForFileAction;
    private IPropertyListener propertyListener;

    static {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        showBeansRefsForFileEnabled = pstore.getBoolean(BEAN_REFS_FOR_FILE_ID);
    }

    public static int calculateExpandToLevel(Object element) {
        return -1;
    }

    public static Object calculateRootElement(Object element) {
        return AopReferenceModelNavigator.calculateRootElement(element, showBeansRefsForFileEnabled);
    }

    public static Object calculateRootElement(Object element, boolean showBeansRefsForFile) {
        if (showBeansRefsForFile && element != null) {
            if (element instanceof IMethod) {
                element = ((IMethod)element).getDeclaringType();
            } else if (element instanceof Element) {
                element = ((Element)element).getOwnerDocument().getDocumentElement();
            } else if (element instanceof IField) {
                element = ((IField)element).getDeclaringType();
            }
        }
        return element;
    }

    public static void expandTree(TreeItem[] items, boolean b) {
        if (items != null) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                Object obj = item.getData();
                if (obj instanceof AdviceAopReferenceNode || obj instanceof AdvisedAopReferenceNode || obj instanceof AdviceDeclareParentAopReferenceNode || obj instanceof AdvisedDeclareParentAopReferenceNode) {
                    AopReferenceModelNavigator.expandTree(item.getItems(), true);
                } else {
                    AopReferenceModelNavigator.expandTree(item.getItems(), b);
                }
                if (b) {
                    item.setExpanded(false);
                }
                ++n2;
            }
        }
    }

    public static void refreshViewer(TreeViewer viewer, Object rootElement, Object element) {
        viewer.getTree().setRedraw(false);
        viewer.setInput(rootElement);
        viewer.expandToLevel(AopReferenceModelNavigator.calculateExpandToLevel(rootElement));
        AopReferenceModelNavigator.expandTree(viewer.getTree().getItems(), false);
        AopReferenceModelNavigator.revealSelection(viewer, element);
        viewer.getTree().setRedraw(true);
    }

    public static void revealSelection(TreeViewer viewer, Object javaElement) {
        AopReferenceModelNavigator.revealSelection(viewer, javaElement, showBeansRefsForFileEnabled);
    }

    public static void revealSelection(TreeViewer viewer, Object javaElement, boolean showBeansRefsForFile) {
        TreeItem[] items = viewer.getTree().getItems();
        Object wr = null;
        if (javaElement instanceof IJavaElement) {
            if (showBeansRefsForFile && javaElement instanceof IMethod) {
                TreeItem[] aspectChildren;
                TreeItem[] treeItemArray = aspectChildren = items[0].getItems();
                int n = aspectChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem element = treeItemArray[n2];
                    Object obj = element.getData();
                    if (obj instanceof AbstractJavaElementReferenceNode && ((AbstractJavaElementReferenceNode)obj).getElement().equals(javaElement)) {
                        wr = obj;
                        break;
                    }
                    ++n2;
                }
            } else if (items != null && items.length > 0) {
                wr = items[0].getData();
            }
        } else if (javaElement instanceof ElementImpl) {
            if (!showBeansRefsForFile) {
                if (items != null && items.length > 0) {
                    wr = items[0].getData();
                }
            } else {
                ElementImpl element = (ElementImpl)javaElement;
                IStructuredDocument document = element.getStructuredDocument();
                int startLine = document.getLineOfOffset(element.getStartOffset()) + 1;
                int endLine = document.getLineOfOffset(element.getEndOffset()) + 1;
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n3 = 0;
                while (n3 < n) {
                    TreeItem element0 = treeItemArray[n3];
                    Object obj = element0.getData();
                    if (obj instanceof IRevealableReferenceNode && ((IRevealableReferenceNode)obj).getLineNumber() >= startLine && ((IRevealableReferenceNode)obj).getLineNumber() <= endLine) {
                        wr = obj;
                        break;
                    }
                    ++n3;
                }
            }
        }
        if (wr != null) {
            viewer.setSelection((ISelection)new StructuredSelection(wr), true);
            viewer.reveal(wr);
        }
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        BeansCorePlugin.getModel().addChangeListener((IModelChangeListener)this);
        this.propertyListener = new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 65536) {
                    AopReferenceModelNavigator.this.updateTreeViewer(AopReferenceModelNavigator.this.lastWorkbenchPart, AopReferenceModelNavigator.this.lastSelection, false);
                }
            }
        };
        this.addPropertyListener(this.propertyListener);
        this.makeActions();
    }

    public void dispose() {
        this.removePropertyListener(this.propertyListener);
        super.dispose();
        BeansCorePlugin.getModel().removeChangeListener((IModelChangeListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public boolean isShowBeansRefsForFileEnabled() {
        return showBeansRefsForFileEnabled;
    }

    private void makeActions() {
        this.toggleShowBeanRefsForFileAction = new ToggleShowBeanRefsForFileAction(this);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.toggleShowBeanRefsForFileAction);
        bars.getMenuManager().add((IAction)this.toggleShowBeanRefsForFileAction);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            selection = new WrappingStructuredSelection((IStructuredSelection)selection);
        }
        this.updateTreeViewer(part, selection, true);
    }

    public void setShowBeansRefsForFileEnabled(boolean showBeansRefsForFileEnabled) {
        AopReferenceModelNavigator.showBeansRefsForFileEnabled = showBeansRefsForFileEnabled;
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        pstore.setValue(BEAN_REFS_FOR_FILE_ID, showBeansRefsForFileEnabled);
        Activator.getDefault().savePluginPreferences();
        this.updateTreeViewer(this.lastWorkbenchPart, this.lastSelection, false);
    }

    private void updateTreeViewer(final IWorkbenchPart part, final ISelection selection, final boolean ignoreSameSelection) {
        Control ctrl = this.getCommonViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.determineAndRefreshViewer(part, selection, ignoreSameSelection);
        } else {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Control ctrl = AopReferenceModelNavigator.this.getCommonViewer().getControl();
                    if (ctrl == null || ctrl.isDisposed()) {
                        return;
                    }
                    AopReferenceModelNavigator.this.determineAndRefreshViewer(part, selection, ignoreSameSelection);
                }
            });
        }
    }

    private void determineAndRefreshViewer(IWorkbenchPart part, ISelection selection, boolean ignoreSameSelection) {
        Object element = AopReferenceModelNavigatorUtils.getSelectedElement(part, selection);
        if (element == null || element.equals(this.lastElement) && ignoreSameSelection) {
            return;
        }
        if ((element instanceof IType || element instanceof IMethod || element instanceof IField || element instanceof Element) && this.isLinkingEnabled()) {
            AopReferenceModelNavigator.refreshViewer((TreeViewer)this.getCommonViewer(), AopReferenceModelNavigator.calculateRootElement(element, showBeansRefsForFileEnabled), element);
            this.lastElement = element;
            this.lastSelection = selection;
            this.lastWorkbenchPart = part;
        }
    }

    public void elementChanged(ModelChangeEvent event) {
        if (event == null || event.getType() == ModelChangeEvent.Type.ADDED || event.getType() == ModelChangeEvent.Type.REMOVED) {
            this.updateTreeViewer(this.lastWorkbenchPart, this.lastSelection, false);
        }
    }
}

