/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.maven.internal.legacyconversion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.maven.internal.legacyconversion.IM2EConstants;
import org.springframework.ide.eclipse.maven.internal.legacyconversion.LegacyProjectChecker;
import org.springframework.ide.eclipse.maven.internal.legacyconversion.ListMessageDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LegacyProjectConverter
implements IM2EConstants {
    private final List<IProject> allLegacyProjects;
    private IProject[] selectedLegacyProjects;

    public LegacyProjectConverter(List<IProject> legacyProjects) {
        this.allLegacyProjects = legacyProjects;
    }

    public boolean askToConvert(Shell shell, boolean enableToggle) {
        if (LegacyProjectChecker.NON_BLOCKING) {
            return true;
        }
        this.selectedLegacyProjects = ListMessageDialog.openViewer(shell, this.allLegacyProjects.toArray(new IProject[0]));
        return this.selectedLegacyProjects != null;
    }

    public IStatus convert(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)this.selectedLegacyProjects.length);
        IStatus[] statuses = new IStatus[this.selectedLegacyProjects.length];
        int i = 0;
        IProject[] iProjectArray = this.selectedLegacyProjects;
        int n = this.selectedLegacyProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                sub.subTask("Converting " + project.getName());
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                statuses[i++] = this.convert(project, monitor);
            } else {
                statuses[i++] = Status.OK_STATUS;
            }
            sub.worked(1);
            ++n2;
        }
        return new MultiStatus("org.springframework.ide.eclipse.maven", 0, statuses, "Result of converting legacy maven projects", null);
    }

    private IStatus convert(IProject project, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        Job.getJobManager().beginRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), (IProgressMonitor)sub);
        try {
            try {
                IProjectDescription description = project.getDescription();
                String[] ids = description.getNatureIds();
                ArrayList<String> newIds = new ArrayList<String>(ids.length);
                int i = 0;
                while (i < ids.length) {
                    if (!ids[i].equals("org.maven.ide.eclipse.maven2Nature") && !ids[i].equals("org.eclipse.m2e.core.maven2Nature")) {
                        newIds.add(ids[i]);
                    }
                    ++i;
                }
                newIds.add("org.eclipse.m2e.core.maven2Nature");
                description.setNatureIds(newIds.toArray(new String[0]));
                ICommand[] commands = description.getBuildSpec();
                ArrayList<ICommand> newCommands = new ArrayList<ICommand>();
                int i2 = 0;
                while (i2 < commands.length) {
                    if (!commands[i2].getBuilderName().equals("org.eclipse.m2e.core.maven2Builder")) {
                        if (commands[i2].getBuilderName().equals("org.maven.ide.eclipse.maven2Builder")) {
                            commands[i2].setBuilderName("org.eclipse.m2e.core.maven2Builder");
                        }
                        newCommands.add(commands[i2]);
                    }
                    ++i2;
                }
                description.setBuildSpec(newCommands.toArray(new ICommand[0]));
                project.setDescription(description, (IProgressMonitor)sub);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.springframework.ide.eclipse.maven", "Failed to convert " + project.getName(), (Throwable)e);
                Job.getJobManager().endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                return status;
            }
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> newClasspath = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < classpath.length) {
                if (!classpath[i].getPath().toString().equals("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER")) {
                    if (classpath[i].getPath().toString().equals("org.maven.ide.eclipse.MAVEN2_CLASSPATH_CONTAINER")) {
                        classpath[i] = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER"), (IAccessRule[])classpath[i].getAccessRules(), (IClasspathAttribute[])classpath[i].getExtraAttributes(), (boolean)classpath[i].isExported());
                    }
                    newClasspath.add(classpath[i]);
                }
                ++i;
            }
            javaProject.setRawClasspath(newClasspath.toArray(new IClasspathEntry[0]), (IProgressMonitor)sub);
        }
        catch (Exception e) {
            return new Status(4, "org.springframework.ide.eclipse.maven", "Failed to convert " + project.getName(), (Throwable)e);
        }
        sub.worked(1);
        return new Status(0, "org.springframework.ide.eclipse.maven", "Converted " + project.getName());
    }

    private String createMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.allLegacyProjects.size() > 1) {
            sb.append("The following legacy Maven projects have been found:\n");
        } else {
            sb.append("The following legacy Maven project has been found:\n");
        }
        for (IProject project : this.allLegacyProjects) {
            sb.append("\t" + project.getName() + "\n");
        }
        if (this.allLegacyProjects.size() > 1) {
            sb.append("\n** These projects will not compile until they are upgraded to M2E version 1.0. **\n\n");
        } else {
            sb.append("\n** This project will not compile until it is upgraded to M2E version 1.0. **\n\n");
        }
        sb.append("Do you want to upgrade now?\nYou can choose to upgrade later by going to:\nProject -> Configure -> Convert legacy Maven projects...");
        return sb.toString();
    }
}

