/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.maven.internal.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.maven.MavenCorePlugin;
import org.springframework.util.FileCopyUtils;
import org.springsource.ide.eclipse.commons.configurator.ConfigurableExtension;
import org.springsource.ide.eclipse.commons.configurator.WorkspaceLocationConfiguratorParticipant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenRepositoryWorkspaceConfigurator
extends WorkspaceLocationConfiguratorParticipant {
    public String getPath() {
        return "maven-repository";
    }

    public String getVersionRange() {
        return "0.0.0";
    }

    protected ConfigurableExtension doCreateExtension(File location, IProgressMonitor monitor) {
        if (MavenCorePlugin.IS_M2ECLIPSE_PRESENT) {
            return new M2EclipseDependentRepositoryExtension(location.getName(), location);
        }
        return null;
    }

    private class M2EclipseDependentRepositoryExtension
    extends ConfigurableExtension {
        private static final String LOCAL_REPOSITORY_ELEMENT_NAME = "localRepository";
        private static final String QUESTION = "SpringSource Tool Suite has detected a local Maven repository at:\n\n    %s\n\nDo you want to merge the contents into your global Maven repository? This will make the repository contents available from Maven builds outside of STS as well.";
        private static final String SETTINGS_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<settings></settings>";
        private File location;
        private String oldUserSettingsFileName;

        public M2EclipseDependentRepositoryExtension(String id, File location) {
            super(id);
            this.location = location;
            this.setLocation(location.getAbsolutePath());
            this.setLabel("Maven Repository");
        }

        public IStatus configure(IProgressMonitor monitor) {
            String userSettingsFileName;
            this.oldUserSettingsFileName = userSettingsFileName = MavenPlugin.getMavenConfiguration().getUserSettingsFile();
            UIJob job = new UIJob("Configure Maven Repository"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        File globalRespository = MavenPlugin.getRepositoryRegistry().getLocalRepository().getBasedir();
                        if (M2EclipseDependentRepositoryExtension.this.ask(M2EclipseDependentRepositoryExtension.this.location.getCanonicalPath())) {
                            Resource[] resources;
                            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                            Resource[] resourceArray = resources = resolver.getResources("file://" + M2EclipseDependentRepositoryExtension.this.location.getCanonicalPath() + File.separatorChar + "**");
                            int n = resources.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Resource resource = resourceArray[n2];
                                File fileResource = resource.getFile();
                                if (fileResource.isFile()) {
                                    String relativePath = fileResource.getCanonicalPath().substring(M2EclipseDependentRepositoryExtension.this.location.getCanonicalPath().length() + 1, fileResource.getCanonicalPath().length());
                                    monitor.subTask(String.format("Copying '%s'", relativePath));
                                    File newFileResource = new File(globalRespository, relativePath);
                                    if (!newFileResource.exists()) {
                                        newFileResource.getParentFile().mkdirs();
                                        FileCopyUtils.copy((File)fileResource, (File)newFileResource);
                                    }
                                }
                                ++n2;
                            }
                        } else {
                            File userSettingsFile = new File(userSettingsFileName);
                            if (!userSettingsFile.exists()) {
                                BufferedWriter writer = new BufferedWriter(new FileWriter(M2EclipseDependentRepositoryExtension.this.getSettingsFile()));
                                writer.append(M2EclipseDependentRepositoryExtension.SETTINGS_TEMPLATE);
                                writer.close();
                            } else {
                                FileCopyUtils.copy((File)userSettingsFile, (File)M2EclipseDependentRepositoryExtension.this.getSettingsFile());
                            }
                            Document document = SpringCoreUtils.parseDocument((URI)M2EclipseDependentRepositoryExtension.this.getSettingsFile().toURI());
                            NodeList nodes = document.getDocumentElement().getChildNodes();
                            boolean found = false;
                            int i = 0;
                            while (i < nodes.getLength()) {
                                Node node = nodes.item(i);
                                if (M2EclipseDependentRepositoryExtension.LOCAL_REPOSITORY_ELEMENT_NAME.equals(node.getLocalName()) || M2EclipseDependentRepositoryExtension.LOCAL_REPOSITORY_ELEMENT_NAME.equals(node.getNodeName())) {
                                    node.setTextContent(M2EclipseDependentRepositoryExtension.this.location.getCanonicalPath());
                                    found = true;
                                    break;
                                }
                                ++i;
                            }
                            if (!found) {
                                Element node = document.createElement(M2EclipseDependentRepositoryExtension.LOCAL_REPOSITORY_ELEMENT_NAME);
                                node.appendChild(document.createTextNode(M2EclipseDependentRepositoryExtension.this.location.getCanonicalPath()));
                                document.getDocumentElement().appendChild(node);
                            }
                            TransformerFactory transformerFactory = TransformerFactory.newInstance();
                            Transformer transformer = transformerFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "no");
                            transformer.setOutputProperty("indent", "yes");
                            transformer.setOutputProperty("encoding", document.getInputEncoding());
                            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(M2EclipseDependentRepositoryExtension.this.getSettingsFile()), document.getInputEncoding());
                            StreamResult result = new StreamResult(out);
                            DOMSource source = new DOMSource(document);
                            transformer.transform(source, result);
                            ((Writer)out).close();
                            MavenPlugin.getMavenConfiguration().setUserSettingsFile(M2EclipseDependentRepositoryExtension.this.getSettingsFile().getCanonicalPath());
                        }
                    }
                    catch (Exception e) {
                        MavenCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.maven", 1, e.getMessage(), (Throwable)e));
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            final boolean[] done = new boolean[1];
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    done[0] = true;
                }
            });
            job.schedule();
            while (!done[0]) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
            }
            return Status.OK_STATUS;
        }

        public IStatus unConfigure(IProgressMonitor monitor) {
            try {
                MavenPlugin.getMavenConfiguration().setUserSettingsFile(this.oldUserSettingsFileName);
            }
            catch (CoreException coreException) {}
            return Status.OK_STATUS;
        }

        private boolean ask(String repositoryPath) {
            return MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Configure Maven Repository", (String)String.format(QUESTION, repositoryPath));
        }

        private File getSettingsFile() {
            return new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), "settings.xml");
        }
    }
}

