/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.viewers;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarEntryDirectory;
import org.eclipse.jface.viewers.Viewer;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;
import org.springframework.ide.eclipse.ui.viewers.FileSuffixFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFileSuffixFilter
extends FileSuffixFilter {
    public JavaFileSuffixFilter(String[] allowedFileExtensions) {
        super(allowedFileExtensions);
    }

    public JavaFileSuffixFilter(Collection<String> allowedFileExtensions) {
        super(allowedFileExtensions.toArray(new String[allowedFileExtensions.size()]));
    }

    public JavaFileSuffixFilter() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            try {
                Object[] objectArray = root.getChildren();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = objectArray[n2];
                    if (this.select(viewer, parent, child)) {
                        return true;
                    }
                    ++n2;
                }
                objectArray = root.getNonJavaResources();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    IJavaElement nonJavaResource = objectArray[n2];
                    if (this.select(viewer, parent, nonJavaResource)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                SpringUIPlugin.log(e.getStatus());
            }
            return false;
        }
        if (element instanceof IPackageFragment) {
            IPackageFragment fragment = (IPackageFragment)element;
            try {
                Object[] objectArray = fragment.getChildren();
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IJavaElement child = objectArray[n3];
                    if (this.select(viewer, parent, child)) {
                        return true;
                    }
                    ++n3;
                }
                objectArray = fragment.getNonJavaResources();
                n = objectArray.length;
                n3 = 0;
                while (n3 < n) {
                    IJavaElement nonJavaResource = objectArray[n3];
                    if (this.select(viewer, parent, nonJavaResource)) {
                        return true;
                    }
                    ++n3;
                }
            }
            catch (JavaModelException e) {
                SpringUIPlugin.log(e.getStatus());
            }
            return false;
        }
        if (element instanceof JarEntryDirectory) {
            IJarEntryResource[] iJarEntryResourceArray = ((JarEntryDirectory)element).getChildren();
            int n = iJarEntryResourceArray.length;
            int n4 = 0;
            while (n4 < n) {
                IJarEntryResource child = iJarEntryResourceArray[n4];
                if (this.select(viewer, parent, child)) {
                    return true;
                }
                ++n4;
            }
        } else if (element instanceof IStorage && !(element instanceof IFile)) {
            return this.hasAllowedFileSuffix(((IStorage)element).getFullPath());
        }
        return super.select(viewer, parent, element);
    }
}

