/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.completions.externaltype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.springsource.ide.eclipse.commons.completions.CompletionsActivator;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalType;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeCompletionProposal;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeIndexManager;
import org.springsource.ide.eclipse.commons.completions.externaltype.indexing.ExternalTypeIndexer;
import org.springsource.ide.eclipse.commons.completions.util.Requestor;

public class ExternalTypesProposalComputer
implements IJavaCompletionProposalComputer {
    private static final boolean DEBUG = false;
    private static final List<IContextInformation> NO_CONTEXTS = Arrays.asList(new IContextInformation[0]);
    private static final List<ICompletionProposal> NO_PROPOSALS = Arrays.asList(new ICompletionProposal[0]);

    private void debug(String string) {
    }

    public void sessionStarted() {
        this.debug("sessionStarted");
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
        this.debug("sessionEnded");
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext _context, IProgressMonitor monitor) {
        if (_context instanceof JavaContentAssistInvocationContext) {
            final JavaContentAssistInvocationContext context = (JavaContentAssistInvocationContext)_context;
            try {
                final String idPrefix = context.computeIdentifierPrefix().toString();
                if (idPrefix != null && !"".equals(idPrefix)) {
                    final ArrayList<ICompletionProposal> completions = new ArrayList<ICompletionProposal>();
                    final ExternalTypeIndexer index = ExternalTypeIndexManager.indexFor(context.getProject());
                    index.getByPrefix(idPrefix, new Requestor<ExternalType>(){

                        @Override
                        public boolean receive(ExternalType type) {
                            try {
                                IJavaProject project;
                                if (type.getName().startsWith(idPrefix) && (project = context.getProject()).findType(type.getFullyQualifiedName()) == null) {
                                    CompletionProposal proposal = CompletionProposal.create((int)9, (int)context.getInvocationOffset());
                                    proposal.setCompletion(type.getFullyQualifiedName().toCharArray());
                                    proposal.setDeclarationSignature(type.getPackage().toCharArray());
                                    proposal.setFlags(1);
                                    proposal.setReplaceRange(context.getInvocationOffset() - idPrefix.length(), context.getInvocationOffset());
                                    proposal.setSignature(Signature.createTypeSignature((String)type.getFullyQualifiedName(), (boolean)true).toCharArray());
                                    completions.add(new ExternalTypeCompletionProposal(proposal, context, type, index));
                                }
                            }
                            catch (Exception e) {
                                CompletionsActivator.log(e);
                            }
                            return true;
                        }
                    });
                    return completions;
                }
            }
            catch (Exception e) {
                CompletionsActivator.log(e);
            }
        }
        return NO_PROPOSALS;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return NO_CONTEXTS;
    }
}

