/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.completions.externaltype;

public class ExternalType
implements Comparable<ExternalType> {
    private String name;
    private String packageName;

    public ExternalType(String name, String pkg) {
        this.name = name;
        this.packageName = pkg;
    }

    public ExternalType(String fqName) {
        int split = fqName.lastIndexOf(46);
        if (split <= 0) {
            throw new IllegalArgumentException("Invalid fqName: " + fqName);
        }
        this.name = fqName.substring(split + 1);
        this.packageName = fqName.substring(0, split);
    }

    public String toString() {
        return String.valueOf(this.name) + " in " + this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getFullyQualifiedName() {
        return String.valueOf(this.packageName) + "." + this.name;
    }

    @Override
    public int compareTo(ExternalType o) {
        int comp = this.name.compareTo(o.name);
        if (comp == 0) {
            comp = this.packageName.compareTo(o.packageName);
        }
        return comp;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalType other = (ExternalType)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
    }
}

