/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import java.io.IOException;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshHost;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSession;

public class SshConnection {
    private Connection myConnection;
    private volatile int mySessionCount;
    private SshHost myHost;
    private long myLastAccessTime;

    public SshConnection(SshHost host, Connection connection) {
        this.myHost = host;
        this.myConnection = connection;
        this.myLastAccessTime = System.currentTimeMillis();
    }

    public SshSession openSession() throws IOException {
        Session session = this.myConnection.openSession();
        if (session != null) {
            ++this.mySessionCount;
            return new SshSession(this, session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(SshSession sshSession) {
        this.myHost.lock();
        try {
            this.myLastAccessTime = System.currentTimeMillis();
            --this.mySessionCount;
            Object var3_2 = null;
            this.myHost.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.myHost.unlock();
            throw throwable;
        }
    }

    public int getSessionsCount() {
        return this.mySessionCount;
    }

    public void close() {
        this.myConnection.close();
        this.mySessionCount = 0;
    }

    public long lastAcccessTime() {
        return this.myLastAccessTime;
    }
}

