/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.autowire.internal.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.IInjectionMetadataProviderProblemReporter;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.PassThroughProblemReporter;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifierAnnotationAutowireCandidateResolver
implements AutowireCandidateResolver {
    private final Set<Class<? extends Annotation>> qualifierTypes = new LinkedHashSet<Class<? extends Annotation>>();
    private IInjectionMetadataProviderProblemReporter problemReporter = new PassThroughProblemReporter();
    private Class<? extends Annotation> valueAnnotationType;

    public QualifierAnnotationAutowireCandidateResolver(ClassLoader cl) {
        try {
            this.qualifierTypes.add(cl.loadClass(Qualifier.class.getName()));
            this.qualifierTypes.add(cl.loadClass("javax.inject.Qualifier"));
            this.valueAnnotationType = cl.loadClass(Value.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public void setProblemReporter(IInjectionMetadataProviderProblemReporter problemReporter) {
        this.problemReporter = problemReporter;
    }

    public void addQualifierType(Class<? extends Annotation> qualifierType) {
        this.qualifierTypes.add(qualifierType);
    }

    public boolean isAutowireCandidate(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor) {
        Method method;
        MethodParameter methodParam;
        if (!bdHolder.getBeanDefinition().isAutowireCandidate()) {
            return false;
        }
        if (descriptor == null) {
            return true;
        }
        boolean match = this.checkQualifiers(bdHolder, descriptor.getAnnotations());
        if (match && (methodParam = descriptor.getMethodParameter()) != null && ((method = methodParam.getMethod()) == null || Void.TYPE.equals(method.getReturnType()))) {
            match = this.checkQualifiers(bdHolder, methodParam.getMethodAnnotations());
        }
        return match;
    }

    protected boolean checkQualifiers(BeanDefinitionHolder bdHolder, Annotation[] annotationsToSearch) {
        if (ObjectUtils.isEmpty((Object[])annotationsToSearch)) {
            return true;
        }
        SimpleTypeConverter typeConverter = new SimpleTypeConverter();
        Annotation[] annotationArray = annotationsToSearch;
        int n = annotationsToSearch.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            Class<? extends Annotation> type = annotation.annotationType();
            if (this.isQualifier(type) && !this.checkQualifier(bdHolder, annotation, (TypeConverter)typeConverter)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isQualifier(Class<? extends Annotation> annotationType) {
        for (Class<? extends Annotation> qualifierType : this.qualifierTypes) {
            if (!annotationType.equals(qualifierType) && !annotationType.isAnnotationPresent(qualifierType)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkQualifier(BeanDefinitionHolder bdHolder, Annotation annotation, TypeConverter typeConverter) {
        Map attributes;
        Class<? extends Annotation> type = annotation.annotationType();
        AbstractBeanDefinition bd = (AbstractBeanDefinition)bdHolder.getBeanDefinition();
        AutowireCandidateQualifier qualifier = bd.getQualifier(type.getName());
        if (qualifier == null) {
            qualifier = bd.getQualifier(ClassUtils.getShortName(type));
        }
        if (qualifier == null) {
            Annotation targetAnnotation = null;
            if (targetAnnotation == null) {
                Class beanType = null;
                if (bd.getBeanClassName() != null) {
                    try {
                        beanType = org.springframework.ide.eclipse.core.java.ClassUtils.loadClass((String)bd.getBeanClassName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                if (beanType != null) {
                    targetAnnotation = ClassUtils.getUserClass(beanType).getAnnotation(type);
                }
            }
            if (targetAnnotation != null && targetAnnotation.equals(annotation)) {
                return true;
            }
        }
        if ((attributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation)).isEmpty() && qualifier == null) {
            return false;
        }
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            Object expectedValue = entry.getValue();
            Object actualValue = null;
            if (qualifier != null) {
                actualValue = qualifier.getAttribute(attributeName);
            }
            if (actualValue == null) {
                actualValue = bd.getAttribute(attributeName);
            }
            if (actualValue == null && attributeName.equals(AutowireCandidateQualifier.VALUE_KEY) && expectedValue instanceof String && bdHolder.matchesName((String)expectedValue)) continue;
            if (actualValue == null && qualifier != null) {
                actualValue = AnnotationUtils.getDefaultValue((Annotation)annotation, (String)attributeName);
            }
            if (actualValue != null) {
                actualValue = typeConverter.convertIfNecessary(actualValue, expectedValue.getClass());
            }
            if (expectedValue.equals(actualValue)) continue;
            return false;
        }
        return true;
    }

    public Object getSuggestedValue(DependencyDescriptor descriptor) {
        MethodParameter methodParam;
        Object value = this.findValue(descriptor.getAnnotations(), descriptor);
        if (value == null && (methodParam = descriptor.getMethodParameter()) != null) {
            value = this.findValue(methodParam.getMethodAnnotations(), descriptor);
        }
        return value;
    }

    protected Object findValue(Annotation[] annotationsToSearch, DependencyDescriptor descriptor) {
        Annotation[] annotationArray = annotationsToSearch;
        int n = annotationsToSearch.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (this.valueAnnotationType.isInstance(annotation)) {
                Object value = AnnotationUtils.getValue((Annotation)annotation);
                if (value == null) {
                    this.problemReporter.error("Value annotation must have a value attribute", descriptor, new ValidationProblemAttribute[0]);
                    return null;
                }
                return value;
            }
            ++n2;
        }
        return null;
    }

    public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, String beanName) {
        return null;
    }
}

