/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.autowire.internal.provider;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.ide.eclipse.beans.core.autowire.AutowireBeanReference;
import org.springframework.ide.eclipse.beans.core.autowire.IAutowireDependencyResolver;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanReference;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionMetadata {
    private final Set<InjectedElement> injectedFields = new LinkedHashSet<InjectedElement>();
    private final Set<InjectedElement> injectedMethods = new LinkedHashSet<InjectedElement>();
    private final Set<InjectedElement> injectedConstructors = new LinkedHashSet<InjectedElement>();

    public void addInjectedField(InjectedElement element) {
        this.injectedFields.add(element);
    }

    public void addInjectedMethod(InjectedElement element) {
        this.injectedMethods.add(element);
    }

    public void addInjectedConstructor(InjectedElement element) {
        this.injectedConstructors.add(element);
    }

    public Set<InjectedElement> getInjectedFields() {
        return this.injectedFields;
    }

    public Set<InjectedElement> getInjectedMethods() {
        return this.injectedMethods;
    }

    public Set<InjectedElement> getInjectedConstructors() {
        return this.injectedConstructors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class InjectedElement {
        protected final Member member;
        protected final boolean isField;
        protected final PropertyDescriptor pd;
        protected volatile Boolean skip;

        protected InjectedElement(Member member, PropertyDescriptor pd) {
            this.member = member;
            this.isField = member instanceof Field;
            this.pd = pd;
        }

        public final Member getMember() {
            return this.member;
        }

        protected final Class<?> getResourceType() {
            if (this.isField) {
                return ((Field)this.member).getType();
            }
            if (this.pd != null) {
                return this.pd.getPropertyType();
            }
            return ((Method)this.member).getParameterTypes()[0];
        }

        protected final void checkResourceType(Class<?> resourceType) {
            if (this.isField) {
                Class<?> fieldType = ((Field)this.member).getType();
                if (!resourceType.isAssignableFrom(fieldType) && !fieldType.isAssignableFrom(resourceType)) {
                    throw new IllegalStateException("Specified field type [" + fieldType + "] is incompatible with resource type [" + resourceType.getName() + "]");
                }
            } else {
                Class<?> paramType;
                Class<?> clazz = paramType = this.pd != null ? this.pd.getPropertyType() : ((Method)this.member).getParameterTypes()[0];
                if (!resourceType.isAssignableFrom(paramType) && !paramType.isAssignableFrom(resourceType)) {
                    throw new IllegalStateException("Specified parameter type [" + paramType + "] is incompatible with resource type [" + resourceType.getName() + "]");
                }
            }
        }

        protected abstract DependencyDescriptor[] getDependencyDescriptor(IAutowireDependencyResolver var1);

        public Set<IBeanReference> getBeanReferences(IBean bean, IBeansModelElement context, IAutowireDependencyResolver resolver) {
            HashSet<IBeanReference> autowiredReferences = new HashSet<IBeanReference>();
            BeanDefinition db = BeansModelUtils.getMergedBeanDefinition((IBean)bean, (IModelElement)context);
            if (!this.shouldSkip(db)) {
                DependencyDescriptor[] dependencyDescriptorArray = this.getDependencyDescriptor(resolver);
                int n = dependencyDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DependencyDescriptor dependencyDescriptor = dependencyDescriptorArray[n2];
                    HashSet<String> autowiredBeanNames = new HashSet<String>();
                    resolver.resolveDependency(dependencyDescriptor, dependencyDescriptor.getDependencyType(), bean.getElementName(), autowiredBeanNames, (TypeConverter)new SimpleTypeConverter());
                    for (String autowiredBeanName : autowiredBeanNames) {
                        AutowireBeanReference ref = new AutowireBeanReference((ISourceModelElement)bean, (BeanReference)new RuntimeBeanReference(autowiredBeanName));
                        if (dependencyDescriptor.getField() != null) {
                            ref.setSource(dependencyDescriptor.getField());
                        } else if (dependencyDescriptor.getMethodParameter() != null && dependencyDescriptor.getMethodParameter().getMethod() != null) {
                            ref.setSource(dependencyDescriptor.getMethodParameter().getMethod(), dependencyDescriptor.getMethodParameter().getParameterIndex());
                        } else if (dependencyDescriptor.getMethodParameter() != null && dependencyDescriptor.getMethodParameter().getConstructor() != null) {
                            ref.setSource(dependencyDescriptor.getMethodParameter().getConstructor(), dependencyDescriptor.getMethodParameter().getParameterIndex());
                        }
                        autowiredReferences.add((IBeanReference)ref);
                    }
                    ++n2;
                }
            }
            return autowiredReferences;
        }

        public boolean shouldSkip(BeanDefinition bd) {
            return false;
        }

        protected boolean checkPropertySkipping(PropertyValues pvs) {
            return this.pd != null && pvs != null && pvs.contains(this.pd.getName());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InjectedElement)) {
                return false;
            }
            InjectedElement otherElement = (InjectedElement)other;
            return this.member.equals(otherElement.member);
        }

        public int hashCode() {
            return this.member.getClass().hashCode() * 29 + this.member.getName().hashCode();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " for " + this.member;
        }
    }
}

