/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.rest;

import com.atlassian.connector.commons.misc.IntRanges;
import com.atlassian.connector.commons.misc.IntRangesParser;
import com.atlassian.theplugin.commons.VersionedVirtualFile;
import com.atlassian.theplugin.commons.crucible.CrucibleVersion;
import com.atlassian.theplugin.commons.crucible.api.JDomHelper;
import com.atlassian.theplugin.commons.crucible.api.PathAndRevision;
import com.atlassian.theplugin.commons.crucible.api.model.BasicProject;
import com.atlassian.theplugin.commons.crucible.api.model.BasicReview;
import com.atlassian.theplugin.commons.crucible.api.model.Comment;
import com.atlassian.theplugin.commons.crucible.api.model.CommitType;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleAction;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleFileInfo;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleVersionInfo;
import com.atlassian.theplugin.commons.crucible.api.model.CustomField;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFieldBean;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFieldDefBean;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFieldValue;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFieldValueType;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFilter;
import com.atlassian.theplugin.commons.crucible.api.model.ExtendedCrucibleProject;
import com.atlassian.theplugin.commons.crucible.api.model.FileType;
import com.atlassian.theplugin.commons.crucible.api.model.GeneralComment;
import com.atlassian.theplugin.commons.crucible.api.model.NewReviewItem;
import com.atlassian.theplugin.commons.crucible.api.model.PatchAnchorData;
import com.atlassian.theplugin.commons.crucible.api.model.PermId;
import com.atlassian.theplugin.commons.crucible.api.model.Repository;
import com.atlassian.theplugin.commons.crucible.api.model.RepositoryType;
import com.atlassian.theplugin.commons.crucible.api.model.Review;
import com.atlassian.theplugin.commons.crucible.api.model.ReviewType;
import com.atlassian.theplugin.commons.crucible.api.model.Reviewer;
import com.atlassian.theplugin.commons.crucible.api.model.RevisionData;
import com.atlassian.theplugin.commons.crucible.api.model.State;
import com.atlassian.theplugin.commons.crucible.api.model.SvnRepository;
import com.atlassian.theplugin.commons.crucible.api.model.User;
import com.atlassian.theplugin.commons.crucible.api.model.VersionedComment;
import com.atlassian.theplugin.commons.crucible.api.model.changes.Change;
import com.atlassian.theplugin.commons.crucible.api.model.changes.Changes;
import com.atlassian.theplugin.commons.crucible.api.model.changes.Link;
import com.atlassian.theplugin.commons.crucible.api.model.changes.Revision;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.util.LoggerImpl;
import com.atlassian.theplugin.commons.util.MiscUtil;
import com.atlassian.theplugin.commons.util.XmlUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CrucibleRestXmlHelper {
    private static final String CDATA_END = "]]>";
    private static final String PRESERVE_OLD = "{preserve-old}";
    private static final DateTimeFormatter COMMENT_TIME_FORMAT_BASE = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final DateTimeFormatter[] COMMENT_TIME_FORMATS = new DateTimeFormatter[]{COMMENT_TIME_FORMAT_BASE, DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS"), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'"), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss")};

    private CrucibleRestXmlHelper() {
    }

    @NotNull
    public static String getChildText(Element node, String childName) {
        Element child = node.getChild(childName);
        if (child != null) {
            return child.getText();
        }
        return "";
    }

    @Nullable
    public static String getChildTextOrNull(Element node, String childName) {
        Element child = node.getChild(childName);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public static BasicProject parseBasicProjectNode(Element projectNode) {
        String defaultDuration = CrucibleRestXmlHelper.getChildText(projectNode, "defaultDuration");
        return new BasicProject(CrucibleRestXmlHelper.getChildText(projectNode, "id"), CrucibleRestXmlHelper.getChildText(projectNode, "key"), CrucibleRestXmlHelper.getChildText(projectNode, "name"), CrucibleRestXmlHelper.parseUserNames(projectNode.getChild("defaultReviewers")), CrucibleRestXmlHelper.getChildText(projectNode, "defaultRepositoryName"), Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(projectNode, "allowReviewersToJoin")), !StringUtils.isEmpty((String)defaultDuration) ? Integer.valueOf(Integer.parseInt(defaultDuration)) : null, Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(projectNode, "moderatorEnabled")));
    }

    public static ExtendedCrucibleProject parseProjectNode(Element projectNode) {
        String defaultDuration = CrucibleRestXmlHelper.getChildText(projectNode, "defaultDuration");
        return new ExtendedCrucibleProject(CrucibleRestXmlHelper.getChildText(projectNode, "id"), CrucibleRestXmlHelper.getChildText(projectNode, "key"), CrucibleRestXmlHelper.getChildText(projectNode, "name"), CrucibleRestXmlHelper.parseUserNames(projectNode.getChild("allowedReviewers")), CrucibleRestXmlHelper.parseUserNames(projectNode.getChild("defaultReviewers")), CrucibleRestXmlHelper.getChildText(projectNode, "defaultRepositoryName"), Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(projectNode, "allowReviewersToJoin")), !StringUtils.isEmpty((String)defaultDuration) ? Integer.valueOf(Integer.parseInt(defaultDuration)) : null, Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(projectNode, "moderatorEnabled")));
    }

    public static Repository parseRepositoryNode(Element repoNode) {
        return new Repository(CrucibleRestXmlHelper.getChildText(repoNode, "name"), CrucibleRestXmlHelper.getChildText(repoNode, "type"), Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(repoNode, "enabled")));
    }

    public static SvnRepository parseSvnRepositoryNode(Element repoNode) {
        return new SvnRepository(CrucibleRestXmlHelper.getChildText(repoNode, "name"), CrucibleRestXmlHelper.getChildText(repoNode, "type"), Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(repoNode, "enabled")), CrucibleRestXmlHelper.getChildText(repoNode, "url"), CrucibleRestXmlHelper.getChildText(repoNode, "path"));
    }

    public static User parseUserNode(Element repoNode) {
        CrucibleVersion version = CrucibleVersion.CRUCIBLE_15;
        Element userName = repoNode.getChild("userName");
        if (userName != null && !"".equals(userName.getText())) {
            version = CrucibleVersion.CRUCIBLE_16;
        }
        if (version == CrucibleVersion.CRUCIBLE_15) {
            return new User(repoNode.getText(), repoNode.getText());
        }
        return new User(CrucibleRestXmlHelper.getChildText(repoNode, "userName"), CrucibleRestXmlHelper.getChildText(repoNode, "displayName"), CrucibleRestXmlHelper.getChildText(repoNode, "avatarUrl"));
    }

    @NotNull
    public static CrucibleAction parseActionNode(Element element) throws ParseException {
        String name = element.getChildText("name");
        if (name == null) {
            throw new ParseException("Cannot parse action node - missing [name] element", 0);
        }
        try {
            return CrucibleAction.fromValue(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String displayName = element.getChildText("displayName");
            if (displayName != null) {
                return new CrucibleAction(displayName, name);
            }
            throw new ParseException("Cannot parse action node " + XmlUtil.toPrettyFormatedString(element), 0);
        }
    }

    public static Reviewer parseReviewerNode(Element reviewerNode) {
        CrucibleVersion version = CrucibleVersion.CRUCIBLE_15;
        Element userName = reviewerNode.getChild("userName");
        if (userName != null && !userName.getText().equals("")) {
            version = CrucibleVersion.CRUCIBLE_16;
        }
        if (version == CrucibleVersion.CRUCIBLE_15) {
            return new Reviewer(reviewerNode.getText(), reviewerNode.getText());
        }
        return new Reviewer(CrucibleRestXmlHelper.getChildText(reviewerNode, "userName"), CrucibleRestXmlHelper.getChildText(reviewerNode, "displayName"), Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(reviewerNode, "completed")), CrucibleRestXmlHelper.getChildText(reviewerNode, "avatarUrl"));
    }

    @Nullable
    private static Collection<String> parseUserNames(Element userNamesNode) {
        if (userNamesNode != null) {
            ArrayList<String> userNamesList = new ArrayList<String>();
            for (Element userName : XmlUtil.getChildElements(userNamesNode, "userName")) {
                userNamesList.add(userName.getText());
            }
            return userNamesList;
        }
        return null;
    }

    public static BasicReview parseBasicReview(String serverUrl, Element reviewNode, boolean trimWikiMarkers) throws ParseException {
        String projectKey = CrucibleRestXmlHelper.getChildText(reviewNode, "projectKey");
        User author = CrucibleRestXmlHelper.parseUserNode(reviewNode.getChild("author"));
        User creator = CrucibleRestXmlHelper.parseUserNode(reviewNode.getChild("creator"));
        ReviewType reviewType = CrucibleRestXmlHelper.parseReviewType(reviewNode.getChildText("type"));
        User moderator = reviewNode.getChild("moderator") != null ? CrucibleRestXmlHelper.parseUserNode(reviewNode.getChild("moderator")) : null;
        BasicReview review = new BasicReview(reviewType, serverUrl, projectKey, author, moderator);
        review.setCreator(creator);
        CrucibleRestXmlHelper.fillAlwaysPresentReviewData(review, reviewNode, serverUrl, trimWikiMarkers);
        CrucibleRestXmlHelper.fillMoreDetailedReviewData(review, reviewNode, trimWikiMarkers);
        return review;
    }

    public static Review parseFullReview(String serverUrl, String myUsername, Element reviewNode, boolean trimWikiMarkers) throws ParseException {
        String projectKey = CrucibleRestXmlHelper.getChildText(reviewNode, "projectKey");
        User author = CrucibleRestXmlHelper.parseUserNode(reviewNode.getChild("author"));
        User moderator = reviewNode.getChild("moderator") != null ? CrucibleRestXmlHelper.parseUserNode(reviewNode.getChild("moderator")) : null;
        User creator = reviewNode.getChild("creator") != null ? CrucibleRestXmlHelper.parseUserNode(reviewNode.getChild("creator")) : null;
        ReviewType reviewType = CrucibleRestXmlHelper.parseReviewType(reviewNode.getChildText("type"));
        Review review = new Review(reviewType, serverUrl, projectKey, author, moderator);
        review.setCreator(creator);
        CrucibleRestXmlHelper.fillAlwaysPresentReviewData(review, reviewNode, serverUrl, trimWikiMarkers);
        CrucibleRestXmlHelper.fillMoreDetailedReviewData(review, reviewNode, trimWikiMarkers);
        List<Element> generalCommentsNode = XmlUtil.getChildElements(reviewNode, "generalComments");
        for (Element generalComment : generalCommentsNode) {
            List<Element> generalCommentsDataNode = XmlUtil.getChildElements(generalComment, "generalCommentData");
            ArrayList generalComments = new ArrayList();
            for (Element generalCommentData : generalCommentsDataNode) {
                GeneralComment c = CrucibleRestXmlHelper.parseGeneralCommentNode(review, null, myUsername, generalCommentData, trimWikiMarkers);
                if (c == null) continue;
                generalComments.add(c);
            }
            review.setGeneralComments(generalComments);
        }
        List<Element> fileNode = XmlUtil.getChildElements(reviewNode, "reviewItems");
        LinkedHashMap<PermId, CrucibleFileInfo> files = new LinkedHashMap<PermId, CrucibleFileInfo>();
        if (fileNode.size() > 0) {
            for (Element element : fileNode) {
                List<Element> fileElements = XmlUtil.getChildElements(element, "reviewItem");
                for (Element file : fileElements) {
                    CrucibleFileInfo fileInfo = CrucibleRestXmlHelper.parseReviewItemNode(file);
                    files.put(fileInfo.getPermId(), fileInfo);
                }
            }
        }
        List<Element> versionedComments = XmlUtil.getChildElements(reviewNode, "versionedComments");
        ArrayList<VersionedComment> comments = new ArrayList<VersionedComment>();
        for (Element element : versionedComments) {
            List<Element> versionedCommentsData = XmlUtil.getChildElements(element, "versionedLineCommentData");
            for (Element versionedElementData : versionedCommentsData) {
                VersionedComment c = CrucibleRestXmlHelper.parseVersionedCommentNode(review, files, myUsername, versionedElementData, trimWikiMarkers);
                if (c == null) continue;
                comments.add(c);
            }
        }
        review.setFilesAndVersionedComments(files.values(), comments);
        return review;
    }

    private static void fillAlwaysPresentReviewData(BasicReview review, Element reviewNode, String serverUrl, boolean trimWikiMarkers) throws ParseException {
        review.setCreateDate(CrucibleRestXmlHelper.parseDateTime(CrucibleRestXmlHelper.getChildText(reviewNode, "createDate")));
        review.setCloseDate(CrucibleRestXmlHelper.parseDateTime(CrucibleRestXmlHelper.getChildText(reviewNode, "closeDate")));
        String soo = CrucibleRestXmlHelper.getChildText(reviewNode, "description");
        if (trimWikiMarkers) {
            soo = CrucibleRestXmlHelper.removeWikiMarkers(soo);
        }
        review.setDescription(soo);
        review.setName(CrucibleRestXmlHelper.getChildText(reviewNode, "name"));
        review.setRepoName(CrucibleRestXmlHelper.getChildText(reviewNode, "repoName"));
        String stateString = CrucibleRestXmlHelper.getChildText(reviewNode, "state");
        if (!"".equals(stateString)) {
            review.setState(State.fromValue(stateString));
        }
        review.setAllowReviewerToJoin(Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(reviewNode, "allowReviewersToJoin")));
        String dueDateStr = CrucibleRestXmlHelper.getChildTextOrNull(reviewNode, "dueDate");
        if (dueDateStr != null) {
            review.setDueDate(CrucibleRestXmlHelper.parseJodaDateTime(dueDateStr));
        }
        if (reviewNode.getChild("permaId") != null) {
            PermId permId = new PermId(reviewNode.getChild("permaId").getChild("id").getText());
            review.setPermId(permId);
        }
        review.setSummary(CrucibleRestXmlHelper.getChildText(reviewNode, "summary"));
        try {
            review.setMetricsVersion(Integer.valueOf(CrucibleRestXmlHelper.getChildText(reviewNode, "metricsVersion")));
        }
        catch (NumberFormatException numberFormatException) {
            review.setMetricsVersion(-1);
        }
    }

    public static List<CrucibleAction> parseActions(List<Element> elements) {
        ArrayList<CrucibleAction> res = new ArrayList<CrucibleAction>();
        if (elements != null && !elements.isEmpty()) {
            for (Element element : elements) {
                try {
                    res.add(CrucibleRestXmlHelper.parseActionNode(element));
                }
                catch (ParseException e) {
                    LoggerImpl.getInstance().warn(e);
                }
            }
        }
        return res;
    }

    private static void fillMoreDetailedReviewData(BasicReview review, Element reviewNode, boolean trimWikiMarkers) {
        List<Element> reviewersNode = XmlUtil.getChildElements(reviewNode, "reviewers");
        HashSet<Reviewer> reviewers = new HashSet<Reviewer>();
        for (Element reviewer : reviewersNode) {
            List<Element> reviewerNode = XmlUtil.getChildElements(reviewer, "reviewer");
            for (Element element : reviewerNode) {
                reviewers.add(CrucibleRestXmlHelper.parseReviewerNode(element));
            }
        }
        review.setReviewers(reviewers);
        ArrayList<CrucibleAction> transitions = new ArrayList<CrucibleAction>();
        Element transitionsNode = reviewNode.getChild("transitions");
        if (transitionsNode != null) {
            List<Element> transDataNodes = XmlUtil.getChildElements(transitionsNode, "transitionData");
            transitions.addAll(CrucibleRestXmlHelper.parseActions(transDataNodes));
        }
        review.setTransitions(transitions);
        HashSet<CrucibleAction> actions = new HashSet<CrucibleAction>();
        Element actionsNode = reviewNode.getChild("actions");
        if (actionsNode != null) {
            List<Element> actionDataNodes = XmlUtil.getChildElements(actionsNode, "actionData");
            actions.addAll(CrucibleRestXmlHelper.parseActions(actionDataNodes));
        }
        review.setActions(actions);
    }

    public static Element addTag(Element root, String tagName, String tagValue) {
        Element newElement = new Element(tagName);
        newElement.addContent(tagValue);
        JDomHelper.getContent(root).add(newElement);
        return newElement;
    }

    private static String escapeForCdata(String source) {
        int index;
        if (source == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int oldIndex = 0;
        while ((index = source.indexOf(CDATA_END, oldIndex)) > -1) {
            sb.append(source.substring(oldIndex, index));
            oldIndex = index + CDATA_END.length();
            sb.append("&#x5D;&#x5D;>");
        }
        sb.append(source.substring(oldIndex));
        return sb.toString();
    }

    public static Document prepareCreateReviewNode(Review review, String patch) {
        Element root = new Element("createReview");
        Document doc = new Document(root);
        JDomHelper.getContent(root).add(CrucibleRestXmlHelper.prepareReviewNodeElement(review, true));
        if (patch != null) {
            Element patchData = new Element("patch");
            JDomHelper.getContent(root).add(patchData);
            CDATA patchT = new CDATA(CrucibleRestXmlHelper.escapeForCdata(patch));
            patchData.setContent((Content)patchT);
        }
        return doc;
    }

    public static Document prepareCreateSnippetReviewNode(Review review, String snippet, String filename) {
        Element root = new Element("createReview");
        Document doc = new Document(root);
        JDomHelper.getContent(root).add(CrucibleRestXmlHelper.prepareSnippetReviewNodeElement(review));
        Element patchData = new Element("snippet");
        JDomHelper.getContent(root).add(patchData);
        CDATA patchT = new CDATA(CrucibleRestXmlHelper.escapeForCdata(snippet));
        patchData.setContent((Content)patchT);
        Element filenameT = new Element("filename");
        JDomHelper.getContent(root).add(filenameT);
        filenameT.setText(filename);
        return doc;
    }

    public static Document prepareCloseReviewSummaryNode(String message) {
        Element root = new Element("closeReviewSummary");
        Document doc = new Document(root);
        if (message != null) {
            Element messageData = new Element("summary");
            JDomHelper.getContent(root).add(messageData);
            CDATA patchT = new CDATA(CrucibleRestXmlHelper.escapeForCdata(message));
            messageData.setContent((Content)patchT);
        }
        return doc;
    }

    public static Document prepareCreateReviewNode(Review review, List<String> revisions) {
        Element root = new Element("createReview");
        Document doc = new Document(root);
        JDomHelper.getContent(root).add(CrucibleRestXmlHelper.prepareReviewNodeElement(review, false));
        if (!revisions.isEmpty()) {
            Element changes = new Element("changesets");
            CrucibleRestXmlHelper.addTag(changes, "repository", review.getRepoName());
            JDomHelper.getContent(root).add(changes);
            for (String revision : revisions) {
                Element rev = new Element("changesetData");
                JDomHelper.getContent(changes).add(rev);
                CrucibleRestXmlHelper.addTag(rev, "id", revision);
            }
        }
        return doc;
    }

    public static Element prepareRevisionData(RevisionData revData) {
        Element root = new Element("revisionData");
        Element source = new Element("source");
        source.addContent(revData.getSource());
        JDomHelper.getContent(root).add(source);
        Element path = new Element("path");
        path.addContent(revData.getPath());
        JDomHelper.getContent(root).add(path);
        for (String revision : revData.getRevisions()) {
            Element rev = new Element("rev");
            rev.addContent(revision);
            JDomHelper.getContent(root).add(rev);
        }
        return root;
    }

    public static Document prepareRevisions(Collection<RevisionData> revisions) {
        Element root = new Element("revisions");
        Document doc = new Document(root);
        if (!revisions.isEmpty()) {
            for (RevisionData revData : revisions) {
                JDomHelper.getContent(root).add(CrucibleRestXmlHelper.prepareRevisionData(revData));
            }
        }
        return doc;
    }

    public static Document prepareRevisionDataNode(String repository, List<PathAndRevision> files) {
        Element root = new Element("revisions");
        Document doc = new Document(root);
        for (PathAndRevision file : files) {
            Element revData = new Element("revisionData");
            for (String revision : file.getRevisions()) {
                CrucibleRestXmlHelper.addTag(revData, "rev", revision);
            }
            CrucibleRestXmlHelper.addTag(revData, "source", repository);
            CrucibleRestXmlHelper.addTag(revData, "path", file.getPath());
            JDomHelper.getContent(root).add(revData);
        }
        CrucibleRestXmlHelper.addTag(root, "repository", repository);
        return doc;
    }

    public static Document prepareAddChangesetNode(String repoName, Collection<String> revisions) {
        Element root = new Element("addChangeset");
        Document doc = new Document(root);
        CrucibleRestXmlHelper.addTag(root, "repository", repoName);
        if (!revisions.isEmpty()) {
            Element changes = new Element("changesets");
            JDomHelper.getContent(root).add(changes);
            for (String revision : revisions) {
                Element rev = new Element("changesetData");
                JDomHelper.getContent(changes).add(rev);
                CrucibleRestXmlHelper.addTag(rev, "id", revision);
            }
        }
        return doc;
    }

    public static Document prepareAddPatchNode(String repoName, String patch) {
        Element root = new Element("addPatch");
        Document doc = new Document(root);
        CrucibleRestXmlHelper.addTag(root, "repository", repoName);
        if (patch != null) {
            Element patchData = new Element("patch");
            JDomHelper.getContent(root).add(patchData);
            CDATA patchT = new CDATA(CrucibleRestXmlHelper.escapeForCdata(patch));
            patchData.setContent((Content)patchT);
        }
        return doc;
    }

    public static Document prepareAddItemNode(NewReviewItem item) {
        Element root = new Element("reviewItem");
        Document doc = new Document(root);
        CrucibleRestXmlHelper.addTag(root, "repositoryName", item.getRepositoryName());
        CrucibleRestXmlHelper.addTag(root, "fromPath", item.getFromPath());
        CrucibleRestXmlHelper.addTag(root, "fromRevision", item.getFromRevision());
        CrucibleRestXmlHelper.addTag(root, "toPath", item.getToPath());
        CrucibleRestXmlHelper.addTag(root, "toRevision", item.getToRevision());
        return doc;
    }

    public static Document prepareReviewNode(BasicReview review) {
        Element reviewData = CrucibleRestXmlHelper.prepareReviewNodeElement(review, false);
        return new Document(reviewData);
    }

    private static Element prepareReviewNodeElement(BasicReview review, boolean addType) {
        Element reviewData = new Element("reviewData");
        Element authorElement = new Element("author");
        JDomHelper.getContent(reviewData).add(authorElement);
        CrucibleRestXmlHelper.addTag(authorElement, "userName", review.getAuthor().getUsername());
        Element creatorElement = new Element("creator");
        JDomHelper.getContent(reviewData).add(creatorElement);
        CrucibleRestXmlHelper.addTag(creatorElement, "userName", review.getCreator().getUsername());
        Element moderatorElement = new Element("moderator");
        JDomHelper.getContent(reviewData).add(moderatorElement);
        CrucibleRestXmlHelper.addTag(moderatorElement, "userName", review.getModerator().getUsername());
        CrucibleRestXmlHelper.addTag(reviewData, "description", review.getDescription());
        CrucibleRestXmlHelper.addTag(reviewData, "name", review.getName());
        CrucibleRestXmlHelper.addTag(reviewData, "projectKey", review.getProjectKey());
        if (review.getState() != null) {
            CrucibleRestXmlHelper.addTag(reviewData, "state", review.getState().value());
        }
        CrucibleRestXmlHelper.addTag(reviewData, "allowReviewersToJoin", Boolean.toString(review.isAllowReviewerToJoin()));
        if (review.getPermId() != null) {
            Element permIdElement = new Element("permaId");
            JDomHelper.getContent(reviewData).add(permIdElement);
            CrucibleRestXmlHelper.addTag(permIdElement, "id", review.getPermId().getId());
        }
        if (addType) {
            CrucibleRestXmlHelper.addTag(reviewData, "type", "REVIEW");
        }
        return reviewData;
    }

    private static Element prepareSnippetReviewNodeElement(BasicReview review) {
        Element reviewData = new Element("reviewData");
        Element authorElement = new Element("creator");
        JDomHelper.getContent(reviewData).add(authorElement);
        CrucibleRestXmlHelper.addTag(authorElement, "userName", review.getAuthor().getUsername());
        CrucibleRestXmlHelper.addTag(reviewData, "description", review.getDescription());
        CrucibleRestXmlHelper.addTag(reviewData, "name", review.getName());
        CrucibleRestXmlHelper.addTag(reviewData, "projectKey", review.getProjectKey());
        if (review.getState() != null) {
            CrucibleRestXmlHelper.addTag(reviewData, "state", review.getState().value());
        }
        if (review.getPermId() != null) {
            Element permIdElement = new Element("permaId");
            JDomHelper.getContent(reviewData).add(permIdElement);
            CrucibleRestXmlHelper.addTag(permIdElement, "id", review.getPermId().getId());
        }
        return reviewData;
    }

    private static PermId parsePermId(Element permIdNode) throws ParseException {
        if (permIdNode != null) {
            Element childId = permIdNode.getChild("id");
            if (childId != null && childId.getText() != null && childId.getText().length() > 0) {
                return new PermId(childId.getText());
            }
            if (permIdNode.getText() != null && permIdNode.getText().length() > 0) {
                return new PermId(permIdNode.getText());
            }
        }
        throw new ParseException("PermId not defined", 0);
    }

    public static CrucibleFileInfo parseReviewItemNode(Element reviewItemNode) throws ParseException {
        String c;
        String toContentUrl;
        CrucibleFileInfo reviewItem = new CrucibleFileInfo(new VersionedVirtualFile(CrucibleRestXmlHelper.getChildText(reviewItemNode, "toPath"), CrucibleRestXmlHelper.getChildText(reviewItemNode, "toRevision")), new VersionedVirtualFile(CrucibleRestXmlHelper.getChildText(reviewItemNode, "fromPath"), CrucibleRestXmlHelper.getChildText(reviewItemNode, "fromRevision")), CrucibleRestXmlHelper.parsePermId(reviewItemNode.getChild("permId")));
        String fromContentUrl = CrucibleRestXmlHelper.getChildText(reviewItemNode, "fromContentUrl");
        if (!"".equals(fromContentUrl)) {
            reviewItem.getOldFileDescriptor().setContentUrl(fromContentUrl);
        }
        if (!"".equals(toContentUrl = CrucibleRestXmlHelper.getChildText(reviewItemNode, "toContentUrl"))) {
            reviewItem.getFileDescriptor().setContentUrl(toContentUrl);
        }
        if (!"".equals(c = CrucibleRestXmlHelper.getChildText(reviewItemNode, "commitType"))) {
            reviewItem.setCommitType(CommitType.valueOf(c));
            if (reviewItem.getCommitType() == CommitType.Added && !"".equals(reviewItem.getOldFileDescriptor().getRevision()) && !"".equals(reviewItem.getFileDescriptor().getRevision())) {
                reviewItem.setCommitType(CommitType.Moved);
            }
        } else if (!"".equals(reviewItem.getOldFileDescriptor().getRevision()) && !"".equals(reviewItem.getFileDescriptor().getRevision())) {
            reviewItem.setCommitType(CommitType.Modified);
        } else if ("".equals(reviewItem.getOldFileDescriptor().getRevision()) && !"".equals(reviewItem.getFileDescriptor().getRevision())) {
            reviewItem.setCommitType(CommitType.Added);
        } else if ("".equals(reviewItem.getOldFileDescriptor().getRevision()) && !"".equals(reviewItem.getFileDescriptor().getRevision())) {
            reviewItem.setCommitType(CommitType.Deleted);
        } else {
            reviewItem.setCommitType(CommitType.Unknown);
        }
        reviewItem.setRepositoryName(CrucibleRestXmlHelper.getChildText(reviewItemNode, "repositoryName"));
        if (reviewItem.getRepositoryName().startsWith(RepositoryType.UPLOAD.name())) {
            reviewItem.setRepositoryType(RepositoryType.UPLOAD);
        } else if (reviewItem.getRepositoryName().startsWith(RepositoryType.PATCH.name())) {
            reviewItem.setRepositoryType(RepositoryType.PATCH);
        } else {
            reviewItem.setRepositoryType(RepositoryType.SCM);
        }
        reviewItem.setAuthorName(CrucibleRestXmlHelper.getChildText(reviewItemNode, "authorName"));
        reviewItem.setCommitDate(CrucibleRestXmlHelper.parseDateTime(CrucibleRestXmlHelper.getChildText(reviewItemNode, "commitDate")));
        String fileType = CrucibleRestXmlHelper.getChildText(reviewItemNode, "fileType");
        if (fileType != null && !"".equals(fileType)) {
            try {
                reviewItem.setFileType(FileType.valueOf(fileType));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                reviewItem.setFileType(FileType.Unknown);
            }
        }
        reviewItem.setFilePermId(CrucibleRestXmlHelper.parsePermId(reviewItemNode.getChild("permId")));
        return reviewItem;
    }

    private static boolean parseGeneralComment(Review review, String myUsername, GeneralComment commentBean, Element reviewCommentNode, boolean trimWikiMarkers) {
        if (!CrucibleRestXmlHelper.parseComment(myUsername, commentBean, reviewCommentNode, trimWikiMarkers)) {
            return false;
        }
        List<Element> replies = XmlUtil.getChildElements(reviewCommentNode, "replies");
        if (replies != null) {
            ArrayList<Comment> rep = new ArrayList<Comment>();
            for (Element repliesNode : replies) {
                List<Element> entries = XmlUtil.getChildElements(repliesNode, "generalCommentData");
                for (Element replyNode : entries) {
                    GeneralComment reply = CrucibleRestXmlHelper.parseGeneralCommentNode(review, commentBean, myUsername, replyNode, trimWikiMarkers);
                    if (reply == null) continue;
                    reply.setReply(true);
                    rep.add(reply);
                }
            }
            commentBean.setReplies(rep);
        }
        return true;
    }

    @Nullable
    private static VersionedComment parseVersionedComment(Review review, String myUsername, Element reviewCommentNode, boolean trimWikiMarkers, Map<PermId, CrucibleFileInfo> crucibleFileInfos) throws ParseException {
        Element reviewId;
        List<Element> ids;
        Iterator<Element> iterator;
        Comment commentBean = null;
        List<Element> reviewIds = XmlUtil.getChildElements(reviewCommentNode, "reviewItemId");
        Iterator<Element> iterator2 = reviewIds.iterator();
        if (iterator2.hasNext() && (iterator = (ids = XmlUtil.getChildElements(reviewId = iterator2.next(), "id")).iterator()).hasNext()) {
            Element id = iterator.next();
            PermId permId = new PermId(id.getText());
            CrucibleFileInfo crucibleFileInfo = crucibleFileInfos.get(permId);
            if (crucibleFileInfo == null) {
                throw new ParseException("Cannot find reviewItemId [" + permId + "] in the review description " + "while parsing comment [" + XmlUtil.toPrettyFormatedString(reviewCommentNode), 0);
            }
            commentBean = new VersionedComment(review, crucibleFileInfo);
            ((VersionedComment)commentBean).setReviewItemId(permId);
        }
        if (commentBean == null) {
            throw new ParseException("Cannot parse comment [" + XmlUtil.toPrettyFormatedString(reviewCommentNode) + "]: reviewItemId -> id not found", 0);
        }
        if (!CrucibleRestXmlHelper.parseComment(myUsername, commentBean, reviewCommentNode, trimWikiMarkers)) {
            return null;
        }
        List<Element> replies = XmlUtil.getChildElements(reviewCommentNode, "replies");
        if (replies != null) {
            ArrayList<Comment> rep = new ArrayList<Comment>();
            for (Element repliesNode : replies) {
                List<Element> entries = XmlUtil.getChildElements(repliesNode, "generalCommentData");
                for (Element replyNode : entries) {
                    GeneralComment reply = new GeneralComment(review, commentBean);
                    CrucibleRestXmlHelper.parseGeneralComment(review, myUsername, reply, replyNode, trimWikiMarkers);
                    if (reply == null) continue;
                    reply.setReply(true);
                    rep.add(reply);
                }
            }
            commentBean.setReplies(rep);
        }
        return commentBean;
    }

    private static boolean parseComment(String myUsername, Comment commentBean, Element reviewCommentNode, boolean trimWikiMarkers) {
        List<Element> metrics;
        boolean isDraft = Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(reviewCommentNode, "draft"));
        for (Element element : XmlUtil.getChildElements(reviewCommentNode, "user")) {
            User commentAuthor = CrucibleRestXmlHelper.parseUserNode(element);
            if (isDraft && !commentAuthor.getUsername().equals(myUsername)) {
                return false;
            }
            commentBean.setAuthor(commentAuthor);
        }
        commentBean.setDraft(isDraft);
        String message = CrucibleRestXmlHelper.getChildText(reviewCommentNode, "message");
        if (trimWikiMarkers) {
            message = CrucibleRestXmlHelper.removeWikiMarkers(message);
        }
        commentBean.setMessage(message);
        commentBean.setDefectRaised(Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(reviewCommentNode, "defectRaised")));
        commentBean.setDefectApproved(Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(reviewCommentNode, "defectApproved")));
        commentBean.setDeleted(Boolean.parseBoolean(CrucibleRestXmlHelper.getChildText(reviewCommentNode, "deleted")));
        commentBean.setCreateDate(CrucibleRestXmlHelper.parseDateTime(CrucibleRestXmlHelper.getChildText(reviewCommentNode, "createDate")));
        String readStatus = CrucibleRestXmlHelper.getChildText(reviewCommentNode, "readStatus");
        commentBean.setReadState(CrucibleRestXmlHelper.readStatusStringToState(readStatus));
        PermId permId = null;
        if (reviewCommentNode.getChild("permaId") != null) {
            permId = new PermId(reviewCommentNode.getChild("permaId").getChild("id").getText());
            commentBean.setPermId(permId);
        }
        if (commentBean.getPermId() == null) {
            permId = new PermId(CrucibleRestXmlHelper.getChildText(reviewCommentNode, "permaIdAsString"));
            commentBean.setPermId(permId);
        }
        if ((metrics = XmlUtil.getChildElements(reviewCommentNode, "metrics")) != null) {
            for (Element metric : metrics) {
                List<Element> entries = XmlUtil.getChildElements(metric, "entry");
                for (Element entry : entries) {
                    String key = CrucibleRestXmlHelper.getChildText(entry, "key");
                    List<Element> values = XmlUtil.getChildElements(entry, "value");
                    Iterator<Element> iterator = values.iterator();
                    if (!iterator.hasNext()) continue;
                    Element value = iterator.next();
                    CustomFieldBean field = new CustomFieldBean();
                    field.setConfigVersion(Integer.parseInt(CrucibleRestXmlHelper.getChildText(value, "configVersion")));
                    field.setValue(CrucibleRestXmlHelper.getChildText(value, "value"));
                    commentBean.getCustomFields().put(key, field);
                }
            }
        }
        return true;
    }

    private static String removeWikiMarkers(String message) {
        if (message.startsWith(PRESERVE_OLD)) {
            message = message.substring(PRESERVE_OLD.length());
        }
        if (message.endsWith(PRESERVE_OLD)) {
            message = message.substring(0, message.lastIndexOf(PRESERVE_OLD));
        }
        return message;
    }

    private static Comment.ReadState readStatusStringToState(String readStatus) {
        if (readStatus == null) {
            return Comment.ReadState.UNKNOWN;
        }
        if (readStatus.equals("READ")) {
            return Comment.ReadState.READ;
        }
        if (readStatus.equals("UNREAD")) {
            return Comment.ReadState.UNREAD;
        }
        if (readStatus.equals("LEAVE_UNREAD")) {
            return Comment.ReadState.LEAVE_UNREAD;
        }
        return Comment.ReadState.UNKNOWN;
    }

    private static void prepareComment(Comment comment, Element commentNode) {
        String date = COMMENT_TIME_FORMAT_BASE.print(comment.getCreateDate().getTime());
        String strangeDate = date.substring(0, date.length() - 2);
        strangeDate = String.valueOf(strangeDate) + ":00";
        CrucibleRestXmlHelper.addTag(commentNode, "createDate", strangeDate);
        Element userElement = new Element("user");
        JDomHelper.getContent(commentNode).add(userElement);
        CrucibleRestXmlHelper.addTag(userElement, "userName", comment.getAuthor().getUsername());
        CrucibleRestXmlHelper.addTag(commentNode, "defectRaised", Boolean.toString(comment.isDefectRaised()));
        CrucibleRestXmlHelper.addTag(commentNode, "defectApproved", Boolean.toString(comment.isDefectApproved()));
        CrucibleRestXmlHelper.addTag(commentNode, "deleted", Boolean.toString(comment.isDeleted()));
        CrucibleRestXmlHelper.addTag(commentNode, "draft", Boolean.toString(comment.isDraft()));
        CrucibleRestXmlHelper.addTag(commentNode, "message", comment.getMessage());
        Element metrics = new Element("metrics");
        JDomHelper.getContent(commentNode).add(metrics);
        for (String key : comment.getCustomFields().keySet()) {
            Element entry = new Element("entry");
            JDomHelper.getContent(metrics).add(entry);
            CrucibleRestXmlHelper.addTag(entry, "key", key);
            CustomField field = comment.getCustomFields().get(key);
            JDomHelper.getContent(entry).add(CrucibleRestXmlHelper.prepareCustomFieldValue(field));
        }
        Element replies = new Element("replies");
        JDomHelper.getContent(commentNode).add(replies);
    }

    public static GeneralComment parseGeneralCommentNode(Review review, @Nullable Comment parentComment, String myUsername, Element reviewCommentNode, boolean trimWikiMarkers) {
        GeneralComment reviewCommentBean = new GeneralComment(review, parentComment);
        if (!CrucibleRestXmlHelper.parseGeneralComment(review, myUsername, reviewCommentBean, reviewCommentNode, trimWikiMarkers)) {
            return null;
        }
        return reviewCommentBean;
    }

    public static Document prepareGeneralComment(Comment comment) {
        Element commentNode = new Element("generalCommentData");
        Document doc = new Document(commentNode);
        CrucibleRestXmlHelper.prepareComment(comment, commentNode);
        return doc;
    }

    public static Document prepareVersionedComment(PermId riId, VersionedComment comment) {
        if (comment.getToStartLine() > comment.getToEndLine()) {
            throw new IllegalArgumentException("Comment start cannot be after comment end!");
        }
        Element commentNode = new Element("versionedLineCommentData");
        Document doc = new Document(commentNode);
        CrucibleRestXmlHelper.prepareComment(comment, commentNode);
        Element reviewItemId = new Element("reviewItemId");
        JDomHelper.getContent(commentNode).add(reviewItemId);
        CrucibleRestXmlHelper.addTag(reviewItemId, "id", riId.getId());
        if (comment.getFromStartLine() > 0 && comment.getFromEndLine() > 0) {
            CrucibleRestXmlHelper.addTag(commentNode, "fromLineRange", String.valueOf(comment.getFromStartLine()) + "-" + comment.getFromEndLine());
        }
        if (comment.getToStartLine() > 0 && comment.getToEndLine() > 0) {
            CrucibleRestXmlHelper.addTag(commentNode, "toLineRange", String.valueOf(comment.getToStartLine()) + "-" + comment.getToEndLine());
        }
        return doc;
    }

    @Nullable
    public static VersionedComment parseVersionedCommentNode(Review review, Map<PermId, CrucibleFileInfo> crucibleFileInfos, String myUsername, Element reviewCommentNode, boolean trimWikiMarkers) throws ParseException {
        Element child;
        String toLineRange;
        String fromLineRange;
        VersionedComment comment = CrucibleRestXmlHelper.parseVersionedComment(review, myUsername, reviewCommentNode, trimWikiMarkers, crucibleFileInfos);
        if (comment == null) {
            return null;
        }
        if (reviewCommentNode.getChild("fromLineRange") != null && (fromLineRange = CrucibleRestXmlHelper.getChildText(reviewCommentNode, "fromLineRange")).trim().length() > 0) {
            try {
                comment.setFromLineRanges(IntRangesParser.parse(fromLineRange));
            }
            catch (NumberFormatException e) {
                LoggerImpl.getInstance().error(e);
            }
        }
        if (reviewCommentNode.getChild("toLineRange") != null && (toLineRange = CrucibleRestXmlHelper.getChildText(reviewCommentNode, "toLineRange")).trim().length() > 0) {
            try {
                comment.setToLineRanges(IntRangesParser.parse(toLineRange));
            }
            catch (NumberFormatException e) {
                LoggerImpl.getInstance().error(e);
            }
        }
        if ((child = reviewCommentNode.getChild("lineRanges")) != null) {
            CrucibleRestXmlHelper.parseAndFillLineRanges(comment, child);
        } else {
            CrucibleFileInfo fileInfo = comment.getCrucibleFileInfo();
            HashMap<String, IntRanges> ranges = MiscUtil.buildHashMap();
            if (fileInfo.getFileDescriptor() != null && comment.getToLineRanges() != null) {
                ranges.put(fileInfo.getFileDescriptor().getRevision(), comment.getToLineRanges());
            }
            if (fileInfo.getOldFileDescriptor() != null && comment.getFromLineRanges() != null) {
                ranges.put(fileInfo.getOldFileDescriptor().getRevision(), comment.getFromLineRanges());
            }
            if (ranges.size() > 0) {
                comment.setLineRanges(ranges);
            }
        }
        return comment;
    }

    private static void parseAndFillLineRanges(VersionedComment comment, Element lineRangesNode) {
        LinkedHashMap<String, IntRanges> rangesMap = new LinkedHashMap<String, IntRanges>();
        List<Element> entries = XmlUtil.getChildElements(lineRangesNode, "lineRange");
        for (Element rangeNode : entries) {
            String revisionStr = rangeNode.getAttributeValue("revision");
            String rangeStr = rangeNode.getAttributeValue("range");
            try {
                rangesMap.put(revisionStr, IntRangesParser.parse(rangeStr));
            }
            catch (NumberFormatException e) {
                LoggerImpl.getInstance().error(e);
            }
        }
        comment.setLineRanges(rangesMap);
    }

    private static Element prepareCustomFieldValue(CustomField value) {
        Element entry = new Element("value");
        CrucibleRestXmlHelper.addTag(entry, "configVersion", Integer.toString(value.getConfigVersion()));
        CrucibleRestXmlHelper.addTag(entry, "value", value.getValue());
        return entry;
    }

    private static CustomFieldValue getCustomFieldValue(CustomFieldValueType type, Element element) {
        CustomFieldValue newValue = new CustomFieldValue();
        newValue.setName(CrucibleRestXmlHelper.getChildText(element, "name"));
        switch (type) {
            case INTEGER: {
                try {
                    newValue.setValue(Integer.valueOf(CrucibleRestXmlHelper.getChildText(element, "value")));
                }
                catch (NumberFormatException numberFormatException) {
                    newValue.setValue(0);
                }
                break;
            }
            case STRING: {
                newValue.setValue(CrucibleRestXmlHelper.getChildText(element, "value"));
                break;
            }
            case BOOLEAN: {
                newValue.setValue(Boolean.valueOf(CrucibleRestXmlHelper.getChildText(element, "value")));
                break;
            }
            default: {
                newValue.setValue(null);
            }
        }
        return newValue;
    }

    public static CustomFieldDefBean parseMetricsNode(Element element) {
        CustomFieldDefBean field = new CustomFieldDefBean();
        field.setName(CrucibleRestXmlHelper.getChildText(element, "name"));
        field.setLabel(CrucibleRestXmlHelper.getChildText(element, "label"));
        field.setType(CustomFieldValueType.valueOf(CrucibleRestXmlHelper.getChildText(element, "type")));
        field.setConfigVersion(Integer.parseInt(CrucibleRestXmlHelper.getChildText(element, "configVersion")));
        List<Element> defaultValue = XmlUtil.getChildElements(element, "defaultValue");
        for (Element value : defaultValue) {
            field.setDefaultValue(CrucibleRestXmlHelper.getCustomFieldValue(field.getType(), value));
        }
        List<Element> values = XmlUtil.getChildElements(element, "values");
        for (Element value : values) {
            field.getValues().add(CrucibleRestXmlHelper.getCustomFieldValue(field.getType(), value));
        }
        return field;
    }

    public static Document prepareCustomFilter(CustomFilter filter) {
        Element filterData = CrucibleRestXmlHelper.prepareFilterNodeElement(filter);
        return new Document(filterData);
    }

    private static Element prepareFilterNodeElement(CustomFilter filter) {
        Element filterData = new Element("customFilterData");
        CrucibleRestXmlHelper.addTag(filterData, "author", filter.getAuthor() != null ? filter.getAuthor() : "");
        CrucibleRestXmlHelper.addTag(filterData, "creator", filter.getCreator() != null ? filter.getCreator() : "");
        CrucibleRestXmlHelper.addTag(filterData, "moderator", filter.getModerator() != null ? filter.getModerator() : "");
        CrucibleRestXmlHelper.addTag(filterData, "reviewer", filter.getReviewer() != null ? filter.getReviewer() : "");
        CrucibleRestXmlHelper.addTag(filterData, "project", filter.getProjectKey() != null ? filter.getProjectKey() : "");
        String state = filter.getStates();
        if (!StringUtils.isEmpty((String)state)) {
            CrucibleRestXmlHelper.addTag(filterData, "state", state);
        }
        if (filter.isComplete() != null) {
            CrucibleRestXmlHelper.addTag(filterData, "complete", Boolean.toString(filter.isComplete()));
        }
        CrucibleRestXmlHelper.addTag(filterData, "orRoles", Boolean.toString(filter.isOrRoles()));
        if (filter.isAllReviewersComplete() != null) {
            CrucibleRestXmlHelper.addTag(filterData, "allReviewersComplete", Boolean.toString(filter.isAllReviewersComplete()));
        }
        return filterData;
    }

    public static Date parseDateTime(String date) {
        IllegalArgumentException ae = null;
        if (date != null && !date.equals("")) {
            DateTimeFormatter[] dateTimeFormatterArray = COMMENT_TIME_FORMATS;
            int n = COMMENT_TIME_FORMATS.length;
            int n2 = 0;
            while (n2 < n) {
                DateTimeFormatter f = dateTimeFormatterArray[n2];
                try {
                    Date parsedDate = f.parseDateTime(date).toDate();
                    return parsedDate;
                }
                catch (IllegalArgumentException e) {
                    ae = e;
                    ++n2;
                }
            }
            if (ae != null) {
                throw ae;
            }
        }
        return null;
    }

    private static DateTime parseJodaDateTime(String date) throws ParseException {
        ParseException pe = null;
        if (date != null && !date.equals("")) {
            DateTimeFormatter[] dateTimeFormatterArray = COMMENT_TIME_FORMATS;
            int n = COMMENT_TIME_FORMATS.length;
            int n2 = 0;
            while (n2 < n) {
                DateTimeFormatter f = dateTimeFormatterArray[n2];
                try {
                    return f.parseDateTime(date);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    pe = new ParseException("Invalid date string encountered [" + date + "]", 0);
                }
                catch (RuntimeException runtimeException) {
                    pe = new ParseException("Cannot convert string [" + date + "] to date", 0);
                }
                ++n2;
            }
            if (pe != null) {
                throw pe;
            }
        }
        return null;
    }

    private static ReviewType parseReviewType(String reviewType) throws ParseException {
        if (reviewType == null || "REVIEW".equals(reviewType)) {
            return ReviewType.REVIEW;
        }
        if ("SNIPPET".equals(reviewType)) {
            return ReviewType.SNIPPET;
        }
        throw new ParseException("Unknown review type [" + reviewType + "]", 0);
    }

    public static CrucibleVersionInfo parseVersionNode(Element element) {
        return new CrucibleVersionInfo(CrucibleRestXmlHelper.getChildText(element, "releaseNumber"), CrucibleRestXmlHelper.getChildText(element, "buildDate"));
    }

    public static Changes parseChangesNode(Element changesNode) {
        ArrayList<Change> changes = MiscUtil.buildArrayList();
        for (Element changeNode : XmlUtil.getChildElements(changesNode, "change")) {
            changes.add(CrucibleRestXmlHelper.parseChangeNode(changeNode));
        }
        return new Changes(Boolean.parseBoolean(changesNode.getAttributeValue("olderChangeSetsExist")), Boolean.parseBoolean(changesNode.getAttributeValue("newerChangeSetsExist")), changes);
    }

    private static Change parseChangeNode(Element changeNode) {
        String author = changeNode.getAttributeValue("author");
        String csid = changeNode.getAttributeValue("csid");
        Date date = CrucibleRestXmlHelper.parseDateTime(changeNode.getAttributeValue("date"));
        Link link = CrucibleRestXmlHelper.parseLinkNode(changeNode.getChild("link"));
        String comment = CrucibleRestXmlHelper.getChildText(changeNode, "comment");
        ArrayList<Revision> revisions = MiscUtil.buildArrayList();
        for (Element revisionNode : XmlUtil.getChildElements(changeNode, "revision")) {
            revisions.add(CrucibleRestXmlHelper.parseRevisionNode(revisionNode));
        }
        return new Change(author, date, csid, link, comment, revisions);
    }

    private static Revision parseRevisionNode(Element revisionNode) {
        String revision = revisionNode.getAttributeValue("revision");
        String path = revisionNode.getAttributeValue("path");
        ArrayList<Link> links = MiscUtil.buildArrayList();
        for (Element linkNode : XmlUtil.getChildElements(revisionNode, "link")) {
            links.add(CrucibleRestXmlHelper.parseLinkNode(linkNode));
        }
        return new Revision(revision, path, links);
    }

    private static Link parseLinkNode(Element child) {
        return new Link(child.getAttributeValue("rel"), child.getAttributeValue("href"));
    }

    public static void parseErrorAndThrowIt(Element errorNode) throws RemoteApiException {
        throw new RemoteApiException(CrucibleRestXmlHelper.getChildText(errorNode, "message"), CrucibleRestXmlHelper.getChildText(errorNode, "stacktrace"));
    }

    public static void addAnchorData(Document request, PatchAnchorData patchAnchorData) {
        if (patchAnchorData == null) {
            return;
        }
        Element anchorData = new Element("anchor");
        Element anchorRepository = new Element("anchorRepository");
        anchorRepository.setText(patchAnchorData.getRepositoryName());
        anchorData.addContent((Content)anchorRepository);
        ((Element)request.getContent().get(0)).addContent((Content)anchorData);
    }
}

