/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class User
implements Serializable {
    private static final int HASH_MAGIC = 31;
    @NotNull
    protected String userName;
    @Nullable
    protected String displayName;
    @Nullable
    private String avatarUrl;

    public User(String userName) {
        this.userName = userName;
    }

    public User(@NotNull String userName, @Nullable String displayName) {
        this(userName, displayName, null);
    }

    public User(@NotNull String userName, @Nullable String displayName, @Nullable String avatarUrl) {
        this.userName = userName;
        this.displayName = displayName;
        this.avatarUrl = avatarUrl;
    }

    @Nullable
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @NotNull
    public String getUsername() {
        return this.userName;
    }

    @Nullable
    public String getDisplayName() {
        if (this.displayName == null) {
            return this.userName;
        }
        return this.displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User userBean = (User)o;
        if (this.displayName != null ? !this.displayName.equals(userBean.displayName) : userBean.displayName != null) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(userBean.userName) : userBean.userName != null);
    }

    public int hashCode() {
        int result = this.userName != null ? this.userName.hashCode() : 0;
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        return result;
    }

    public int compareTo(User that) {
        return this.userName.compareTo(that.getUsername());
    }

    public String toString() {
        return "User [[" + this.userName + "], [" + this.displayName + "]]";
    }
}

