/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.misc;

import com.atlassian.connector.commons.misc.IntRange;
import com.atlassian.connector.commons.misc.IntRanges;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class IntRangesParser {
    private IntRangesParser() {
    }

    @NotNull
    public static IntRanges parse(@NotNull String rangesStr) throws NumberFormatException {
        if (rangesStr == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        if ((rangesStr = rangesStr.trim()).length() == 0) {
            throw new NumberFormatException("Cannot parse [" + rangesStr + "] into " + IntRanges.class.getName());
        }
        String[] tokens = rangesStr.split(",");
        ArrayList<IntRange> res = MiscUtil.buildArrayList();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String nontrimmedtoken = stringArray[n2];
            String token = nontrimmedtoken.trim();
            try {
                int index = token.lastIndexOf(45);
                if (index < 1) {
                    res.add(new IntRange(Integer.parseInt(token)));
                } else {
                    int max;
                    int min;
                    int index2 = token.lastIndexOf(45, index - 1);
                    if (index2 > 0) {
                        index = index2;
                    }
                    if ((min = Integer.parseInt(token.substring(0, index).trim())) > (max = Integer.parseInt(token.substring(index + 1).trim()))) {
                        throw new NumberFormatException("The lower bound of the range [" + min + "] cannot be greater than" + "the upper bound of the range [" + max + "]");
                    }
                    res.add(new IntRange(min, max));
                }
            }
            catch (NumberFormatException e) {
                NumberFormatException ex = new NumberFormatException("Cannot parse [" + rangesStr + "] into " + IntRanges.class.getName());
                ex.initCause(e);
                throw ex;
            }
            ++n2;
        }
        return new IntRanges(res);
    }
}

