/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira.rss;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.commons.jira.JIRAIssue;
import com.atlassian.connector.commons.jira.JIRAIssueBean;
import com.atlassian.connector.commons.jira.JIRASessionPartTwo;
import com.atlassian.connector.commons.jira.beans.JIRASavedFilter;
import com.atlassian.connector.commons.jira.beans.JiraFilter;
import com.atlassian.connector.commons.jira.cache.CachedIconLoader;
import com.atlassian.connector.commons.jira.rss.JIRAException;
import com.atlassian.theplugin.commons.cfg.UserCfg;
import com.atlassian.theplugin.commons.remoteapi.CaptchaRequiredException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiMalformedUrlException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiSessionExpiredException;
import com.atlassian.theplugin.commons.remoteapi.ServerData;
import com.atlassian.theplugin.commons.remoteapi.ServiceUnavailableException;
import com.atlassian.theplugin.commons.remoteapi.jira.JiraCaptchaRequiredException;
import com.atlassian.theplugin.commons.remoteapi.jira.JiraServiceUnavailableException;
import com.atlassian.theplugin.commons.remoteapi.rest.AbstractHttpSession;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import com.atlassian.theplugin.commons.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIRARssClient
extends AbstractHttpSession
implements JIRASessionPartTwo {
    private final ConnectionCfg httpConnectionCfg;
    private boolean login = false;
    private boolean jira4x = true;

    public JIRARssClient(ConnectionCfg httpConnectionCfg, HttpSessionCallback callback) throws RemoteApiMalformedUrlException {
        super(httpConnectionCfg, callback);
        this.httpConnectionCfg = httpConnectionCfg;
    }

    @Override
    protected void adjustHttpHeader(HttpMethod method) {
        if (this.httpConnectionCfg instanceof ServerData && ((ServerData)this.httpConnectionCfg).isUseBasicUser()) {
            method.addRequestHeader(new Header("Authorization", this.getAuthBasicHeaderValue()));
        }
    }

    @Override
    protected void preprocessResult(Document doc) throws JDOMException, RemoteApiSessionExpiredException {
    }

    @Override
    protected void preprocessMethodResult(HttpMethod method) throws RemoteApiException, ServiceUnavailableException {
        try {
            if (this.login && method != null && method.getStatusLine() != null) {
                if (method.getStatusCode() == 404) {
                    this.jira4x = false;
                } else if (method.getResponseHeader("Content-Type") != null && method.getResponseHeader("Content-Type").getValue().startsWith("application/json")) {
                    String json = "";
                    json = method instanceof PostMethod ? new String(((PostMethod)method).getResponseBody(1024)) : method.getResponseBodyAsString();
                    if (json != null && json.contains("\"captchaFailure\":true")) {
                        throw new CaptchaRequiredException(null);
                    }
                    if (json != null && json.contains("\"loginFailedByPermissions\":true")) {
                        throw new JiraServiceUnavailableException("You don't have permission to login");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RemoteApiException("Cannot parse method result.", e);
        }
    }

    private String getAuthBasicHeaderValue() {
        UserCfg basicUser = ((ServerData)this.httpConnectionCfg).getBasicUser();
        if (basicUser != null && basicUser.getUsername() != null && basicUser.getPassword() != null) {
            return "Basic " + StringUtil.encode(String.valueOf(basicUser.getUsername()) + ":" + basicUser.getPassword());
        }
        return "";
    }

    private Locale getLocale(Element channel) {
        String[] parsedLocale;
        Locale locale = Locale.US;
        Element language = channel.getChild("language");
        if (language != null && (parsedLocale = language.getText().split("-")) != null && parsedLocale.length > 1) {
            locale = new Locale(parsedLocale[0], parsedLocale[1]);
        }
        return locale;
    }

    @Override
    public List<JIRAIssue> getIssues(JiraFilter filter, String sortBy, String sortOrder, int start, int max) throws JIRAException {
        StringBuilder url = new StringBuilder(String.valueOf(this.getBaseUrl()) + "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?");
        url.append(filter.getOldStyleQueryString());
        url.append("&sorter/field=").append(sortBy);
        url.append("&sorter/order=").append(sortOrder);
        url.append("&pager/start=").append(start);
        url.append("&tempMax=").append(max);
        try {
            Document doc = this.retrieveGetResponse(url.toString());
            Element root = doc.getRootElement();
            Element channel = root.getChild("channel");
            if (channel != null && !channel.getChildren("item").isEmpty()) {
                return this.makeIssues(channel.getChildren("item"), this.getLocale(channel));
            }
            return Collections.emptyList();
        }
        catch (AuthenticationException e) {
            throw new JIRAException("Authentication error", e);
        }
        catch (IOException e) {
            throw new JIRAException("Connection error: " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new JIRAException(e.getMessage(), e);
        }
        catch (RemoteApiSessionExpiredException e) {
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAIssue> getIssues(String jql, String sort, String sortOrder, int start, int size) throws JIRAException {
        throw new JIRAException("Not implemented");
    }

    @Override
    public List<JIRAIssue> getSavedFilterIssues(JIRASavedFilter filter, String sortBy, String sortOrder, int start, int max) throws JIRAException {
        StringBuilder url = new StringBuilder(String.valueOf(this.getBaseUrl()) + "/sr/jira.issueviews:searchrequest-xml/");
        if (filter.getOldStyleQueryString() != null) {
            url.append(filter.getQueryStringFragment()).append("/SearchRequest-").append(filter.getOldStyleQueryString()).append(".xml");
        }
        url.append("?sorter/field=").append(sortBy);
        url.append("&sorter/order=").append(sortOrder);
        url.append("&pager/start=").append(start);
        url.append("&tempMax=").append(max);
        try {
            Document doc = this.retrieveGetResponse(url.toString());
            Element root = doc.getRootElement();
            Element channel = root.getChild("channel");
            if (channel != null && !channel.getChildren("item").isEmpty()) {
                return this.makeIssues(channel.getChildren("item"), this.getLocale(channel));
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new JIRAException(e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new JIRAException(e.getMessage(), e);
        }
        catch (RemoteApiSessionExpiredException e) {
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public JIRAIssue getIssue(String issueKey) throws JIRAException {
        StringBuffer url = new StringBuffer(String.valueOf(this.getBaseUrl()) + "/si/jira.issueviews:issue-xml/");
        url.append(issueKey).append('/').append(issueKey).append(".xml");
        try {
            List items;
            Document doc = this.retrieveGetResponse(url.toString());
            Element root = doc.getRootElement();
            Element channel = root.getChild("channel");
            if (channel != null && !(items = channel.getChildren("item")).isEmpty()) {
                return this.makeIssues(items, this.getLocale(channel)).get(0);
            }
            throw new JIRAException("Cannot parse response from JIRA: " + doc.toString());
        }
        catch (IOException e) {
            throw new JIRAException(e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new JIRAException(e.getMessage(), e);
        }
        catch (RemoteApiSessionExpiredException e) {
            throw new JIRAException(e.getMessage(), e);
        }
    }

    private List<JIRAIssue> makeIssues(@NotNull List<Element> issueElements, Locale locale) {
        ArrayList<JIRAIssue> result = new ArrayList<JIRAIssue>(issueElements.size());
        for (Element issueElement : issueElements) {
            JIRAIssueBean jiraIssue = new JIRAIssueBean(this.httpConnectionCfg.getUrl(), issueElement, locale);
            CachedIconLoader.loadIcon(jiraIssue.getTypeIconUrl());
            CachedIconLoader.loadIcon(jiraIssue.getPriorityIconUrl());
            CachedIconLoader.loadIcon(jiraIssue.getStatusTypeUrl());
            result.add(jiraIssue);
        }
        return result;
    }

    @Override
    public void testConnection() throws RemoteApiException {
        try {
            this.login();
        }
        catch (JIRAException e) {
            throw new RemoteApiException(e);
        }
    }

    @Override
    public void login() throws JIRAException, JiraCaptchaRequiredException {
        try {
            try {
                this.login = true;
                HashMap<String, String> loginParams = new HashMap<String, String>();
                loginParams.put("os_username", this.httpConnectionCfg.getUsername());
                loginParams.put("os_password", this.httpConnectionCfg.getPassword());
                loginParams.put("os_destination", "/success");
                if (this.jira4x) {
                    super.retrievePostResponseWithForm(String.valueOf(this.httpConnectionCfg.getUrl()) + "/rest/gadget/1.0/login", loginParams, false);
                }
                if (!this.jira4x) {
                    super.retrievePostResponseWithForm(String.valueOf(this.httpConnectionCfg.getUrl()) + "/secure/Dashboard.jspa", loginParams, false);
                }
            }
            catch (JDOMException e) {
                throw new JIRAException(e.getMessage());
            }
            catch (CaptchaRequiredException e) {
                throw new JiraCaptchaRequiredException(e.getMessage());
            }
            catch (RemoteApiException e) {
                throw new JIRAException(e.getMessage());
            }
        }
        finally {
            this.login = false;
        }
    }

    @Override
    public boolean isLoggedIn(ConnectionCfg server) {
        Cookie[] cookies = this.callback.getCookiesHeaders(server);
        return cookies != null && cookies.length > 0;
    }
}

