/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.commons.jira.JIRAAction;
import com.atlassian.connector.commons.jira.JIRAActionField;
import com.atlassian.connector.commons.jira.JIRAIssue;
import com.atlassian.connector.commons.jira.JIRAServerFacade2;
import com.atlassian.connector.commons.jira.JiraRESTSupportTester;
import com.atlassian.connector.commons.jira.JiraUserNotFoundException;
import com.atlassian.connector.commons.jira.beans.JIRAAttachment;
import com.atlassian.connector.commons.jira.beans.JIRAComment;
import com.atlassian.connector.commons.jira.beans.JIRAComponentBean;
import com.atlassian.connector.commons.jira.beans.JIRAConstant;
import com.atlassian.connector.commons.jira.beans.JIRAPriorityBean;
import com.atlassian.connector.commons.jira.beans.JIRAProject;
import com.atlassian.connector.commons.jira.beans.JIRAQueryFragment;
import com.atlassian.connector.commons.jira.beans.JIRAResolutionBean;
import com.atlassian.connector.commons.jira.beans.JIRASavedFilter;
import com.atlassian.connector.commons.jira.beans.JIRASecurityLevelBean;
import com.atlassian.connector.commons.jira.beans.JIRAUserBean;
import com.atlassian.connector.commons.jira.beans.JIRAVersionBean;
import com.atlassian.connector.commons.jira.beans.JiraFilter;
import com.atlassian.connector.commons.jira.rest.JiraRestSessionImpl;
import com.atlassian.connector.commons.jira.rss.JIRAException;
import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.configuration.ConfigurationFactory;
import com.atlassian.theplugin.commons.jira.JiraServerData;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.util.HttpConfigurableAdapter;
import com.atlassian.theplugin.commons.util.Logger;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraRESTFacade2Impl
implements JIRAServerFacade2,
JiraRESTSupportTester {
    private static Logger logger;
    private final Map<ConnectionCfg, JiraRestSessionImpl> sessions = new HashMap<ConnectionCfg, JiraRestSessionImpl>();

    @Override
    public void reset() {
        this.sessions.clear();
    }

    @Override
    public boolean usesRest(JiraServerData jiraServerData) {
        try {
            return this.get(jiraServerData).supportsRest();
        }
        catch (JIRAException jIRAException) {
            return false;
        }
    }

    public static void setLogger(Logger logger) {
        JiraRESTFacade2Impl.logger = logger;
    }

    @Override
    public boolean supportsRest(ConnectionCfg server) throws JIRAException {
        JiraRestSessionImpl session = this.get(server);
        return session.supportsRest();
    }

    @Override
    public List<JIRAIssue> getIssues(ConnectionCfg server, JiraFilter filter, String sort, String sortOrder, int start, int size) throws JIRAException {
        JiraRestSessionImpl session = this.get(server);
        return session.getIssues(filter, sort, sortOrder, start, size);
    }

    @Override
    public List<JIRAIssue> getIssues(JiraServerData server, String query, String sort, String sortOrder, int start, int size) throws JIRAException {
        JiraRestSessionImpl session = this.get(server);
        return session.getIssues(query, sort, sortOrder, start, size);
    }

    @Override
    public List<JIRAIssue> getSavedFilterIssues(ConnectionCfg server, JIRASavedFilter filter, String sort, String sortOrder, int start, int size) throws JIRAException {
        JiraRestSessionImpl session = this.get(server);
        return session.getSavedFilterIssues(filter, sort, sortOrder, start, size);
    }

    @Override
    public List<JIRAProject> getProjects(final ConnectionCfg server) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAProject>>(){

            @Override
            public List<JIRAProject> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getProjects();
            }
        });
    }

    @Override
    public List<JIRAProject> getProjectsForIssueCreation(final ConnectionCfg server) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAProject>>(){

            @Override
            public List<JIRAProject> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getProjectsForIssueCreation();
            }
        });
    }

    @Override
    public List<JIRAConstant> getStatuses(final ConnectionCfg server) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAConstant>>(){

            @Override
            public List<JIRAConstant> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getStatuses();
            }
        });
    }

    @Override
    public List<JIRAConstant> getIssueTypes(final ConnectionCfg server) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAConstant>>(){

            @Override
            public List<JIRAConstant> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getIssueTypes();
            }
        });
    }

    @Override
    public List<JIRAConstant> getIssueTypesForProject(final ConnectionCfg server, final long projectId, final String projectKey) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAConstant>>(){

            @Override
            public List<JIRAConstant> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getIssueTypesForProject(projectId, projectKey);
            }
        });
    }

    @Override
    public List<JIRAConstant> getSubtaskIssueTypes(final ConnectionCfg server) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAConstant>>(){

            @Override
            public List<JIRAConstant> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getSubtaskIssueTypes();
            }
        });
    }

    @Override
    public List<JIRAConstant> getSubtaskIssueTypesForProject(final ConnectionCfg server, final long projectId, final String projectKey) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAConstant>>(){

            @Override
            public List<JIRAConstant> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getSubtaskIssueTypesForProject(projectId, projectKey);
            }
        });
    }

    @Override
    public List<JIRAQueryFragment> getSavedFilters(final ConnectionCfg server) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAQueryFragment>>(){

            @Override
            public List<JIRAQueryFragment> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getSavedFilters();
            }
        });
    }

    @Override
    public List<JIRAComponentBean> getComponents(final ConnectionCfg server, final String projectKey) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAComponentBean>>(){

            @Override
            public List<JIRAComponentBean> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getComponents(projectKey);
            }
        });
    }

    @Override
    public List<JIRAVersionBean> getVersions(final ConnectionCfg server, final String projectKey) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAVersionBean>>(){

            @Override
            public List<JIRAVersionBean> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getVersions(projectKey);
            }
        });
    }

    @Override
    public List<JIRAPriorityBean> getPriorities(final ConnectionCfg server) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAPriorityBean>>(){

            @Override
            public List<JIRAPriorityBean> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getPriorities();
            }
        });
    }

    @Override
    public List<JIRAResolutionBean> getResolutions(final ConnectionCfg server) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAResolutionBean>>(){

            @Override
            public List<JIRAResolutionBean> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getResolutions();
            }
        });
    }

    @Override
    public List<JIRAAction> getAvailableActions(final ConnectionCfg server, final JIRAIssue issue) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAAction>>(){

            @Override
            public List<JIRAAction> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getAvailableActions(issue);
            }
        });
    }

    @Override
    public List<JIRAActionField> getFieldsForAction(final ConnectionCfg server, final JIRAIssue issue, final JIRAAction action) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAActionField>>(){

            @Override
            public List<JIRAActionField> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getFieldsForAction(issue, action);
            }
        });
    }

    @Override
    public void progressWorkflowAction(final ConnectionCfg server, final JIRAIssue issue, final JIRAAction action) throws JIRAException {
        this.withJiraException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JiraRESTFacade2Impl.this.get(server).progressWorkflowAction(issue, action, null);
                return null;
            }
        });
    }

    @Override
    public void progressWorkflowAction(final ConnectionCfg server, final JIRAIssue issue, final JIRAAction action, final List<JIRAActionField> fields) throws JIRAException {
        this.withJiraException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JiraRESTFacade2Impl.this.get(server).progressWorkflowAction(issue, action, fields);
                return null;
            }
        });
    }

    @Override
    public void addComment(final ConnectionCfg server, final String issueKey, final String comment) throws JIRAException {
        this.withJiraException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JiraRESTFacade2Impl.this.get(server).addComment(issueKey, comment);
                return null;
            }
        });
    }

    @Override
    public void addAttachment(final ConnectionCfg server, final String issueKey, final String name, final byte[] content) throws JIRAException {
        this.withJiraException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JiraRESTFacade2Impl.this.get(server).addAttachment(issueKey, name, content);
                return null;
            }
        });
    }

    @Override
    public JIRAIssue createIssue(final ConnectionCfg server, final JIRAIssue issue) throws JIRAException {
        return this.withJiraException(new Callable<JIRAIssue>(){

            @Override
            public JIRAIssue call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).createIssue(issue);
            }
        });
    }

    @Override
    public JIRAIssue createSubtask(final JiraServerData server, final JIRAIssue parent, final JIRAIssue issue) throws JIRAException {
        return this.withJiraException(new Callable<JIRAIssue>(){

            @Override
            public JIRAIssue call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).createSubtask(parent, issue);
            }
        });
    }

    @Override
    public JIRAIssue getIssue(ConnectionCfg server, String key) throws JIRAException {
        return this.get(server).getIssue(key);
    }

    @Override
    public JIRAIssue getIssueDetails(final ConnectionCfg server, final JIRAIssue issue) throws JIRAException {
        return this.withJiraException(new Callable<JIRAIssue>(){

            @Override
            public JIRAIssue call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getIssueDetails(issue);
            }
        });
    }

    @Override
    public void logWork(final ConnectionCfg server, final JIRAIssue issue, final String timeSpent, final Calendar startDate, final String comment, final boolean updateEstimate, final String newEstimate) throws JIRAException {
        this.withJiraException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JiraRESTFacade2Impl.this.get(server).logWork(issue, timeSpent, startDate, comment, updateEstimate, newEstimate);
                return null;
            }
        });
    }

    @Override
    public void setField(final ConnectionCfg server, final JIRAIssue issue, final String fieldId, final String value) throws JIRAException {
        this.withJiraException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JiraRESTFacade2Impl.this.get(server).setField(issue, fieldId, value);
                return null;
            }
        });
    }

    @Override
    public void setField(final ConnectionCfg server, final JIRAIssue issue, final String fieldId, final String[] values) throws JIRAException {
        this.withJiraException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JiraRESTFacade2Impl.this.get(server).setField(issue, fieldId, values);
                return null;
            }
        });
    }

    @Override
    public void setFields(final ConnectionCfg server, final JIRAIssue issue, final List<JIRAActionField> fields) throws JIRAException {
        this.withJiraException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JiraRESTFacade2Impl.this.get(server).setFields(issue, fields);
                return null;
            }
        });
    }

    @Override
    public JIRAUserBean getUser(final ConnectionCfg server, final String loginName) throws JIRAException, JiraUserNotFoundException {
        return this.withJiraException(new Callable<JIRAUserBean>(){

            @Override
            public JIRAUserBean call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getUser(loginName);
            }
        });
    }

    @Override
    public List<JIRAComment> getComments(final ConnectionCfg server, final JIRAIssue issue) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRAComment>>(){

            @Override
            public List<JIRAComment> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getComments(issue);
            }
        });
    }

    @Override
    public Collection<JIRAAttachment> getIssueAttachements(final ConnectionCfg server, final JIRAIssue issue) throws JIRAException {
        return this.withJiraException(new Callable<Collection<JIRAAttachment>>(){

            @Override
            public Collection<JIRAAttachment> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getIssueAttachements(issue);
            }
        });
    }

    @Override
    public List<JIRASecurityLevelBean> getSecurityLevels(final ConnectionCfg server, final String projectKey) throws JIRAException {
        return this.withJiraException(new Callable<List<JIRASecurityLevelBean>>(){

            @Override
            public List<JIRASecurityLevelBean> call() throws Exception {
                return JiraRESTFacade2Impl.this.get(server).getSecurityLevels(projectKey);
            }
        });
    }

    @Override
    public void testServerConnection(ConnectionCfg server) throws RemoteApiException {
        try {
            this.get(server).testConnection();
        }
        catch (JIRAException e) {
            throw new RemoteApiException(e);
        }
    }

    @Override
    public ServerType getServerType() {
        return ServerType.JIRA_SERVER;
    }

    private JiraRestSessionImpl get(ConnectionCfg connectionCfg) throws JIRAException {
        JiraRestSessionImpl session = this.sessions.get(connectionCfg);
        if (session == null) {
            boolean useIdeaProxySettings = ConfigurationFactory.getConfiguration().getGeneralConfigurationData().getUseIdeaProxySettings();
            HttpConfigurableAdapter proxyInfo = ConfigurationFactory.getConfiguration().transientGetHttpConfigurable();
            try {
                session = new JiraRestSessionImpl(connectionCfg, useIdeaProxySettings ? proxyInfo : null);
            }
            catch (URISyntaxException e) {
                throw new JIRAException(e.getMessage());
            }
            this.sessions.put(connectionCfg, session);
        }
        return session;
    }

    private <T> T withJiraException(Callable<T> callable) throws JIRAException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new JIRAException(e.getMessage(), e);
        }
    }
}

