/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.ide.eclipse.aop.core.model.IAnnotationAopDefinition;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class AopReferenceModelMarkerUtils {
    private static final String SOURCE_RESOURCE = "source_resource";
    private static final String MARKER_COUNT = "marker_count";
    public static final String AOP_MARKER = "org.springframework.ide.eclipse.aop.core.marker";
    public static final String AOP_PROBLEM_MARKER = "org.springframework.ide.eclipse.aop.core.problemmarker";
    public static final String BEFORE_ADVICE_MARKER = "org.springframework.ide.eclipse.aop.core.beforeadvicemarker";
    public static final String AFTER_ADVICE_MARKER = "org.springframework.ide.eclipse.aop.core.afteradvicemarker";
    public static final String AROUND_ADVICE_MARKER = "org.springframework.ide.eclipse.aop.core.aroundadvicemarker";
    public static final String INTRODUCTION_MARKER = "org.springframework.ide.eclipse.aop.core.introductionmarker";
    public static final String SOURCE_BEFORE_ADVICE_MARKER = "org.springframework.ide.eclipse.aop.core.sourcebeforeadvicemarker";
    public static final String SOURCE_AFTER_ADVICE_MARKER = "org.springframework.ide.eclipse.aop.core.sourceafteradvicemarker";
    public static final String SOURCE_AROUND_ADVICE_MARKER = "org.springframework.ide.eclipse.aop.core.sourcearoundadvicemarker";
    public static final String SOURCE_INTRODUCTION_MARKER = "org.springframework.ide.eclipse.aop.core.sourceintroductionmarker";
    public static Map<IAopReference.ADVICE_TYPE, String> sourceMarkerMapping;
    public static Map<IAopReference.ADVICE_TYPE, String> targetMarkerMapping;
    private static int AOP_MARKER_SEVERITY;

    static {
        AOP_MARKER_SEVERITY = 0;
        sourceMarkerMapping = new HashMap<IAopReference.ADVICE_TYPE, String>();
        sourceMarkerMapping.put(IAopReference.ADVICE_TYPE.BEFORE, SOURCE_BEFORE_ADVICE_MARKER);
        sourceMarkerMapping.put(IAopReference.ADVICE_TYPE.AFTER, SOURCE_AFTER_ADVICE_MARKER);
        sourceMarkerMapping.put(IAopReference.ADVICE_TYPE.AFTER_RETURNING, SOURCE_AFTER_ADVICE_MARKER);
        sourceMarkerMapping.put(IAopReference.ADVICE_TYPE.AFTER_THROWING, SOURCE_AFTER_ADVICE_MARKER);
        sourceMarkerMapping.put(IAopReference.ADVICE_TYPE.AROUND, SOURCE_AROUND_ADVICE_MARKER);
        sourceMarkerMapping.put(IAopReference.ADVICE_TYPE.DECLARE_PARENTS, SOURCE_INTRODUCTION_MARKER);
        targetMarkerMapping = new HashMap<IAopReference.ADVICE_TYPE, String>();
        targetMarkerMapping.put(IAopReference.ADVICE_TYPE.BEFORE, BEFORE_ADVICE_MARKER);
        targetMarkerMapping.put(IAopReference.ADVICE_TYPE.AFTER, AFTER_ADVICE_MARKER);
        targetMarkerMapping.put(IAopReference.ADVICE_TYPE.AFTER_RETURNING, AFTER_ADVICE_MARKER);
        targetMarkerMapping.put(IAopReference.ADVICE_TYPE.AFTER_THROWING, AFTER_ADVICE_MARKER);
        targetMarkerMapping.put(IAopReference.ADVICE_TYPE.AROUND, AROUND_ADVICE_MARKER);
        targetMarkerMapping.put(IAopReference.ADVICE_TYPE.DECLARE_PARENTS, INTRODUCTION_MARKER);
    }

    public static void createMarker(IAopReference reference, IResource sourceResource) {
        AopReferenceModelMarkerUtils.createSourceMarker(reference, sourceMarkerMapping.get((Object)reference.getAdviceType()), sourceResource);
        AopReferenceModelMarkerUtils.createTargetMarker(reference, targetMarkerMapping.get((Object)reference.getAdviceType()), sourceResource);
    }

    public static void createTargetMarker(IAopReference reference, String markerId, IResource sourceResource) {
        if (reference.getAdviceType() == IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
            AopReferenceModelMarkerUtils.createProblemMarker(reference.getTarget().getResource(), "aspect declarations <" + reference.getDefinition().getAspectName() + ">", AOP_MARKER_SEVERITY, reference.getTargetStartLine(), markerId, sourceResource);
            if (reference.getTargetBeanResource() != null && reference.getTargetBeanStartline() > 0) {
                AopReferenceModelMarkerUtils.createProblemMarker(reference.getTargetBeanResource(), "aspect declarations <" + reference.getDefinition().getAspectName() + ">", AOP_MARKER_SEVERITY, reference.getTargetBeanStartline(), markerId, sourceResource);
            }
        } else {
            AopReferenceModelMarkerUtils.createProblemMarker(reference.getTarget().getResource(), "advised by " + AopReferenceModelUtils.getJavaElementLinkNameForMarker(reference.getSource()), AOP_MARKER_SEVERITY, reference.getTargetStartLine(), markerId, sourceResource);
            if (reference.getTargetBeanResource() != null && reference.getTargetBeanStartline() > 0) {
                AopReferenceModelMarkerUtils.createProblemMarker(reference.getTargetBeanResource(), "advised by " + AopReferenceModelUtils.getJavaElementLinkNameForMarker(reference.getSource()), AOP_MARKER_SEVERITY, reference.getTargetBeanStartline(), markerId, sourceResource);
            }
        }
    }

    public static void createSourceMarker(IAopReference reference, String markerId, IResource sourceResource) {
        if (reference.getAdviceType() == IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
            if (reference.getDefinition() instanceof IAnnotationAopDefinition) {
                AopReferenceModelMarkerUtils.createProblemMarker(reference.getSource().getResource(), "declared on " + AopReferenceModelUtils.getJavaElementLinkNameForMarker(reference.getTarget()), AOP_MARKER_SEVERITY, reference.getSourceStartLine(), markerId, sourceResource);
            } else {
                AopReferenceModelMarkerUtils.createProblemMarker(sourceResource, "declared on " + AopReferenceModelUtils.getJavaElementLinkNameForMarker(reference.getTarget()), AOP_MARKER_SEVERITY, reference.getDefinition().getAspectStartLineNumber(), markerId, sourceResource);
            }
        } else {
            if (reference.getSource() != null) {
                AopReferenceModelMarkerUtils.createProblemMarker(reference.getSource().getResource(), "advises " + AopReferenceModelUtils.getJavaElementLinkNameForMarker(reference.getTarget()), AOP_MARKER_SEVERITY, reference.getSourceStartLine(), markerId, sourceResource);
            }
            AopReferenceModelMarkerUtils.createProblemMarker(reference.getDefinition().getResource(), "advises " + AopReferenceModelUtils.getJavaElementLinkNameForMarker(reference.getTarget()), AOP_MARKER_SEVERITY, reference.getDefinition().getAspectStartLineNumber(), markerId, sourceResource);
        }
    }

    public static void deleteProblemMarkers(IResource resource) {
        IJavaProject jp;
        if (resource != null && resource.isAccessible()) {
            try {
                IMarker[] markers;
                resource.getProject().deleteMarkers(AOP_PROBLEM_MARKER, true, 2);
                IProject project = resource.getProject();
                String resourceName = resource.getFullPath().toString();
                IMarker[] iMarkerArray = markers = project.findMarkers(AOP_MARKER, true, 2);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    String sourceResourceName = marker.getAttribute(SOURCE_RESOURCE, "");
                    if (sourceResourceName != null && sourceResourceName.startsWith(resourceName)) {
                        marker.delete();
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                SpringCore.log((Throwable)e);
            }
        }
        if ((jp = JdtUtils.getJavaProject((IResource)resource)) != null) {
            List jps = JdtUtils.getAllDependingJavaProjects((IJavaProject)jp);
            for (IJavaProject p : jps) {
                try {
                    IMarker[] markers;
                    IProject project = p.getProject();
                    String resourceName = resource.getFullPath().toString();
                    IMarker[] iMarkerArray = markers = project.findMarkers(AOP_MARKER, true, 2);
                    int n = markers.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IMarker marker = iMarkerArray[n3];
                        String sourceResourceName = marker.getAttribute(SOURCE_RESOURCE, "");
                        if (resourceName.equals(sourceResourceName)) {
                            marker.delete();
                        }
                        ++n3;
                    }
                }
                catch (CoreException e) {
                    SpringCore.log((Throwable)e);
                }
            }
        }
    }

    public static void createProblemMarker(IResource resource, String message, int severity, int line, String markerId, IResource sourceResource) {
        AopReferenceModelMarkerUtils.createProblemMarker(resource, message, severity, line, markerId, 1, sourceResource);
    }

    public static void createProblemMarker(IResource resource, String message, int severity, int line, String markerId, int markerCount, IResource sourceResource) {
        if (resource != null && resource.isAccessible()) {
            try {
                int l;
                IMarker marker;
                int n;
                int n2;
                IMarker[] iMarkerArray;
                IMarker[] markers;
                if (severity == 2) {
                    iMarkerArray = markers = resource.findMarkers(AOP_PROBLEM_MARKER, true, 0);
                    n2 = markers.length;
                    n = 0;
                    while (n < n2) {
                        marker = iMarkerArray[n];
                        l = marker.getAttribute("lineNumber", -1);
                        String msg = marker.getAttribute("message", "");
                        if (l == line && message.equals(msg)) {
                            return;
                        }
                        ++n;
                    }
                }
                iMarkerArray = markers = resource.findMarkers(AOP_MARKER, true, 0);
                n2 = markers.length;
                n = 0;
                while (n < n2) {
                    marker = iMarkerArray[n];
                    l = marker.getAttribute("lineNumber", -1);
                    int count = marker.getAttribute(MARKER_COUNT, 1);
                    String msg = marker.getAttribute("message", "");
                    ++count;
                    if (l == line && message != null && message.equals(msg) && marker.getType() == markerId) {
                        return;
                    }
                    if (l == line && marker.getType() != markerId) {
                        resource.findMarker(marker.getId()).delete();
                        AopReferenceModelMarkerUtils.createProblemMarker(resource, String.valueOf(count) + " Spring AOP marker at this line", AOP_MARKER_SEVERITY, line, AOP_MARKER, count, sourceResource);
                        return;
                    }
                    if (l == line && marker.getType() == markerId) {
                        marker.setAttribute("message", (Object)(String.valueOf(count) + " Spring AOP marker at this line"));
                        marker.setAttribute(MARKER_COUNT, count);
                        return;
                    }
                    ++n;
                }
                marker = resource.createMarker(markerId);
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("message", message);
                attributes.put("severity", new Integer(severity));
                attributes.put(MARKER_COUNT, markerCount);
                if (sourceResource != null) {
                    attributes.put(SOURCE_RESOURCE, sourceResource.getFullPath().toString());
                }
                if (line > 0) {
                    attributes.put("lineNumber", new Integer(line));
                }
                marker.setAttributes(attributes);
            }
            catch (CoreException e) {
                SpringCore.log((Throwable)e);
            }
        }
    }
}

