/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.logging;

import java.util.HashMap;
import java.util.Map;
import org.springframework.ide.eclipse.aop.core.logging.IAopLogger;

public class AopLog {
    public static final int DEFAULT = 0;
    public static final int BUILDER = 1;
    public static final int BUILDER_CLASSPATH = 2;
    public static final int BUILDER_PROGRESS = 3;
    public static final int BUILDER_MESSAGES = 4;
    private static IAopLogger logger;
    private static Map<String, Long> timers;

    static {
        timers = new HashMap<String, Long>();
    }

    public static void log(String msg) {
        AopLog.log(0, msg);
    }

    public static void log(int category, String msg) {
        if (logger != null) {
            logger.log(category, msg);
        } else {
            System.out.println(msg);
        }
    }

    public static void logStart(String event) {
        Long now = new Long(System.currentTimeMillis());
        timers.put(event, now);
    }

    public static void logEnd(int category, String event) {
        AopLog.logEnd(category, event, null);
    }

    public static void logEnd(int category, String event, String optional_msg) {
        Long then = timers.get(event);
        if (then != null) {
            long now = System.currentTimeMillis();
            long elapsed = now - then;
            if (optional_msg != null && optional_msg.length() > 0) {
                AopLog.log(category, "Timer event: " + elapsed + "ms: " + event + " (" + optional_msg + ")");
            } else {
                AopLog.log(category, "Timer event: " + elapsed + "ms: " + event);
            }
            timers.remove(event);
        }
    }

    public static void setLogger(IAopLogger l) {
        logger = l;
    }
}

