/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.ide.eclipse.aop.core.Activator;
import org.springframework.ide.eclipse.aop.core.internal.model.BeanAspectDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.BeanIntroductionDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.JavaAdvisorDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.builder.AbstractAspectDefinitionBuilder;
import org.springframework.ide.eclipse.aop.core.logging.AopLog;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.core.model.builder.IAspectDefinitionBuilder;
import org.springframework.ide.eclipse.aop.core.model.builder.IDocumentFactory;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.ClassUtils;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlAspectDefinitionBuilder
extends AbstractAspectDefinitionBuilder
implements IAspectDefinitionBuilder {
    private static final String ADVICE_REF_ATTRIBUTE = "advice-ref";
    private static final String ADVISOR_ELEMENT = "advisor";
    private static final String AFTER_ELEMENT = "after";
    private static final String AFTER_RETURNING_ELEMENT = "after-returning";
    private static final String AFTER_THROWING_ELEMENT = "after-throwing";
    private static final String AOP_NAMESPACE_URI = "http://www.springframework.org/schema/aop";
    private static final String ARG_NAMES_ATTRIBUTE = "arg-names";
    private static final String AROUND_ELEMENT = "around";
    private static final String ASPECT_ELEMENT = "aspect";
    private static final String BEFORE_ELEMENT = "before";
    private static final String CONFIG_ELEMENT = "config";
    private static final String DECLARE_PARENTS_ELEMENT = "declare-parents";
    private static final String DEFAULT_IMPL_ATTRIBUTE = "default-impl";
    private static final String DELEGATE_REF_ATTRIBUTE = "delegate-ref";
    private static final String EXPRESSION_ATTRIBUTE = "expression";
    private static final String ID_ATTRIBUTE = "id";
    private static final String IMPLEMENT_INTERFACE_ATTRIBUTE = "implement-interface";
    private static final String METHOD_ATTRIBUTE = "method";
    private static final String POINTCUT_ELEMENT = "pointcut";
    private static final String POINTCUT_REF_ATTRIBUTE = "pointcut-ref";
    private static final String PROXY_TARGET_CLASS_ATTRIBUTE = "proxy-target-class";
    private static final String RETURNING_ATTRIBUTE = "returning";
    private static final String THROWING_ATTRIBUTE = "throwing";
    private static final String TYPES_MATCHING_ATTRIBUTE = "types-matching";

    @Override
    public void buildAspectDefinitions(List<IAspectDefinition> aspectInfos, IFile file, IProjectClassLoaderSupport classLoaderSupport, IDocumentFactory factory) {
        if (file.getFileExtension() != null && file.getFileExtension().equals("xml")) {
            this.parseAopConfigElement(factory.createDocument(file), file, aspectInfos, classLoaderSupport);
        }
    }

    private void addAspectDefinition(IAspectDefinition info, List<IAspectDefinition> aspectInfos) {
        AopLog.log(4, info.toString());
        aspectInfos.add(info);
    }

    private String getPointcut(Node aspectNode, Map<String, String> rootPointcuts, Map<String, String> pointcuts) {
        String pointcutAttribute = this.getAttribute(aspectNode, POINTCUT_ELEMENT);
        String pointcutRef = this.getAttribute(aspectNode, POINTCUT_REF_ATTRIBUTE);
        String pointcut = !StringUtils.hasText((String)pointcutAttribute) ? (pointcuts.containsKey(pointcutRef) ? pointcuts.get(pointcutRef) : rootPointcuts.get(pointcutRef)) : pointcutAttribute;
        return pointcut;
    }

    private void parseAdvisorElement(final IFile file, final Node aspectNode, Map<String, String> rootPointcuts, final List<IAspectDefinition> aspectInfos, IProjectClassLoaderSupport classLoaderSupport) {
        final String beanRef = this.getAttribute(aspectNode, ADVICE_REF_ATTRIBUTE);
        final String className = BeansEditorUtils.getClassNameForBean((IFile)file, (Document)aspectNode.getOwnerDocument(), (String)beanRef);
        if (StringUtils.hasText((String)className)) {
            NodeList aspectChildren = aspectNode.getParentNode().getChildNodes();
            HashMap<String, String> pointcuts = new HashMap<String, String>();
            this.parsePointcuts(pointcuts, aspectChildren);
            final String pointcutExpression = this.getPointcut(aspectNode, rootPointcuts, pointcuts);
            try {
                classLoaderSupport.executeCallback(new IProjectClassLoaderSupport.IProjectClassLoaderAwareCallback(){

                    public void doWithActiveProjectClassLoader() throws Throwable {
                        JavaAdvisorDefinition info;
                        Class advisorClass = ClassUtils.loadClass((String)className);
                        if (ClassUtils.loadClass(MethodInterceptor.class).isAssignableFrom(advisorClass)) {
                            info = XmlAspectDefinitionBuilder.this.prepareJavaAdvisorDefinition(file, aspectNode, beanRef, className, pointcutExpression);
                            info.setType(IAopReference.ADVICE_TYPE.AROUND);
                            info.setAdviceMethodName("invoke");
                            info.setAdviceMethodParameterTypes(new String[]{MethodInvocation.class.getName()});
                            XmlAspectDefinitionBuilder.this.addAspectDefinition(info, aspectInfos);
                        }
                        if (ClassUtils.loadClass(MethodBeforeAdvice.class).isAssignableFrom(advisorClass)) {
                            info = XmlAspectDefinitionBuilder.this.prepareJavaAdvisorDefinition(file, aspectNode, beanRef, className, pointcutExpression);
                            info.setType(IAopReference.ADVICE_TYPE.BEFORE);
                            info.setAdviceMethodName(XmlAspectDefinitionBuilder.BEFORE_ELEMENT);
                            info.setAdviceMethodParameterTypes(new String[]{Method.class.getName(), Object[].class.getName(), Object.class.getName()});
                            XmlAspectDefinitionBuilder.this.addAspectDefinition(info, aspectInfos);
                        }
                        if (ClassUtils.loadClass(ThrowsAdvice.class).isAssignableFrom(advisorClass)) {
                            info = XmlAspectDefinitionBuilder.this.prepareJavaAdvisorDefinition(file, aspectNode, beanRef, className, pointcutExpression);
                            info.setType(IAopReference.ADVICE_TYPE.AFTER_THROWING);
                            info.setAdviceMethodName("afterThrowing");
                            info.setAdviceMethodParameterTypes(new String[]{Method.class.getName(), Object[].class.getName(), Object.class.getName(), Exception.class.getName()});
                            XmlAspectDefinitionBuilder.this.addAspectDefinition(info, aspectInfos);
                        }
                        if (ClassUtils.loadClass(AfterReturningAdvice.class).isAssignableFrom(advisorClass)) {
                            info = XmlAspectDefinitionBuilder.this.prepareJavaAdvisorDefinition(file, aspectNode, beanRef, className, pointcutExpression);
                            info.setType(IAopReference.ADVICE_TYPE.AFTER_RETURNING);
                            info.setAdviceMethodName("afterReturning");
                            info.setAdviceMethodParameterTypes(new String[]{Object.class.getName(), Method.class.getName(), Object[].class.getName(), Object.class.getName()});
                            XmlAspectDefinitionBuilder.this.addAspectDefinition(info, aspectInfos);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                AopLog.log(4, Activator.getFormattedMessage("AspectDefinitionBuilder.exceptionOnAdvisorNode", aspectNode));
            }
        }
    }

    private void parseAopConfigElement(IDOMDocument document, IFile file, List<IAspectDefinition> aspectInfos, IProjectClassLoaderSupport classLoaderSupport) {
        if (document == null || document.getStructuredDocument() == null) {
            return;
        }
        NodeList list = document.getDocumentElement().getElementsByTagNameNS(AOP_NAMESPACE_URI, CONFIG_ELEMENT);
        int i = 0;
        while (i < list.getLength()) {
            boolean proxyTargetClass;
            ArrayList<IAspectDefinition> aspectDefinitions = new ArrayList<IAspectDefinition>();
            HashMap<String, String> rootPointcuts = new HashMap<String, String>();
            Node node = list.item(i);
            NodeList children = node.getChildNodes();
            this.parsePointcuts(rootPointcuts, children);
            int j = 0;
            while (j < children.getLength()) {
                Node child = children.item(j);
                if (ASPECT_ELEMENT.equals(child.getLocalName())) {
                    this.parseAspectElement(file, child, rootPointcuts, aspectDefinitions);
                } else if (ADVISOR_ELEMENT.equals(child.getLocalName())) {
                    this.parseAdvisorElement(file, child, rootPointcuts, aspectDefinitions, classLoaderSupport);
                }
                ++j;
            }
            if (node.getAttributes().getNamedItem(PROXY_TARGET_CLASS_ATTRIBUTE) != null && (proxyTargetClass = Boolean.valueOf(node.getAttributes().getNamedItem(PROXY_TARGET_CLASS_ATTRIBUTE).getNodeValue()).booleanValue())) {
                for (IAspectDefinition def : aspectDefinitions) {
                    ((BeanAspectDefinition)def).setProxyTargetClass(proxyTargetClass);
                }
            }
            aspectInfos.addAll(aspectDefinitions);
            ++i;
        }
    }

    private void parseAspectElement(IFile file, Node child, Map<String, String> rootPointcuts, List<IAspectDefinition> aspectInfos) {
        String beanRef = this.getAttribute(child, "ref");
        String className = BeansEditorUtils.getClassNameForBean((IFile)file, (Document)child.getOwnerDocument(), (String)beanRef);
        NodeList aspectChildren = child.getChildNodes();
        HashMap<String, String> pointcuts = new HashMap<String, String>();
        this.parsePointcuts(pointcuts, aspectChildren);
        int g = 0;
        while (g < aspectChildren.getLength()) {
            Node aspectNode = aspectChildren.item(g);
            BeanAspectDefinition info = null;
            if (DECLARE_PARENTS_ELEMENT.equals(aspectNode.getLocalName())) {
                String typesMatching = this.getAttribute(aspectNode, TYPES_MATCHING_ATTRIBUTE);
                String defaultImpl = this.getAttribute(aspectNode, DEFAULT_IMPL_ATTRIBUTE);
                String implementInterface = this.getAttribute(aspectNode, IMPLEMENT_INTERFACE_ATTRIBUTE);
                String delegateRef = this.getAttribute(aspectNode, DELEGATE_REF_ATTRIBUTE);
                if (StringUtils.hasText((String)typesMatching) && (StringUtils.hasText((String)defaultImpl) || StringUtils.hasText((String)delegateRef)) && StringUtils.hasText((String)implementInterface)) {
                    Node delegateBean;
                    info = new BeanIntroductionDefinition();
                    ((BeanIntroductionDefinition)info).setIntroducedInterfaceName(implementInterface);
                    ((BeanIntroductionDefinition)info).setTypePattern(typesMatching);
                    if (StringUtils.hasText((String)delegateRef) && (delegateBean = BeansEditorUtils.getFirstReferenceableNodeById((Document)aspectNode.getOwnerDocument(), (String)delegateRef, (IFile)file)) != null) {
                        defaultImpl = BeansEditorUtils.getClassNameForBean((Node)delegateBean);
                    }
                    ((BeanIntroductionDefinition)info).setDefaultImplName(defaultImpl);
                    ((BeanIntroductionDefinition)info).setAspectClassName(defaultImpl);
                    ((BeanIntroductionDefinition)info).setAspectName(beanRef);
                    this.extractLineNumbers(info, (IDOMNode)aspectNode);
                }
            } else if (StringUtils.hasText((String)className)) {
                if (BEFORE_ELEMENT.equals(aspectNode.getLocalName())) {
                    info = this.repareBeanAspectDefinition(pointcuts, rootPointcuts, aspectNode, IAopReference.ADVICE_TYPE.BEFORE);
                } else if (AROUND_ELEMENT.equals(aspectNode.getLocalName())) {
                    info = this.repareBeanAspectDefinition(pointcuts, rootPointcuts, aspectNode, IAopReference.ADVICE_TYPE.AROUND);
                } else if (AFTER_ELEMENT.equals(aspectNode.getLocalName())) {
                    info = this.repareBeanAspectDefinition(pointcuts, rootPointcuts, aspectNode, IAopReference.ADVICE_TYPE.AFTER);
                } else if (AFTER_RETURNING_ELEMENT.equals(aspectNode.getLocalName())) {
                    info = this.repareBeanAspectDefinition(pointcuts, rootPointcuts, aspectNode, IAopReference.ADVICE_TYPE.AFTER_RETURNING);
                    String returning = this.getAttribute(aspectNode, RETURNING_ATTRIBUTE);
                    info.setReturning(returning);
                } else if (AFTER_THROWING_ELEMENT.equals(aspectNode.getLocalName())) {
                    info = this.repareBeanAspectDefinition(pointcuts, rootPointcuts, aspectNode, IAopReference.ADVICE_TYPE.AFTER_THROWING);
                    String throwing = this.getAttribute(aspectNode, THROWING_ATTRIBUTE);
                    info.setThrowing(throwing);
                } else if (AROUND_ELEMENT.equals(aspectNode.getLocalName())) {
                    info = this.repareBeanAspectDefinition(pointcuts, rootPointcuts, aspectNode, IAopReference.ADVICE_TYPE.AROUND);
                }
            }
            if (info != null) {
                if (info.getAspectClassName() == null) {
                    info.setAspectClassName(className);
                }
                info.setAspectName(beanRef);
                info.setResource((IResource)file);
                this.addAspectDefinition(info, aspectInfos);
            }
            ++g;
        }
    }

    private void parsePointcuts(Map<String, String> rootPointcuts, NodeList children) {
        int j = 0;
        while (j < children.getLength()) {
            Node child = children.item(j);
            if (POINTCUT_ELEMENT.equals(child.getLocalName())) {
                String id = this.getAttribute(child, ID_ATTRIBUTE);
                String expression = this.getAttribute(child, EXPRESSION_ATTRIBUTE);
                if (StringUtils.hasText((String)id) && StringUtils.hasText((String)expression)) {
                    rootPointcuts.put(id, expression);
                }
            }
            ++j;
        }
    }

    private JavaAdvisorDefinition prepareJavaAdvisorDefinition(IFile file, Node aspectNode, String beanRef, String className, String pointcutExpression) {
        JavaAdvisorDefinition info = new JavaAdvisorDefinition();
        this.extractLineNumbers(info, (IDOMNode)aspectNode);
        info.setPointcutExpression(pointcutExpression);
        info.setAspectClassName(className);
        info.setAspectName(beanRef);
        info.setResource((IResource)file);
        return info;
    }

    private BeanAspectDefinition repareBeanAspectDefinition(Map<String, String> pointcuts, Map<String, String> rootPointcuts, Node aspectNode, IAopReference.ADVICE_TYPE type) {
        BeanAspectDefinition info = new BeanAspectDefinition();
        String pointcut = this.getAttribute(aspectNode, POINTCUT_ELEMENT);
        String pointcutRef = this.getAttribute(aspectNode, POINTCUT_REF_ATTRIBUTE);
        if (!StringUtils.hasText((String)pointcut) && !StringUtils.hasText((String)(pointcut = pointcuts.get(pointcutRef)))) {
            pointcut = rootPointcuts.get(pointcutRef);
        }
        String argNames = this.getAttribute(aspectNode, ARG_NAMES_ATTRIBUTE);
        String method = this.getAttribute(aspectNode, METHOD_ATTRIBUTE);
        String[] argNamesArray = null;
        if (argNames != null) {
            argNamesArray = StringUtils.commaDelimitedListToStringArray((String)argNames);
        }
        info.setArgNames(argNamesArray);
        this.extractLineNumbers(info, (IDOMNode)aspectNode);
        info.setPointcutExpression(pointcut);
        info.setType(type);
        info.setAdviceMethodName(method);
        return info;
    }
}

