/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model;

import org.eclipse.ui.IMemento;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.aspectj.TypePatternClassFilter;
import org.springframework.aop.support.ClassFilters;
import org.springframework.ide.eclipse.aop.core.internal.model.BeanAspectDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.BeanIntroductionDefinitionElementFactory;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IIntroductionDefinition;

public class BeanIntroductionDefinition
extends BeanAspectDefinition
implements IIntroductionDefinition {
    private String defaultImplName;
    private String introducedInterfaceName;
    private String typePattern;
    private ClassFilter typePatternClassFilter;

    public BeanIntroductionDefinition() {
        this.setType(IAopReference.ADVICE_TYPE.DECLARE_PARENTS);
    }

    public String getAdviceMethodName() {
        throw new IllegalArgumentException();
    }

    public String getDefaultImplName() {
        return this.defaultImplName;
    }

    public String getFactoryId() {
        return BeanIntroductionDefinitionElementFactory.FACTORY_ID;
    }

    public String getImplInterfaceName() {
        return this.introducedInterfaceName;
    }

    public IAopReference.ADVICE_TYPE getType() {
        return IAopReference.ADVICE_TYPE.DECLARE_PARENTS;
    }

    public ClassFilter getTypeMatcher() {
        if (this.typePatternClassFilter == null) {
            TypePatternClassFilter typePatternFilter = new TypePatternClassFilter(this.typePattern);
            ClassFilter exclusion = new ClassFilter(){

                public boolean matches(Class clazz) {
                    try {
                        Class<?> implInterfaceClass = Thread.currentThread().getContextClassLoader().loadClass(BeanIntroductionDefinition.this.introducedInterfaceName);
                        return !implInterfaceClass.isAssignableFrom(clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return false;
                    }
                }
            };
            this.typePatternClassFilter = ClassFilters.intersection((ClassFilter)typePatternFilter, (ClassFilter)exclusion);
        }
        return this.typePatternClassFilter;
    }

    public String getTypePattern() {
        return this.typePattern;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("introduced-interface-name", this.introducedInterfaceName);
        memento.putString("default-impl-name", this.defaultImplName);
        memento.putString("type-pattern", this.typePattern);
    }

    public void setDefaultImplName(String defaultImplName) {
        this.defaultImplName = defaultImplName;
    }

    public void setIntroducedInterfaceName(String introducedInterfaceName) {
        this.introducedInterfaceName = introducedInterfaceName;
    }

    public void setTypePattern(String typePattern) {
        this.typePattern = typePattern;
    }
}

