/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.namespaces;

import java.util.Collections;
import java.util.List;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.xsd.XSDAttributeUse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ToolAnnotationUtils {
    public static final String ASSIGNABLE_TO_ELEMENT = "assignable-to";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String EXPECTED_TYPE_ELEMENT = "expected-type";
    public static final String EXPECTED_METHOD_ELEMENT = "expected-method";
    public static final String TYPE_REF_ATTRIBUTE = "type-ref";
    public static final String EXPRESSION_ATTRIBUTE = "expression";
    public static final String RESTRITION_ATTRIBUTE = "restriction";
    public static final String KIND_ATTRIBUTE = "kind";
    public static final String TOOL_NAMESPACE_URI = "http://www.springframework.org/schema/tool";
    public static final String ANNOTATION_ELEMENT = "annotation";

    protected static CMElementDeclaration getCMElementDeclaration(Node node) {
        ModelQuery modelQuery;
        CMElementDeclaration result = null;
        if (node.getNodeType() == 1 && (modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument())) != null) {
            result = modelQuery.getCMElementDeclaration((Element)node);
        }
        return result;
    }

    public static List<Element> getApplicationInformationElements(Node node, String attributeName) {
        try {
            CMElementDeclaration elementDecl = ToolAnnotationUtils.getCMElementDeclaration(node);
            CMAttributeDeclaration attrDecl = null;
            if (elementDecl != null) {
                CMNamedNodeMap attributes = elementDecl.getAttributes();
                String noprefixName = DOMNamespaceHelper.getUnprefixedName((String)attributeName);
                if (attributes != null && (attrDecl = (CMAttributeDeclaration)attributes.getNamedItem(noprefixName)) == null) {
                    attrDecl = (CMAttributeDeclaration)attributes.getNamedItem(attributeName);
                }
                if (attrDecl instanceof XSDImpl.XSDAttributeUseAdapter) {
                    XSDAttributeUse attribute = (XSDAttributeUse)((XSDImpl.XSDAttributeUseAdapter)attrDecl).getKey();
                    if (attribute.getAttributeDeclaration() != null && attribute.getAttributeDeclaration().getAnnotation() != null && attribute.getAttributeDeclaration().getAnnotation().getApplicationInformation() != null) {
                        return attribute.getAttributeDeclaration().getAnnotation().getApplicationInformation();
                    }
                    if (attribute.getAttributeDeclaration() != null && attribute.getAttributeDeclaration().getTypeDefinition() != null && attribute.getAttributeDeclaration().getTypeDefinition().getAnnotation() != null && attribute.getAttributeDeclaration().getTypeDefinition().getAnnotation().getApplicationInformation() != null) {
                        return attribute.getAttributeDeclaration().getTypeDefinition().getAnnotation().getApplicationInformation();
                    }
                }
            }
        }
        catch (Exception exception) {}
        return Collections.emptyList();
    }

    public static ToolAnnotationData getToolAnnotationData(Node annotation) {
        ToolAnnotationData data = new ToolAnnotationData();
        data.setKind(ToolAnnotationUtils.getAttribute(annotation, KIND_ATTRIBUTE));
        NodeList children = annotation.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (EXPECTED_TYPE_ELEMENT.equals(child.getLocalName()) && TOOL_NAMESPACE_URI.equals(child.getNamespaceURI())) {
                data.setExpectedType(ToolAnnotationUtils.getAttribute(child, TYPE_ATTRIBUTE));
            } else if (ASSIGNABLE_TO_ELEMENT.equals(child.getLocalName()) && TOOL_NAMESPACE_URI.equals(child.getNamespaceURI())) {
                data.setAssignableTo(ToolAnnotationUtils.getAttribute(child, TYPE_ATTRIBUTE));
                data.setAssignableToRestriction(ToolAnnotationUtils.getAttribute(child, RESTRITION_ATTRIBUTE));
            } else if (EXPECTED_METHOD_ELEMENT.equals(child.getLocalName()) && TOOL_NAMESPACE_URI.equals(child.getNamespaceURI())) {
                data.setExpectedMethodType(ToolAnnotationUtils.getAttribute(child, TYPE_ATTRIBUTE));
                data.setExpectedMethodRef(ToolAnnotationUtils.getAttribute(child, TYPE_REF_ATTRIBUTE));
                data.setExpectedMethodExpression(ToolAnnotationUtils.getAttribute(child, EXPRESSION_ATTRIBUTE));
            }
            ++i;
        }
        return data;
    }

    private static final String getAttribute(Node node, String attributeName) {
        if (ToolAnnotationUtils.hasAttribute(node, attributeName)) {
            return node.getAttributes().getNamedItem(attributeName).getNodeValue();
        }
        return null;
    }

    private static final boolean hasAttribute(Node node, String attributeName) {
        return node != null && node.hasAttributes() && node.getAttributes().getNamedItem(attributeName) != null;
    }

    public static class ToolAnnotationData {
        private String kind;
        private String assignableTo;
        private String assignableToRestriction;
        private String expectedType;
        private String expectedMethodType;
        private String expectedMethodRef;
        private String expectedMethodExpression;

        public String getKind() {
            return this.kind;
        }

        public String getAssignableTo() {
            return this.assignableTo;
        }

        public String getExpectedType() {
            return this.expectedType;
        }

        public String getAssignableToRestriction() {
            return this.assignableToRestriction;
        }

        public void setAssignableToRestriction(String assignableToRestriction) {
            this.assignableToRestriction = assignableToRestriction;
        }

        public String getExpectedMethodType() {
            return this.expectedMethodType;
        }

        public void setExpectedMethodType(String expectedMethodType) {
            this.expectedMethodType = expectedMethodType;
        }

        public String getExpectedMethodRef() {
            return this.expectedMethodRef;
        }

        public void setExpectedMethodRef(String expectedMethodRef) {
            this.expectedMethodRef = expectedMethodRef;
        }

        public String getExpectedMethodExpression() {
            return this.expectedMethodExpression;
        }

        public void setExpectedMethodExpression(String expectedMethodExpression) {
            this.expectedMethodExpression = expectedMethodExpression;
        }

        public void setKind(String kind) {
            this.kind = kind;
        }

        public void setAssignableTo(String assignableTo) {
            this.assignableTo = assignableTo;
        }

        public void setExpectedType(String expectedType) {
            this.expectedType = expectedType;
        }
    }
}

