/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.model.validation;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.BeansValidationContext;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.beans.core.model.validation.IXmlValidationContext;
import org.springframework.ide.eclipse.beans.core.namespaces.ToolAnnotationUtils;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinition;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.core.type.asm.ClassReaderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlValidationRule
implements IValidationRule<IBeansModelElement, IBeansValidationContext> {
    public final boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof IBeansConfig || element instanceof IBeansImport && ((IBeansImport)element).getImportedBeansConfigs().size() > 0;
    }

    public final void validate(IBeansModelElement element, IBeansValidationContext context, IProgressMonitor monitor) {
        if (element instanceof IBeansConfig) {
            this.validateBeansConfig((IBeansConfig)element, context);
        } else if (element instanceof IBeansImport) {
            for (IImportedBeansConfig beansConfig : ((IBeansImport)element).getImportedBeansConfigs()) {
                this.validateBeansConfig(beansConfig, context);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateBeansConfig(IBeansConfig element, IBeansValidationContext context) {
        if (element.isExternal()) {
            return;
        }
        if (!(context instanceof BeansValidationContext)) {
            return;
        }
        IStructuredModel model = null;
        try {
            try {
                IDOMDocument document;
                model = StructuredModelManager.getModelManager().getModelForRead((IFile)element.getElementResource());
                if (model == null || (document = ((DOMModelImpl)model).getDocument()) == null || document.getDocumentElement() == null) return;
                DomVisitor visitor = new DomVisitor(context, element){
                    private IXmlValidationContext xmlContext;
                    {
                        this.xmlContext = new XmlValidationContext((BeansValidationContext)iBeansValidationContext, iBeansConfig);
                    }

                    public void validateNode(Node n) {
                        AbstractXmlValidationRule.this.validate(n, this.xmlContext);
                    }

                    public boolean supportsNode(Node n) {
                        return AbstractXmlValidationRule.this.supports(n);
                    }
                };
                visitor.visit((Document)document);
                return;
            }
            catch (IOException e) {
                BeansCorePlugin.log(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (CoreException e) {
                BeansCorePlugin.log(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    protected abstract boolean supports(Node var1);

    protected abstract void validate(Node var1, IXmlValidationContext var2);

    private static abstract class DomVisitor {
        private DomVisitor() {
        }

        public void visit(Document dom) {
            if (this.supportsNode(dom)) {
                this.validateNode(dom);
            }
            this.visit(dom.getDocumentElement());
        }

        public void visit(Element e) {
            NodeList lst = e.getChildNodes();
            int len = lst.getLength();
            int i = 0;
            while (i < len) {
                Node n = lst.item(i);
                if (this.supportsNode(n)) {
                    this.validateNode(n);
                }
                if (n.getNodeType() == 1) {
                    this.visit((Element)n);
                }
                ++i;
            }
        }

        public abstract void validateNode(Node var1);

        public abstract boolean supportsNode(Node var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XmlValidationContext
    implements IXmlValidationContext {
        private final IBeansConfig beansConfig;
        private final BeansValidationContext delegateContext;

        public XmlValidationContext(BeansValidationContext delegateContext, IBeansConfig beansConfig) {
            this.delegateContext = delegateContext;
            this.beansConfig = beansConfig;
        }

        @Override
        public ClassReaderFactory getClassReaderFactory() {
            return this.delegateContext.getClassReaderFactory();
        }

        @Override
        public BeanDefinitionRegistry getCompleteRegistry() {
            return this.delegateContext.getCompleteRegistry();
        }

        @Override
        public BeanDefinitionRegistry getIncompleteRegistry() {
            return this.delegateContext.getIncompleteRegistry();
        }

        @Override
        public Set<BeanDefinition> getRegisteredBeanDefinition(String beanName, String beanClass) {
            return this.delegateContext.getRegisteredBeanDefinition(beanName, beanClass);
        }

        @Override
        public IProject getRootElementProject() {
            return this.delegateContext.getRootElementProject();
        }

        @Override
        public IResource getRootElementResource() {
            return this.delegateContext.getRootElementResource();
        }

        @Override
        public boolean isBeanRegistered(String beanName, String beanClass) {
            return this.delegateContext.isBeanRegistered(beanName, beanClass);
        }

        public void error(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
            this.delegateContext.error(element, problemId, message, attributes);
        }

        @Override
        public void error(Node node, String problemId, String message, ValidationProblemAttribute ... attributes) {
            this.delegateContext.error(this.getResourceModelElementFromNode(node), problemId, message, attributes);
        }

        public IResourceModelElement getContextElement() {
            return this.delegateContext.getContextElement();
        }

        public Set<ValidationProblem> getProblems() {
            return this.delegateContext.getProblems();
        }

        public IResourceModelElement getRootElement() {
            return this.delegateContext.getRootElement();
        }

        public void info(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
            this.delegateContext.info(element, problemId, message, attributes);
        }

        @Override
        public void info(Node n, String problemId, String message, ValidationProblemAttribute ... attributes) {
            this.delegateContext.info(this.getResourceModelElementFromNode(n), problemId, message, attributes);
        }

        public void setCurrentRuleDefinition(ValidationRuleDefinition ruleDefinition) {
            this.delegateContext.setCurrentRuleDefinition(ruleDefinition);
        }

        public void warning(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
            this.delegateContext.warning(element, problemId, message, attributes);
        }

        @Override
        public void warning(Node n, String problemId, String message, ValidationProblemAttribute ... attributes) {
            this.delegateContext.warning(this.getResourceModelElementFromNode(n), problemId, message, attributes);
        }

        @Override
        public List<ToolAnnotationUtils.ToolAnnotationData> getToolAnnotation(Node n, String attributeName) {
            return this.delegateContext.getToolAnnotation(n, attributeName);
        }

        private IResourceModelElement getResourceModelElementFromNode(Node n) {
            int endLine;
            IDOMNode domNode;
            int startLine;
            IModelElement modelElement;
            if (n instanceof IDOMNode && (modelElement = BeansModelUtils.getMostSpecificModelElement(startLine = (domNode = (IDOMNode)n).getStructuredDocument().getLineOfOffset(domNode.getStartOffset()) + 1, endLine = domNode.getStructuredDocument().getLineOfOffset(domNode.getStartOffset()) + 1, (IFile)this.beansConfig.getElementResource(), null)) instanceof IResourceModelElement) {
                return (IResourceModelElement)modelElement;
            }
            return this.delegateContext.getRootElement();
        }

        @Override
        public IProjectClassLoaderSupport getProjectClassLoaderSupport() {
            return this.delegateContext.getProjectClassLoaderSupport();
        }

        public void addProblems(ValidationProblem ... problems) {
            this.delegateContext.addProblems(problems);
        }
    }
}

