/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.model.locate;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.DelegatingNamespaceHandlerResolver;
import org.springframework.ide.eclipse.beans.core.model.locate.AbstractJavaProjectPathMatchingBeansConfigLocator;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectScanningBeansConfigLocator
extends AbstractJavaProjectPathMatchingBeansConfigLocator {
    private String ALLOWED_FILE_PATTERN = "**/*";
    private Map<IProject, NamespaceHandlerResolver> namespaceResoverCache = new HashMap<IProject, NamespaceHandlerResolver>();
    private Set<String> configuredFilePatterns = new ConcurrentSkipListSet<String>();
    private Set<String> configuredFileExtensions = new ConcurrentSkipListSet<String>();
    private IProject project = null;

    public ProjectScanningBeansConfigLocator(String configuredFileSuffixes) {
        String[] stringArray = StringUtils.commaDelimitedListToStringArray((String)configuredFileSuffixes);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filePattern = stringArray[n2];
            int ix = (filePattern = filePattern.trim()).lastIndexOf(46);
            if (ix != -1) {
                this.configuredFileExtensions.add(filePattern.substring(ix + 1));
            } else {
                this.configuredFileExtensions.add(filePattern);
            }
            this.configuredFilePatterns.add(String.valueOf(this.ALLOWED_FILE_PATTERN) + filePattern);
            ++n2;
        }
    }

    @Override
    public boolean requiresRefresh(IFile file) {
        return false;
    }

    @Override
    public boolean supports(IProject project) {
        return SpringCoreUtils.isSpringProject((IResource)project);
    }

    protected NamespaceHandlerResolver getNamespaceHandlerResolver(IProject project) {
        if (!this.namespaceResoverCache.containsKey(project)) {
            this.namespaceResoverCache.put(project, (NamespaceHandlerResolver)new DelegatingNamespaceHandlerResolver(NamespaceHandlerResolver.class.getClassLoader(), null));
        }
        return this.namespaceResoverCache.get(project);
    }

    @Override
    protected Set<IFile> filterMatchingFiles(Set<IFile> files) {
        HashSet<String> outputDirectories = new HashSet<String>();
        IJavaProject javaProject = JdtUtils.getJavaProject((IProject)this.project);
        if (javaProject != null) {
            try {
                outputDirectories.add(javaProject.getOutputLocation().toString());
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && entry.getOutputLocation() != null) {
                        outputDirectories.add(entry.getOutputLocation().toString());
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log(e);
            }
        }
        LinkedHashSet<IFile> detectedFiles = new LinkedHashSet<IFile>();
        for (IFile file : files) {
            boolean skip = false;
            String path = file.getFullPath().toString();
            for (String outputDirectory : outputDirectories) {
                if (!path.startsWith(outputDirectory)) continue;
                skip = true;
            }
            if (skip) continue;
            IStructuredModel model = null;
            try {
                String namespaceUri;
                IDOMDocument document;
                try {
                    model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                }
                catch (RuntimeException runtimeException) {}
                if (model == null) {
                    model = StructuredModelManager.getModelManager().getModelForRead(file);
                }
                if (model != null && (document = ((DOMModelImpl)model).getDocument()) != null && document.getDocumentElement() != null && this.applyNamespaceFilter(file, namespaceUri = document.getDocumentElement().getNamespaceURI())) {
                    detectedFiles.add(file);
                }
            }
            catch (IOException e) {
                BeansCorePlugin.log(e);
                if (model == null) continue;
                model.releaseFromRead();
                continue;
            }
            catch (CoreException e) {
                try {
                    BeansCorePlugin.log(e);
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (model != null) {
                        model.releaseFromRead();
                    }
                }
            }
            if (model == null) continue;
            model.releaseFromRead();
        }
        return detectedFiles;
    }

    protected boolean applyNamespaceFilter(IFile file, String namespaceUri) {
        return namespaceUri != null && ("http://www.springframework.org/schema/beans".equals(namespaceUri) || this.getNamespaceHandlerResolver(file.getProject()).resolve(namespaceUri) != null);
    }

    @Override
    protected Set<String> getAllowedFilePatterns() {
        return this.configuredFilePatterns;
    }

    @Override
    protected Set<String> getAllowedFileExtensions() {
        return this.configuredFileExtensions;
    }

    @Override
    protected Set<IPath> getRootDirectories(IProject project) {
        this.project = project;
        LinkedHashSet<IPath> rootDirectories = new LinkedHashSet<IPath>();
        rootDirectories.add(project.getFullPath());
        return rootDirectories;
    }
}

