/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanReplaceMethodOverride;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.ValidationRuleUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanMethodOverride;
import org.springframework.ide.eclipse.beans.core.model.validation.AbstractNonInfrastructureBeanValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMethodOverrideRule
extends AbstractNonInfrastructureBeanValidationRule
implements IValidationRule<IBeanMethodOverride, IBeansValidationContext> {
    @Override
    protected boolean supportsModelElementForNonInfrastructureBean(IModelElement element, IBeansValidationContext context) {
        return element instanceof IBeanMethodOverride && element.getElementParent() instanceof IBean;
    }

    public void validate(IBeanMethodOverride override, IBeansValidationContext context, IProgressMonitor monitor) {
        IType type;
        IBean bean = (IBean)override.getElementParent();
        AbstractBeanDefinition mergedBd = (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition(bean, (IModelElement)context.getContextElement());
        String mergedClassName = mergedBd.getBeanClassName();
        if (mergedClassName != null && !SpringCoreUtils.hasPlaceHolder((String)mergedClassName) && (type = ValidationRuleUtils.extractBeanClass((BeanDefinition)mergedBd, bean, mergedClassName, context)) != null) {
            if (override.getType() == IBeanMethodOverride.TYPE.LOOKUP) {
                this.validateLookupOverride(override, type, context);
            } else if (override.getType() == IBeanMethodOverride.TYPE.REPLACE) {
                this.validateReplaceOverride(override, type, context);
            }
        }
    }

    private void validateReplaceOverride(IBeanMethodOverride override, IType type, IBeansValidationContext context) {
        if (override instanceof BeanReplaceMethodOverride) {
            String methodName = override.getMethodName();
            try {
                Set methods = Introspector.getAllMethods((IType)type);
                for (IMethod method : methods) {
                    if (!method.getElementName().equals(methodName) || !Flags.isProtected((int)method.getFlags()) && !Flags.isPublic((int)method.getFlags())) continue;
                    return;
                }
                context.error((IResourceModelElement)override, "UNDEFINED_REPLACE_METHOD", "Replace-method '" + methodName + "' not found in bean class '" + type.getFullyQualifiedName() + "'", new ValidationProblemAttribute[0]);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void validateLookupOverride(IBeanMethodOverride override, IType type, IBeansValidationContext context) {
        String methodName = override.getMethodName();
        try {
            Set methods = Introspector.findAllNoParameterMethods((IType)type, (String)methodName);
            for (IMethod method : methods) {
                if (!type.isInterface() && !Flags.isProtected((int)method.getFlags()) && !Flags.isPublic((int)method.getFlags())) continue;
                return;
            }
            context.error((IResourceModelElement)override, "UNDEFINED_LOOKUP_METHOD", "Lookup-method '" + methodName + "' not found in bean class '" + type.getFullyQualifiedName() + "'", new ValidationProblemAttribute[0]);
        }
        catch (JavaModelException javaModelException) {}
    }
}

