/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.AbstractBeanMethodValidationRule;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.scripting.ScriptFactory;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

public class BeanFactoryRule
extends AbstractBeanMethodValidationRule {
    public void validate(IBean bean, IBeansValidationContext context, IProgressMonitor monitor) {
        AbstractBeanDefinition bd = (AbstractBeanDefinition)((Bean)bean).getBeanDefinition();
        BeanDefinition mergedBd = BeansModelUtils.getMergedBeanDefinition(bean, (IModelElement)context.getContextElement());
        String mergedClassName = mergedBd.getBeanClassName();
        if (bd.getFactoryBeanName() != null) {
            if (bd.getFactoryMethodName() == null) {
                context.error((IResourceModelElement)bean, "NO_FACTORY_METHOD", "A factory bean requires a factory method", new ValidationProblemAttribute[0]);
            } else {
                this.validateFactoryBean(bean, bd.getFactoryBeanName(), bd.getFactoryMethodName(), context);
            }
        } else {
            String methodName = bd.getFactoryMethodName();
            try {
                if (methodName != null && mergedClassName != null && !SpringCoreUtils.hasPlaceHolder((String)mergedClassName) && !SpringCoreUtils.hasPlaceHolder((String)methodName)) {
                    int argCount;
                    IType type = JdtUtils.getJavaType((IProject)context.getRootElementProject(), (String)mergedClassName);
                    if (type == null) {
                        return;
                    }
                    int n = argCount = !bd.isAbstract() && bd.getAutowireMode() != 3 ? bd.getConstructorArgumentValues().getArgumentCount() : -1;
                    if (type.isEnum()) {
                        if (!("valueOf".equals(methodName) || argCount != 0 && argCount <= 2)) {
                            this.validateFactoryMethod(bean, mergedClassName, methodName, argCount, Introspector.Static.DONT_CARE, context);
                        }
                    } else {
                        this.validateFactoryMethod(bean, mergedClassName, methodName, argCount, Introspector.Static.YES, context);
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        if (!bd.isAbstract() && bd.getFactoryMethodName() != null && mergedClassName == null && bd.getParentName() == null && bd.getFactoryBeanName() == null) {
            context.error((IResourceModelElement)bean, "BEAN_WITHOUT_CLASS_OR_PARENT", "Factory method needs class from root or parent bean", new ValidationProblemAttribute[0]);
        }
    }

    protected void validateFactoryBean(IBean bean, String beanName, String methodName, IBeansValidationContext context) {
        block7: {
            if (beanName != null && !SpringCoreUtils.hasPlaceHolder((String)beanName)) {
                try {
                    AbstractBeanDefinition factoryBd = (AbstractBeanDefinition)context.getCompleteRegistry().getBeanDefinition(beanName);
                    if (factoryBd.getFactoryBeanName() == null) {
                        if (factoryBd.isAbstract() || factoryBd.getBeanClassName() == null) {
                            context.error((IResourceModelElement)bean, "INVALID_FACTORY_BEAN", "Referenced factory bean '" + beanName + "' is invalid (abstract or no bean class)", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)beanName)});
                        } else if (factoryBd.getFactoryMethodName() == null) {
                            this.validateFactoryMethod(bean, factoryBd.getBeanClassName(), methodName, bean.getConstructorArguments().size() > 0 ? bean.getConstructorArguments().size() : -1, Introspector.Static.NO, context);
                        }
                    }
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (e.getBeanName().equals(bean.getElementName())) break block7;
                    context.error((IResourceModelElement)bean, "UNDEFINED_FACTORY_BEAN", "Factory bean '" + beanName + "' not found", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)beanName)});
                }
            }
        }
    }

    protected void validateFactoryMethod(IBean bean, String className, String methodName, int argCount, Introspector.Static statics, IBeansValidationContext context) {
        IType type;
        if (!(className == null || SpringCoreUtils.hasPlaceHolder((String)className) || (type = JdtUtils.getJavaType((IProject)BeansModelUtils.getProject(bean).getProject(), (String)className)) == null || "aspectOf".equals(methodName) || JdtUtils.doesImplement((IResource)context.getRootElementResource(), (IType)type, (String)FactoryBean.class.getName()) || JdtUtils.doesImplement((IResource)context.getRootElementResource(), (IType)type, (String)ScriptFactory.class.getName()))) {
            this.validateMethod(bean, type, AbstractBeanMethodValidationRule.MethodType.FACTORY, methodName, argCount, statics, context);
        }
    }
}

