/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.validation.AbstractBeanValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

public abstract class AbstractBeanMethodValidationRule
extends AbstractBeanValidationRule {
    protected void validateMethod(IBean bean, IType type, MethodType methodType, String methodName, int argCount, Introspector.Static statics, IBeansValidationContext context) {
        if (methodName != null && !SpringCoreUtils.hasPlaceHolder((String)methodName)) {
            try {
                IMethod method = Introspector.findMethod((IType)type, (String)methodName, (int)argCount, (Introspector.Public)Introspector.Public.DONT_CARE, (Introspector.Static)statics);
                if (method == null) {
                    String className = type.getFullyQualifiedName();
                    if (methodType == MethodType.FACTORY) {
                        context.error((IResourceModelElement)bean, "UNDEFINED_FACTORY_BEAN_METHOD", String.valueOf(statics == Introspector.Static.YES ? "Static" : "Non-static") + " factory method '" + methodName + "' " + (argCount != -1 ? "with " + argCount + " arguments " : "") + "not found in factory bean class '" + className + "'", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)className), new ValidationProblemAttribute("METHOD", (Object)methodName), new ValidationProblemAttribute("BEAN_NAME", (Object)bean.getElementName())});
                    } else if (methodType == MethodType.INIT) {
                        context.error((IResourceModelElement)bean, "UNDEFINED_INIT_METHOD", "Init-method '" + methodName + "' not found in bean class '" + className + "'", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)className), new ValidationProblemAttribute("METHOD", (Object)methodName), new ValidationProblemAttribute("BEAN_NAME", (Object)bean.getElementName())});
                    } else if (methodType == MethodType.DESTROY) {
                        context.error((IResourceModelElement)bean, "UNDEFINED_DESTROY_METHOD", "Destroy-method '" + methodName + "' not found in bean class '" + className + "'", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)className), new ValidationProblemAttribute("METHOD", (Object)methodName), new ValidationProblemAttribute("BEAN_NAME", (Object)bean.getElementName())});
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MethodType {
        FACTORY,
        INIT,
        DESTROY;

    }
}

