/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.namespaces;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.ProjectClasspathNamespaceDefinitionResolver;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinitionResolver;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class ProjectClasspathNamespaceDefinitionResolverCache {
    private static final int CACHE_SIZE = 12;
    private static List<ResolvlerCacheEntry> RESOLVER_CACHE = new ArrayList<ResolvlerCacheEntry>(12);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static INamespaceDefinitionResolver addResolverToCache(IProject project) {
        List<ResolvlerCacheEntry> list = RESOLVER_CACHE;
        synchronized (list) {
            int nEntries = RESOLVER_CACHE.size();
            if (nEntries >= 12) {
                ResolvlerCacheEntry oldest = null;
                ArrayList<ResolvlerCacheEntry> obsoleteClassLoaders = new ArrayList<ResolvlerCacheEntry>(12);
                int i = 0;
                while (i < nEntries) {
                    ResolvlerCacheEntry entry = RESOLVER_CACHE.get(i);
                    IProject curr = entry.getProject();
                    if (!(curr.exists() && curr.isAccessible() && curr.isOpen())) {
                        obsoleteClassLoaders.add(entry);
                    } else if (oldest == null || entry.getLastAccess() < oldest.getLastAccess()) {
                        oldest = entry;
                    }
                    ++i;
                }
                if (!obsoleteClassLoaders.isEmpty()) {
                    i = 0;
                    while (i < obsoleteClassLoaders.size()) {
                        ProjectClasspathNamespaceDefinitionResolverCache.removeResolverEntryFromCache((ResolvlerCacheEntry)obsoleteClassLoaders.get(i));
                        ++i;
                    }
                } else if (oldest != null) {
                    ProjectClasspathNamespaceDefinitionResolverCache.removeResolverEntryFromCache(oldest);
                }
            }
            ResolvlerCacheEntry newEntry = new ResolvlerCacheEntry(project);
            RESOLVER_CACHE.add(newEntry);
            return newEntry.getResolver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static INamespaceDefinitionResolver findResolverInCache(IProject project) {
        List<ResolvlerCacheEntry> list = RESOLVER_CACHE;
        synchronized (list) {
            int i = RESOLVER_CACHE.size() - 1;
            while (i >= 0) {
                ResolvlerCacheEntry entry = RESOLVER_CACHE.get(i);
                IProject curr = entry.getProject();
                if (!(curr.exists() && curr.isAccessible() && curr.isOpen())) {
                    ProjectClasspathNamespaceDefinitionResolverCache.removeResolverEntryFromCache(entry);
                } else if (entry.matches(project)) {
                    entry.markAsAccessed();
                    return entry.getResolver();
                }
                --i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeResolverEntryFromCache(ResolvlerCacheEntry entry) {
        List<ResolvlerCacheEntry> list = RESOLVER_CACHE;
        synchronized (list) {
            entry.dispose();
            RESOLVER_CACHE.remove(entry);
        }
    }

    public static synchronized INamespaceDefinitionResolver getResolver(IProject project) {
        INamespaceDefinitionResolver resolver = ProjectClasspathNamespaceDefinitionResolverCache.findResolverInCache(project);
        if (resolver == null) {
            resolver = ProjectClasspathNamespaceDefinitionResolverCache.addResolverToCache(project);
        }
        return resolver;
    }

    private static class ResolvlerCacheEntry
    implements IElementChangedListener {
        private long lastAccess;
        private IProject project;
        private ProjectClasspathNamespaceDefinitionResolver resolver;

        public ResolvlerCacheEntry(IProject project) {
            this.project = project;
            this.resolver = new ProjectClasspathNamespaceDefinitionResolver(project);
            this.markAsAccessed();
            JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
        }

        public void dispose() {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            this.resolver.dispose();
            this.resolver = null;
        }

        public void elementChanged(ElementChangedEvent event) {
            IJavaProject javaProject = JdtUtils.getJavaProject((IProject)this.project);
            if (javaProject != null) {
                IJavaElementDelta[] iJavaElementDeltaArray = event.getDelta().getAffectedChildren();
                int n = iJavaElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta delta = iJavaElementDeltaArray[n2];
                    if (((delta.getFlags() & 0x200000) != 0 || (delta.getFlags() & 0x20000) != 0) && (javaProject.equals(delta.getElement()) || javaProject.isOnClasspath(delta.getElement()))) {
                        ProjectClasspathNamespaceDefinitionResolverCache.removeResolverEntryFromCache(this);
                    }
                    ++n2;
                }
            }
        }

        public INamespaceDefinitionResolver getResolver() {
            return this.resolver;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        public IProject getProject() {
            return this.project;
        }

        public void markAsAccessed() {
            this.lastAccess = System.currentTimeMillis();
        }

        public boolean matches(IProject project) {
            return this.project.equals((Object)project);
        }
    }
}

