/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.xsd.impl.XSDElementDeclarationImpl;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.ide.eclipse.beans.core.internal.model.UniqueBeanNameGenerator;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.SpringCorePreferences;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolAnnotationBasedNamespaceHandler
implements NamespaceHandler {
    private static final String DEFAULT_ID_XPATH = "@id";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String IDENTIFIER_ATTRIBUTE = "identifier";
    private static final String EXPORTS_ELEMENT = "exports";
    private static final String ANNOTATION_ELEMENT = "annotation";
    private static final String TOOL_NAMESPACE_URI = "http://www.springframework.org/schema/tool";
    private final IBeansConfig beansConfig;

    public ToolAnnotationBasedNamespaceHandler(IBeansConfig file) {
        this.beansConfig = file;
    }

    public BeanDefinitionHolder decorate(Node source, BeanDefinitionHolder definition, ParserContext parserContext) {
        return definition;
    }

    public void init() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        ComponentDefinition componentDefinition = this.parseElement(element, parserContext);
        if (componentDefinition != null) {
            if (componentDefinition instanceof BeanComponentDefinition) {
                parserContext.registerBeanComponent((BeanComponentDefinition)componentDefinition);
                return ((BeanComponentDefinition)componentDefinition).getBeanDefinition();
            }
            parserContext.registerComponent(componentDefinition);
        } else if (!SpringCorePreferences.getProjectPreferences((IProject)this.beansConfig.getElementResource().getProject(), (String)"org.springframework.ide.eclipse.beans.core").getBoolean("ignoreMissingNamespaceHandler", false)) {
            parserContext.getReaderContext().warning("Unable to locate Spring NamespaceHandler for element '" + element.getNodeName() + "' of schema namespace '" + element.getNamespaceURI() + "'", parserContext.extractSource((Object)element));
        }
        return null;
    }

    private ComponentDefinition parseElement(Node element, ParserContext parserContext) {
        ComponentDefinition rootComponent = this.parseSingleElement(element, parserContext);
        ArrayList<ComponentDefinition> nestedComponents = new ArrayList<ComponentDefinition>();
        NodeList nestedElements = element.getChildNodes();
        int i = 0;
        while (i < nestedElements.getLength()) {
            ComponentDefinition nestedComponent;
            Node nestedElement = nestedElements.item(i);
            if (nestedElement.getNodeType() == 1 && (nestedComponent = this.parseElement(nestedElement, parserContext)) != null) {
                nestedComponents.add(nestedComponent);
            }
            ++i;
        }
        if (nestedComponents.size() > 0) {
            CompositeComponentDefinition compositeComponentDefinition = new CompositeComponentDefinition(element.getNodeName(), parserContext.extractSource((Object)element));
            for (ComponentDefinition componentDefinition : nestedComponents) {
                compositeComponentDefinition.addNestedComponent(componentDefinition);
            }
            return compositeComponentDefinition;
        }
        return rootComponent;
    }

    private ComponentDefinition parseSingleElement(Node element, ParserContext parserContext) {
        IStructuredModel model = null;
        try {
            model = this.getStructuredModel();
            if (model != null) {
                String localName = element.getLocalName();
                String namespaceUri = element.getNamespaceURI();
                IDOMDocument document = ((DOMModelImpl)model).getDocument();
                NodeList nodes = document.getElementsByTagNameNS(namespaceUri, localName);
                if (nodes.getLength() > 0) {
                    CMElementDeclaration result;
                    Node node = nodes.item(0);
                    ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
                    if (modelQuery != null && (result = modelQuery.getCMElementDeclaration((Element)node)) instanceof XSDImpl.XSDElementDeclarationAdapter) {
                        XSDElementDeclarationImpl elementDeclaration = (XSDElementDeclarationImpl)((XSDImpl.XSDElementDeclarationAdapter)result).getKey();
                        ComponentDefinition componentDefinition = null;
                        if (elementDeclaration.getAnnotation() != null) {
                            componentDefinition = this.processAnnotations(element, (List<Element>)elementDeclaration.getAnnotation().getApplicationInformation(), parserContext);
                        }
                        if (componentDefinition == null && elementDeclaration.getTypeDefinition() != null && elementDeclaration.getTypeDefinition().getAnnotation() != null) {
                            componentDefinition = this.processAnnotations(element, (List<Element>)elementDeclaration.getTypeDefinition().getAnnotation().getApplicationInformation(), parserContext);
                        }
                        ComponentDefinition componentDefinition2 = componentDefinition;
                        return componentDefinition2;
                    }
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    private ComponentDefinition processAnnotations(Node element, List<Element> appInfos, ParserContext parserContext) {
        for (Element elem : appInfos) {
            NodeList annotations = elem.getChildNodes();
            int j = 0;
            while (j < annotations.getLength()) {
                Node toolAnnotationElement = annotations.item(j);
                if (toolAnnotationElement.getNodeType() == 1 && ANNOTATION_ELEMENT.equals(toolAnnotationElement.getLocalName()) && TOOL_NAMESPACE_URI.equals(toolAnnotationElement.getNamespaceURI())) {
                    NodeList specialToolAnnotationElements = toolAnnotationElement.getChildNodes();
                    int k = 0;
                    while (k < specialToolAnnotationElements.getLength()) {
                        Node specialToolAnnotation = specialToolAnnotationElements.item(k);
                        if (specialToolAnnotation.getNodeType() == 1 && EXPORTS_ELEMENT.equals(specialToolAnnotation.getLocalName())) {
                            return this.createBeanComponentDefinition(element, parserContext, specialToolAnnotation);
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        return null;
    }

    protected ComponentDefinition createBeanComponentDefinition(Node element, ParserContext parserContext, Node specialToolAnnotation) {
        NamedNodeMap attributes = specialToolAnnotation.getAttributes();
        String id = attributes.getNamedItem(IDENTIFIER_ATTRIBUTE) != null ? attributes.getNamedItem(IDENTIFIER_ATTRIBUTE).getTextContent() : DEFAULT_ID_XPATH;
        String type = attributes.getNamedItem(TYPE_ATTRIBUTE) != null ? attributes.getNamedItem(TYPE_ATTRIBUTE).getTextContent() : null;
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClassName(type);
        beanDefinition.setSource(parserContext.extractSource((Object)element));
        beanDefinition.setRole(2);
        return new BeanComponentDefinition((BeanDefinition)beanDefinition, this.getIdentifier(element, id, (BeanDefinition)beanDefinition));
    }

    protected String getIdentifier(Node element, String identifierExpression, BeanDefinition beanDefinition) {
        String identifier = null;
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath path = factory.newXPath();
            identifier = path.evaluate(identifierExpression, element);
        }
        catch (XPathExpressionException xPathExpressionException) {}
        if (!StringUtils.hasText(identifier)) {
            identifier = UniqueBeanNameGenerator.generateBeanName(beanDefinition, this.beansConfig);
        }
        return identifier;
    }

    private IStructuredModel getStructuredModel() throws IOException, CoreException {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead((IFile)this.beansConfig.getElementResource());
        if (model == null) {
            model = StructuredModelManager.getModelManager().getModelForRead((IFile)this.beansConfig.getElementResource());
        }
        return model;
    }
}

