/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.springframework.beans.factory.xml.DocumentDefaultsDefinition;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanAlias;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.core.io.ExternalFile;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;

public class ImportedBeansConfig
extends AbstractBeansConfig
implements IImportedBeansConfig {
    private IModelElement[] children = null;

    public ImportedBeansConfig(IBeansImport beansImport, Resource resource, IBeansConfig.Type type) {
        super(beansImport, resource.getFilename(), type);
        this.init(resource);
    }

    public IModelElement[] getElementChildren() {
        return this.children;
    }

    protected void readConfig() {
        if (!this.isModelPopulated) {
            try {
                this.w.lock();
                if (this.isModelPopulated) {
                    return;
                }
                this.imports = new CopyOnWriteArraySet();
                this.aliases = new LinkedHashMap();
                this.components = new LinkedHashSet();
                this.beans = new LinkedHashMap();
                this.problems = new CopyOnWriteArraySet();
            }
            finally {
                this.w.unlock();
            }
        }
    }

    protected void readFinish() {
        this.isModelPopulated = true;
        ArrayList allChildren = new ArrayList(this.imports);
        allChildren.addAll(this.aliases.values());
        allChildren.addAll(this.components);
        allChildren.addAll(this.beans.values());
        Collections.sort(allChildren, new Comparator<ISourceModelElement>(){

            @Override
            public int compare(ISourceModelElement element1, ISourceModelElement element2) {
                return element1.getElementStartLine() - element2.getElementStartLine();
            }
        });
        this.children = allChildren.toArray(new IModelElement[allChildren.size()]);
    }

    protected void addBean(IBean bean) {
        this.beans.put(bean.getElementName(), bean);
    }

    protected void addComponent(IBeansComponent beansComponent) {
        this.components.add(beansComponent);
    }

    protected void addAlias(IBeanAlias beanAlias) {
        this.aliases.put(beanAlias.getElementName(), beanAlias);
    }

    protected void setDefaults(DocumentDefaultsDefinition defaultsDefinition) {
        this.defaults = defaultsDefinition;
    }

    protected void addImport(IBeansImport beansImport) {
        this.imports.add(beansImport);
    }

    private void init(Resource resource) {
        if (resource instanceof IAdaptable) {
            if (((IAdaptable)resource).getAdapter(ZipEntryStorage.class) != null) {
                ZipEntryStorage storage = (ZipEntryStorage)((IAdaptable)resource).getAdapter(ZipEntryStorage.class);
                this.file = storage.getFile();
                this.setElementName(storage.getFullName());
                this.isArchived = true;
            } else if (((IAdaptable)resource).getAdapter(IFile.class) != null) {
                this.file = (IFile)((IAdaptable)resource).getAdapter(IFile.class);
                this.isArchived = this.file instanceof ExternalFile;
            }
        }
        if (this.file == null || !this.file.isAccessible()) {
            this.modificationTimestamp = -1L;
            String msg = "Imported Beans config file '" + resource + "' not accessible";
            this.problems = new CopyOnWriteArraySet();
            this.problems.add(new ValidationProblem(2, msg, (IResource)this.file, -1, new ValidationProblemAttribute[0]));
        } else {
            this.modificationTimestamp = this.file.getModificationStamp();
        }
    }
}

