/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.parsing.ImportDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansImport
extends AbstractBeansModelElement
implements IBeansImport {
    private String resourcePath;
    private Set<IImportedBeansConfig> beansConfigs = new LinkedHashSet<IImportedBeansConfig>();

    public BeansImport(IBeansConfig config, ImportDefinition definition) {
        super((IModelElement)config, definition.getImportedResource(), (BeanMetadataElement)definition);
        this.resourcePath = StringUtils.cleanPath((String)definition.getImportedResource());
    }

    public int getElementType() {
        return 5;
    }

    public IModelElement[] getElementChildren() {
        LinkedHashSet<IImportedBeansConfig> children = new LinkedHashSet<IImportedBeansConfig>(this.getImportedBeansConfigs());
        return children.toArray(new IModelElement[children.size()]);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansImport)) {
            return false;
        }
        BeansImport that = (BeansImport)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.resourcePath, (Object)that.resourcePath)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.resourcePath);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(": resource=");
        text.append(this.resourcePath);
        return text.toString();
    }

    @Override
    public Set<IImportedBeansConfig> getImportedBeansConfigs() {
        return this.beansConfigs;
    }

    protected void addImportedBeansConfig(IImportedBeansConfig importedBeansConfig) {
        this.beansConfigs.add(importedBeansConfig);
    }
}

