/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IPersistableElement;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelElementToPersistableElementAdapter;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanAlias;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.model.AbstractResourceModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansConfigSet
extends AbstractResourceModelElement
implements IBeansConfigSet {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    protected Set<String> configNames;
    private volatile boolean allowAliasOverriding;
    private volatile boolean allowBeanDefinitionOverriding;
    private volatile boolean isIncomplete;
    private volatile Map<String, IBeanAlias> aliasesMap;
    private volatile boolean isAliasesMapPopulated = false;
    private volatile Set<IBeansComponent> components;
    private volatile boolean isComponentsPopulated = false;
    private volatile Map<String, IBean> beansMap;
    private volatile boolean isBeansMapPopulated = false;
    private volatile Map<String, Set<IBean>> beanClassesMap;
    private volatile boolean isBeanClassesMapPopulated = false;
    private volatile IBeansConfigSet.Type type;
    private volatile Set<String> profiles;

    public BeansConfigSet(IBeansProject project, String name, IBeansConfigSet.Type type) {
        this(project, name, new LinkedHashSet<String>(), type);
    }

    public BeansConfigSet(IBeansProject project, String name, Set<String> configNames, IBeansConfigSet.Type type) {
        super((IModelElement)project, name);
        this.configNames = new LinkedHashSet<String>(configNames);
        this.allowAliasOverriding = true;
        this.allowBeanDefinitionOverriding = true;
        this.type = type;
        this.profiles = new LinkedHashSet<String>();
    }

    public void reset() {
        try {
            this.w.lock();
            this.aliasesMap = null;
            this.isAliasesMapPopulated = false;
            this.components = null;
            this.isComponentsPopulated = false;
            this.beansMap = null;
            this.isBeansMapPopulated = false;
            this.beanClassesMap = null;
            this.isBeanClassesMapPopulated = false;
        }
        finally {
            this.w.unlock();
        }
    }

    public int getElementType() {
        return 4;
    }

    public IModelElement[] getElementChildren() {
        Set<IBeansConfig> children = this.getConfigs();
        return children.toArray(new IModelElement[children.size()]);
    }

    public IResource getElementResource() {
        return ((IBeansProject)this.getElementParent()).getProject();
    }

    public boolean isElementArchived() {
        return false;
    }

    public void setAllowAliasOverriding(boolean allowAliasOverriding) {
        this.allowAliasOverriding = allowAliasOverriding;
        this.reset();
    }

    @Override
    public boolean isAllowAliasOverriding() {
        return this.allowAliasOverriding;
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
        this.reset();
    }

    @Override
    public boolean isAllowBeanDefinitionOverriding() {
        return this.allowBeanDefinitionOverriding;
    }

    public void setIncomplete(boolean isIncomplete) {
        this.isIncomplete = isIncomplete;
    }

    @Override
    public boolean isIncomplete() {
        return this.isIncomplete;
    }

    public void addConfig(String configName) {
        if (configName.length() > 0 && !this.getConfigNames().contains(configName)) {
            try {
                this.w.lock();
                this.configNames.add(configName);
            }
            finally {
                this.w.unlock();
            }
            this.reset();
        }
    }

    @Override
    public boolean hasConfig(String configName) {
        return this.getConfigNames().contains(configName);
    }

    @Override
    public boolean hasConfig(IFile file) {
        if (file == null) {
            return false;
        }
        if (file.getProject().equals((Object)((IBeansProject)this.getElementParent()).getProject())) {
            return this.getConfigNames().contains(file.getProjectRelativePath().toString());
        }
        return this.getConfigNames().contains(file.getFullPath().toString());
    }

    public void removeConfig(String configName) {
        try {
            this.w.lock();
            this.configNames.remove(configName);
        }
        finally {
            this.w.unlock();
        }
        this.reset();
    }

    public void removeAllConfigs() {
        try {
            this.w.lock();
            this.configNames.clear();
        }
        finally {
            this.w.unlock();
        }
        this.reset();
    }

    @Override
    public Set<IBeansConfig> getConfigs() {
        LinkedHashSet<IBeansConfig> configs = new LinkedHashSet<IBeansConfig>();
        for (String configName : this.getConfigNames()) {
            IBeansConfig config = BeansModelUtils.getConfig(configName, this);
            if (config == null) continue;
            configs.add(config);
        }
        return configs;
    }

    @Override
    public Set<String> getConfigNames() {
        try {
            this.r.lock();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.configNames);
            return linkedHashSet;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public boolean hasAlias(String name) {
        return this.getAliasesMap().containsKey(name);
    }

    @Override
    public IBeanAlias getAlias(String name) {
        return this.getAliasesMap().get(name);
    }

    @Override
    public Set<IBeanAlias> getAliases() {
        return new LinkedHashSet<IBeanAlias>(this.getAliasesMap().values());
    }

    @Override
    public Set<IBeansComponent> getComponents() {
        return new LinkedHashSet<IBeansComponent>(this.getComponentsList());
    }

    @Override
    public boolean hasBean(String name) {
        return this.getBeansMap().containsKey(name);
    }

    @Override
    public IBean getBean(String name) {
        return this.getBeansMap().get(name);
    }

    @Override
    public Set<IBean> getBeans() {
        return new LinkedHashSet<IBean>(this.getBeansMap().values());
    }

    @Override
    public boolean isBeanClass(String className) {
        return this.getBeanClassesMap().containsKey(className);
    }

    @Override
    public Set<String> getBeanClasses() {
        return new LinkedHashSet<String>(this.getBeanClassesMap().keySet());
    }

    @Override
    public Set<IBean> getBeans(String className) {
        if (this.isBeanClass(className)) {
            return new LinkedHashSet<IBean>((Collection)this.getBeanClassesMap().get(className));
        }
        return new HashSet<IBean>();
    }

    public String toString() {
        try {
            this.r.lock();
            String string = String.valueOf(this.getElementName()) + ": " + this.configNames.toString();
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    private Map<String, IBeanAlias> getAliasesMap() {
        if (!this.isAliasesMapPopulated) {
            try {
                this.w.lock();
                if (this.isAliasesMapPopulated) {
                    Map<String, IBeanAlias> map = this.aliasesMap;
                    return map;
                }
                this.aliasesMap = new LinkedHashMap<String, IBeanAlias>();
                for (String configName : this.configNames) {
                    IBeansConfig config = BeansModelUtils.getConfig(configName, this);
                    if (config == null) continue;
                    for (IBeanAlias alias : config.getAliases()) {
                        if (!this.allowAliasOverriding && this.aliasesMap.containsKey(alias.getElementName())) continue;
                        this.aliasesMap.put(alias.getElementName(), alias);
                    }
                }
            }
            finally {
                this.isAliasesMapPopulated = true;
                this.w.unlock();
            }
        }
        try {
            this.r.lock();
            Map<String, IBeanAlias> map = this.aliasesMap;
            return map;
        }
        finally {
            this.r.unlock();
        }
    }

    private Set<IBeansComponent> getComponentsList() {
        if (!this.isComponentsPopulated) {
            try {
                this.w.lock();
                if (this.isComponentsPopulated) {
                    Set<IBeansComponent> set = this.components;
                    return set;
                }
                this.components = new LinkedHashSet<IBeansComponent>();
                for (String configName : this.configNames) {
                    IBeansConfig config = BeansModelUtils.getConfig(configName, this);
                    if (config == null) continue;
                    for (IBeansComponent component : config.getComponents()) {
                        this.components.add(component);
                    }
                }
            }
            finally {
                this.isComponentsPopulated = true;
                this.w.unlock();
            }
        }
        try {
            this.r.lock();
            Set<IBeansComponent> set = this.components;
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    private Map<String, IBean> getBeansMap() {
        if (!this.isBeansMapPopulated) {
            try {
                this.w.lock();
                if (this.isBeansMapPopulated) {
                    Map<String, IBean> map = this.beansMap;
                    return map;
                }
                this.beansMap = new LinkedHashMap<String, IBean>();
                for (String configName : this.configNames) {
                    IBeansConfig config = BeansModelUtils.getConfig(configName, this);
                    if (config == null) continue;
                    for (IBean bean : config.getBeans()) {
                        if (!this.allowBeanDefinitionOverriding && this.beansMap.containsKey(bean.getElementName())) continue;
                        this.beansMap.put(bean.getElementName(), bean);
                    }
                }
            }
            finally {
                this.isBeansMapPopulated = true;
                this.w.unlock();
            }
        }
        try {
            this.r.lock();
            Map<String, IBean> map = this.beansMap;
            return map;
        }
        finally {
            this.r.unlock();
        }
    }

    private Map<String, Set<IBean>> getBeanClassesMap() {
        if (!this.isBeanClassesMapPopulated) {
            try {
                this.w.lock();
                if (this.isBeanClassesMapPopulated) {
                    Map<String, Set<IBean>> map = this.beanClassesMap;
                    return map;
                }
                this.beanClassesMap = new LinkedHashMap<String, Set<IBean>>();
                for (IBean bean : this.getBeansMap().values()) {
                    this.addBeanClassToMap(bean);
                    for (IBean innerBean : BeansModelUtils.getInnerBeans(bean)) {
                        this.addBeanClassToMap(innerBean);
                    }
                }
            }
            finally {
                this.isBeanClassesMapPopulated = true;
                this.w.unlock();
            }
        }
        try {
            this.r.lock();
            Map<String, Set<IBean>> map = this.beanClassesMap;
            return map;
        }
        finally {
            this.r.unlock();
        }
    }

    private void addBeanClassToMap(IBean bean) {
        String className = bean.getClassName();
        if (className != null) {
            Set<IBean> beanClassBeans;
            int pos = className.indexOf(36);
            if (pos > 0) {
                className = className.substring(0, pos);
            }
            if ((beanClassBeans = this.beanClassesMap.get(className)) == null) {
                beanClassBeans = new LinkedHashSet<IBean>();
                this.beanClassesMap.put(className, beanClassBeans);
            }
            beanClassBeans.add(bean);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPersistableElement.class) {
            return new BeansModelElementToPersistableElementAdapter(this);
        }
        if (adapter == IProject.class && this.getElementParent() instanceof IBeansProject) {
            return ((IBeansProject)this.getElementParent()).getProject();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IBeansConfigSet.Type getType() {
        return this.type;
    }

    public boolean isExternal() {
        return false;
    }

    @Override
    public Set<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Set<String> profiles) {
        this.profiles = profiles;
    }

    public void addProfile(String profile) {
        this.profiles.add(profile);
    }

    @Override
    public boolean hasProfiles() {
        return this.profiles != null && this.profiles.size() > 0;
    }
}

