/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansModelElement;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansValueHolder;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.util.ObjectUtils;

public abstract class AbstractBeansValueHolder
extends AbstractBeansModelElement
implements IBeansValueHolder {
    private boolean isResolved = false;
    private Object value;

    protected AbstractBeansValueHolder(IModelElement parent, String name, Object value, BeanMetadataElement metadata) {
        super(parent, name, metadata);
        this.value = value;
    }

    public IModelElement[] getElementChildren() {
        Object val = this.getValue();
        if (val instanceof IModelElement) {
            return new IModelElement[]{(IModelElement)val};
        }
        return NO_CHILDREN;
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor) && this.value instanceof IModelElement) {
            ((IModelElement)this.value).accept(visitor, monitor);
            if (monitor.isCanceled()) {
                return;
            }
        }
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        if (!this.isResolved) {
            this.value = BeansModelUtils.resolveValueIfNecessary(this, this.value);
        }
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractBeansValueHolder)) {
            return false;
        }
        AbstractBeansValueHolder that = (AbstractBeansValueHolder)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.getValue(), (Object)that.getValue())) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.getValue());
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(": value=");
        text.append(this.getValue());
        return text.toString();
    }
}

