/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core;

import org.springframework.core.NestedRuntimeException;
import org.springframework.ide.eclipse.core.io.xml.LineNumberPreservingDOMParser;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class BeanDefinitionException
extends NestedRuntimeException {
    private static final long serialVersionUID = 1L;
    private final transient int lineNumber;

    public BeanDefinitionException(Node node, String message, Throwable cause) {
        super(message, cause);
        this.lineNumber = LineNumberPreservingDOMParser.getStartLineNumber((Node)node);
    }

    public BeanDefinitionException(Node node, String message) {
        super(message);
        this.lineNumber = LineNumberPreservingDOMParser.getStartLineNumber((Node)node);
    }

    public BeanDefinitionException(Node node, Throwable cause) {
        super(cause.getMessage(), cause);
        this.lineNumber = LineNumberPreservingDOMParser.getStartLineNumber((Node)node);
    }

    public BeanDefinitionException(int lineNumber, String message, Throwable cause) {
        super(message, cause);
        this.lineNumber = lineNumber;
    }

    public BeanDefinitionException(int lineNumber, String message) {
        super(message);
        this.lineNumber = lineNumber;
    }

    public BeanDefinitionException(int lineNumber, Throwable cause) {
        super(cause.getMessage(), cause);
        this.lineNumber = lineNumber;
    }

    public BeanDefinitionException(String message) {
        super(message);
        this.lineNumber = -1;
    }

    public BeanDefinitionException(Throwable cause) {
        super(cause.getMessage(), cause);
        int line = -1;
        if (cause instanceof SAXParseException) {
            line = ((SAXParseException)cause).getLineNumber();
        }
        this.lineNumber = line;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        return this.getCause() != null ? this.getCause().getMessage() : super.getMessage();
    }
}

