/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.mylyn;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.osgi.framework.BundleContext;
import org.springframework.ide.eclipse.beans.mylyn.ui.BeansActiveFoldingEditorTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.beans.ui.mylyn";
    private static Activator plugin;
    private BeansActiveFoldingEditorTracker editorTracker;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Activator.this.installEditorTracker(workbench);
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void installEditorTracker(IWorkbench workbench) {
        this.editorTracker = new BeansActiveFoldingEditorTracker();
        this.editorTracker.install(workbench);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    IEditorPart part = references[i].getEditor(false);
                    if (part != null && part instanceof XMLMultiPageEditorPart) {
                        XMLMultiPageEditorPart editor = (XMLMultiPageEditorPart)part;
                        this.editorTracker.registerEditor((IEditorPart)editor);
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }
}

